--创建影像类型模型表
CREATE TABLE tbimg_datumtype
(
    f_id           varchar(32) NOT NULL PRIMARY KEY,
    f_name         varchar(200) NULL,
    f_desc         varchar(500) NULL,
    f_isgroup      int4 NULL,
    f_pid          varchar(32) NULL,
    f_order        int4 NULL,
    f_filemodelids varchar(2000) NULL
);

COMMENT ON TABLE tbimg_datumtype IS '影像类型模型';
COMMENT ON COLUMN tbimg_datumtype.f_id IS '标识';
COMMENT ON COLUMN tbimg_datumtype.f_desc IS '备注';
COMMENT ON COLUMN tbimg_datumtype.f_isgroup IS '是否为分组';
COMMENT ON COLUMN tbimg_datumtype.f_pid IS '父节点标识';
COMMENT ON COLUMN tbimg_datumtype.f_order IS '顺序';
COMMENT ON COLUMN tbimg_datumtype.f_filemodelids IS '文件结构模型标识，多个用逗号隔开';

CREATE TABLE tbimg_datumtypefield
(
    f_id           varchar(32) NOT NULL PRIMARY KEY,
    f_datumtypeid  varchar(32) NULL,
    f_name         varchar(100) NULL,
    f_aliasname    varchar(500) NULL,
    f_fieldtype    int4 NULL,
    f_length       int4 NULL,
    f_defaultvalue varchar(2000) NULL,
    f_nullable     int4 NULL,
    f_issysfield   int4 NULL,
    f_fieldid      varchar(32) NULL,
    f_identify     int4 NULL,
    f_datumname    int4 NULL,
    f_display      int4 NULL,
    f_canquery     int4 NULL
);
CREATE INDEX tbimg_datumtypefield_f_datumtypeid_idx ON tbimg_datumtypefield USING btree (f_datumtypeid);
CREATE INDEX tbimg_datumtypefield_f_fieldid_idx ON tbimg_datumtypefield USING btree (f_fieldid);

COMMENT ON TABLE tbimg_datumtypefield IS '影像类型模型字段';

COMMENT ON COLUMN tbimg_datumtypefield.f_id IS '标识';
COMMENT ON COLUMN tbimg_datumtypefield.f_datumtypeid IS '影像类型模型标识';
COMMENT ON COLUMN tbimg_datumtypefield.f_name IS '名称';
COMMENT ON COLUMN tbimg_datumtypefield.f_aliasname IS '别名';
COMMENT ON COLUMN tbimg_datumtypefield.f_fieldtype IS '字段类型';
COMMENT ON COLUMN tbimg_datumtypefield.f_length IS '字段长度';
COMMENT ON COLUMN tbimg_datumtypefield.f_defaultvalue IS '默认值';
COMMENT ON COLUMN tbimg_datumtypefield.f_nullable IS '允许为空';
COMMENT ON COLUMN tbimg_datumtypefield.f_issysfield IS '是否为系统字段';
COMMENT ON COLUMN tbimg_datumtypefield.f_fieldid IS '字段管理中的字段标识';
COMMENT ON COLUMN tbimg_datumtypefield.f_identify IS '是否为标识字段';
COMMENT ON COLUMN tbimg_datumtypefield.f_datumname IS '是否为名称字段';
COMMENT ON COLUMN tbimg_datumtypefield.f_display IS '是否展示';
COMMENT ON COLUMN tbimg_datumtypefield.f_canquery IS '是否可查询';

ALTER TABLE tbimg_datumtypefield ADD CONSTRAINT tbimg_datumtypefield_fk FOREIGN KEY (f_datumtypeid) REFERENCES tbimg_datumtype(f_id) ON DELETE CASCADE;