/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.constant.CatalogFileTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetMetaDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import com.geoway.imagedb.apply.dao.ImgPushDao;
import com.geoway.imagedb.apply.dto.push.ImagePushFilterDTO;
import com.geoway.imagedb.apply.entity.ImgPush;
import com.geoway.imagedb.apply.service.ImagePushService;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.match.ImageMatchDataDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.util.ImageDataMatchUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ImagePushServiceImpl
implements ImagePushService {
    private static final Logger log = LoggerFactory.getLogger(ImagePushServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private FileDataService fileDataService;
    @Resource
    private FileStorageService fileStorageService;
    @Resource
    private ImgPushDao imgPushDao;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    private String sampleBusinessDatasetId = "";

    @Override
    public ImgPush pushImageData(ImagePushFilterDTO filterDTO) {
        if (filterDTO.getDataIdArray() == null || filterDTO.getDataIdArray().size() == 0) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6edataId\uff01");
        }
        List filters = ListUtil.convertAll(filterDTO.getDataIdArray(), f -> String.format("%s = '%s'", "F_DATAID", f));
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(Integer.valueOf(filterDTO.getDataIdArray().size()));
        queryFilterDTO.setCondition(String.join((CharSequence)" or ", filters));
        String businessDatasetId = "";
        ImageDatasetTypeEnum imageDatasetType = ImageDatasetTypeEnum.getByValue((Integer)filterDTO.getImageType());
        if (imageDatasetType == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6eImageType\uff01");
        }
        switch (imageDatasetType) {
            case ImageSampleImageDataset: 
            case TileSampleImageDataset: {
                businessDatasetId = this.getSampleBusinessDatasetId();
                break;
            }
            default: {
                businessDatasetId = this.imageDatasetService.getBusinessSnapshotDatasetId();
            }
        }
        DataQueryResult dataQueryResult = this.dataSourceService.queryData(businessDatasetId, queryFilterDTO);
        if (dataQueryResult == null || dataQueryResult.getData() == null || dataQueryResult.getData().size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u67e5\u8be2\u5230\u5f71\u50cf\u6570\u636e");
        }
        HashMap<String, List<String>> datasetIdDataIdMap = new HashMap<String, List<String>>(0);
        ArrayList<String> dataIdList = new ArrayList<String>();
        HashMap<String, JSONObject> dataIdDataMap = new HashMap<String, JSONObject>(0);
        JSONObject json = new JSONObject();
        if ("JY".equals(filterDTO.getSystemID()) && imageDatasetType == ImageDatasetTypeEnum.TileSampleImageDataset) {
            json.put("SampleType", (Object)0);
        } else {
            json.put("taskId", (Object)filterDTO.getTaskId());
            json.put("type", (Object)filterDTO.getType());
            json.put("module", (Object)filterDTO.getModule());
            json.put("systemID", (Object)filterDTO.getSystemID());
        }
        ArrayList<ImageMatchDataDTO> needMatchDataList = new ArrayList<ImageMatchDataDTO>();
        block12: for (FeatureResult item : dataQueryResult.getData()) {
            String dataId;
            String datasetId = item.getAttributes().get("f_image_dataset_id").toString();
            switch (imageDatasetType) {
                case ProcessedImageDataset: {
                    dataId = item.getAttributes().get("F_DATAID").toString();
                    if (datasetIdDataIdMap.containsKey(datasetId)) {
                        ((List)datasetIdDataIdMap.get(datasetId)).add(dataId);
                        break;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(dataId);
                    datasetIdDataIdMap.put(datasetId, list);
                    break;
                }
                case OriginalImageDataset: {
                    String satellite;
                    dataId = item.getAttributes().get("F_DATAID").toString();
                    Object satelliteObj = item.getAttributes().get("f_satellite");
                    String string = satellite = satelliteObj == null ? "" : satelliteObj.toString();
                    if (Arrays.stream(ImageDataMatchUtil.GF7_SATELLITE).anyMatch(f -> f.equalsIgnoreCase(satellite)) || Arrays.stream(ImageDataMatchUtil.ZY_SATELLITE).anyMatch(f -> f.equalsIgnoreCase(satellite))) {
                        ImageMatchDataDTO needMatchData = new ImageMatchDataDTO();
                        needMatchData.setDataId(dataId);
                        Object dataNameObj = item.getAttributes().get("F_DATANAME");
                        String dataName = dataNameObj == null ? "" : dataNameObj.toString();
                        log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u5339\u914d\u5f00\u59cb...", dataName));
                        String dataNamePrefix = ImageDataMatchUtil.getDataNamePrefix((String)dataName, (String)satellite);
                        ImageMatchDataDTO matchData = (ImageMatchDataDTO)ListUtil.find(needMatchDataList, f -> f.getDataName().toLowerCase(Locale.ROOT).startsWith(dataNamePrefix));
                        if (matchData == null) {
                            needMatchData.setDataName(dataName);
                            needMatchData.setSatellite(satellite);
                            needMatchData.setMatchDataNamePrefix(dataNamePrefix);
                            needMatchDataList.add(needMatchData);
                            log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u8fdb\u5165\u5f85\u5339\u914d\u533a", dataName));
                            break;
                        }
                        log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u5339\u914d[%s]", dataName, matchData.getDataName()));
                        needMatchDataList.remove(matchData);
                        dataIdList.add(dataId);
                        break;
                    }
                    dataIdList.add(dataId);
                    break;
                }
                case ImageSampleImageDataset: 
                case TileSampleImageDataset: {
                    dataId = item.getAttributes().get("F_DATAID".toLowerCase(Locale.ROOT)).toString();
                    dataIdList.add(dataId);
                    if ("JY".equals(filterDTO.getSystemID())) {
                        if (!json.containsKey((Object)"SceneType")) {
                            int sceneType = 1;
                            Object sceneTypeObj = item.getAttributes().get("scenetype");
                            if (sceneTypeObj != null && sceneTypeObj.toString().contains("\u53d8\u5316")) {
                                sceneType = 2;
                            }
                            if (sceneTypeObj != null && "2".equals(sceneTypeObj.toString())) {
                                sceneType = 2;
                            }
                            json.put("SceneType", (Object)sceneType);
                        }
                        if (json.containsKey((Object)"SampleScheme")) continue block12;
                        Object sampleSchemeObj = item.getAttributes().get("samplescheme");
                        json.put("SampleScheme", (Object)(sampleSchemeObj == null ? "" : sampleSchemeObj.toString()));
                        continue block12;
                    }
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5f71\u50cf\u6570\u636e\u96c6\u7c7b\u578b");
                }
            }
            JSONObject data = new JSONObject();
            if ("JY".equals(filterDTO.getSystemID())) {
                data.put("imageName", item.getAttributes().get("F_DATANAME"));
            } else {
                data.put("name", item.getAttributes().get("F_DATANAME"));
                data.put("geometry", (Object)item.getGeometry());
            }
            data.put("dataId", (Object)dataId);
            data.put("resolution", item.getAttributes().get("f_resolution"));
            data.put("scenetime", item.getAttributes().get("f_product_time"));
            dataIdDataMap.put(dataId, data);
        }
        if (needMatchDataList.size() > 0) {
            dataIdList.addAll(this.getMatchDataIdList(needMatchDataList, dataIdDataMap));
            if (dataIdList.size() == 0) {
                throw new RuntimeException("\u9009\u4e2d\u7684\u6570\u636e\u5747\u65e0\u53ef\u914d\u5bf9\u6570\u636e\uff01");
            }
        }
        JSONArray dataArray = this.completeDataPath(datasetIdDataIdMap, dataIdList, dataIdDataMap, filterDTO.getSystemID(), imageDatasetType);
        switch (imageDatasetType) {
            case ProcessedImageDataset: {
                if ("SC".equals(filterDTO.getSystemID())) {
                    json.put("dataArray", (Object)dataArray);
                    break;
                }
                if (!"JY".equals(filterDTO.getSystemID())) break;
                json.put("imageList", (Object)dataArray);
                json.put("userId", (Object)"111111");
                break;
            }
            case ImageSampleImageDataset: 
            case TileSampleImageDataset: {
                if ("SC".equals(filterDTO.getSystemID())) {
                    json.put("dataArray", (Object)dataArray);
                    break;
                }
                if (!"JY".equals(filterDTO.getSystemID())) break;
                json.put("dataList", (Object)dataArray);
                break;
            }
            default: {
                json.put("dataArray", (Object)dataArray);
            }
        }
        return this.push(json, filterDTO, imageDatasetType);
    }

    private JSONArray completeDataPath(Map<String, List<String>> datasetIdDataIdMap, List<String> dataIdList, Map<String, JSONObject> dataIdDataMap, String systemID, ImageDatasetTypeEnum imageDatasetType) {
        JSONArray dataArray = new JSONArray();
        for (String datasetId : datasetIdDataIdMap.keySet()) {
            QueryFilterDTO filter = new QueryFilterDTO();
            filter.setCondition(String.join((CharSequence)" or ", ListUtil.convertAll(datasetIdDataIdMap.get(datasetId), f -> String.format("%s = '%s'", "F_DATAID", f))));
            filter.setFields("urihash,F_DATAID");
            ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
            String geoDatasetId = imgDataset.getGeoDatasetId();
            DataQueryResult resultItem = this.dataSourceService.queryData(datasetId, filter);
            DatasetMetaDTO datasetMeta = this.dataSourceManager.getDatasetMeta(geoDatasetId);
            String serviceUrl = "";
            if (datasetMeta != null && datasetMeta.getRender() != null) {
                serviceUrl = datasetMeta.getRender().getUrl();
            }
            for (FeatureResult item : resultItem.getData()) {
                String dataId = item.getAttributes().get("F_DATAID").toString();
                JSONObject data = dataIdDataMap.get(dataId);
                if ("SC".equals(systemID)) {
                    data.put("dataPath", item.getAttributes().get("urihash"));
                    data.put("serviceUrl", (Object)serviceUrl);
                    data.put("objectId", item.getObjectId());
                } else if ("JY".equals(systemID)) {
                    data.put("imagePath", item.getAttributes().get("urihash"));
                }
                dataArray.add((Object)data);
            }
        }
        HashMap<String, IFileStorage> serverIdUrlMap = new HashMap<String, IFileStorage>(0);
        if (dataIdList.size() > 0) {
            List fileDataList = this.fileDataService.getFileDataList(dataIdList);
            for (DmFileData item : fileDataList) {
                IFileStorage fileStorage;
                JSONObject data;
                String dataId = item.getDataId();
                List files = JSONArray.parseArray((String)item.getCatalogFiles(), FileDataUnit.class);
                if ("SC".equals(systemID) && imageDatasetType == ImageDatasetTypeEnum.OriginalImageDataset) {
                    String finalDir = StringUtil.isEmptyOrWhiteSpace((String)item.getMainPath()) ? "/" : item.getMainPath().replace("\\", "/");
                    List<String> fileListPaths = this.getFilePaths(serverIdUrlMap, item.getServerId(), finalDir, files, false);
                    data = dataIdDataMap.get(dataId);
                    data.put("files", fileListPaths);
                    dataArray.add((Object)data);
                    continue;
                }
                FileDataUnit file = (FileDataUnit)ListUtil.find((List)files, FileDataUnit::isMainFile);
                String url = "";
                if (!serverIdUrlMap.containsKey(item.getServerId())) {
                    fileStorage = null;
                    try {
                        fileStorage = this.fileStorageService.openFileStorage(item.getServerId());
                    }
                    catch (Exception e) {
                        log.error("\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u670d\u52a1\u5931\u8d25\uff01", (Throwable)e);
                    }
                    if (fileStorage == null) {
                        url = file.getFileSourceLocation();
                    } else {
                        serverIdUrlMap.put(item.getServerId(), fileStorage);
                        url = fileStorage.combinePaths(fileStorage.getStorageUrl(), new String[]{file.getFileLocation()});
                    }
                } else {
                    fileStorage = (IFileStorage)serverIdUrlMap.get(item.getServerId());
                    url = fileStorage.combinePaths(fileStorage.getStorageUrl(), new String[]{file.getFileLocation()});
                }
                if ("JY".equals(systemID)) {
                    dataArray.add((Object)url);
                    continue;
                }
                data = dataIdDataMap.get(dataId);
                data.put("dataPath", (Object)url);
                dataArray.add((Object)data);
            }
        }
        return dataArray;
    }

    private ImgPush push(JSONObject json, ImagePushFilterDTO filterDTO, ImageDatasetTypeEnum imageDatasetType) {
        String property = "";
        if ("SC".equals(filterDTO.getSystemID())) {
            property = "project.push-image-product-url";
        } else if ("JY".equals(filterDTO.getSystemID())) {
            property = "project.push-image-interpret-url";
        } else {
            throw new RuntimeException("\u65e0\u6548\u7684\u7cfb\u7edf\u6807\u8bc6\uff1a" + filterDTO.getSystemID());
        }
        String url = EnvironmentConfig.getProperty((String)property, (String)"http://172.16.67.71:9220/rsmse-sz-seawatch-admin/");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        log.info("\u63a8\u9001\u5f71\u50cf\u6570\u636eURL\uff1a{}", (Object)url);
        ImgPush imgPush = new ImgPush();
        imgPush.setId(UUID.randomUUID().toString().replace("-", ""));
        imgPush.setDataIds(String.join((CharSequence)",", filterDTO.getDataIdArray()));
        imgPush.setTaskId(filterDTO.getTaskId() + "");
        imgPush.setType(filterDTO.getType());
        imgPush.setModule(filterDTO.getModule());
        imgPush.setSystemId(filterDTO.getSystemID());
        imgPush.setPushTime(new Date());
        imgPush.setMsg("");
        String jsonStr = json.toJSONString();
        log.info("\u5f00\u59cb\u63a8\u9001\u5f71\u50cf\u6570\u636e...");
        log.info("\u63a8\u9001\u5f71\u50cf\u6570\u636e\u53c2\u6570\uff1a" + jsonStr);
        String result = "";
        try {
            HashMap<String, String> header = new HashMap<String, String>(0);
            header.put("Content-Type", "application/json;charset=UTF-8");
            if ("SC".equals(filterDTO.getSystemID())) {
                result = HttpClientUtil.doPostJson((String)String.format("%srs/dataSource/add", url), (String)jsonStr, header, (int)30000);
            } else if ("JY".equals(filterDTO.getSystemID())) {
                switch (imageDatasetType) {
                    case TileSampleImageDataset: {
                        result = HttpClientUtil.doPostJson((String)String.format("%sopenApi/outsideSampleImport", url), (String)jsonStr, header, (int)30000);
                        break;
                    }
                    case ProcessedImageDataset: {
                        result = HttpClientUtil.doPostJson((String)String.format("%sopenApi/imageDataImportNew", url), (String)jsonStr, header, (int)30000);
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u63a8\u9001" + imageDatasetType.getDesc() + "\u81f3\u89e3\u8bd1\u7cfb\u7edf\uff01");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5f71\u50cf\u6570\u636e\u5931\u8d25\uff01", (Throwable)e);
            imgPush.setSuccess(ConstantsValue.FALSE_VALUE);
            imgPush.setMsg(e.getMessage());
            this.imgPushDao.insert(imgPush);
            return imgPush;
        }
        imgPush.setExtension(result.length() > 500 ? result.substring(0, 500) : result);
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (resultJson.getInteger("code") == 200) {
            log.info("\u63a8\u9001\u5f71\u50cf\u6570\u636e\u6210\u529f\uff01");
            imgPush.setSuccess(ConstantsValue.TRUE_VALUE);
            this.imgPushDao.insert(imgPush);
            return imgPush;
        }
        log.error("\u63a8\u9001\u5f71\u50cf\u6570\u636e\u5931\u8d25\uff01");
        imgPush.setSuccess(ConstantsValue.FALSE_VALUE);
        imgPush.setMsg(resultJson.getString("msg"));
        this.imgPushDao.insert(imgPush);
        return imgPush;
    }

    private String getSampleBusinessDatasetId() {
        if (StringUtil.isEmptyOrWhiteSpace((String)this.sampleBusinessDatasetId)) {
            DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
            DatasetDTO datasetDTO = this.geoDatabaseService.getDatasetDetail(targetDatabase, DatasetTypeEnum.FeatureClass, "tb_sample_data");
            Assert.notNull((Object)datasetDTO, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
            this.sampleBusinessDatasetId = datasetDTO.getId();
        }
        return this.sampleBusinessDatasetId;
    }

    private List<String> getFilePaths(Map<String, IFileStorage> serverIdUrlMap, String serviceId, String parentDir, List<FileDataUnit> fileList, Boolean onlyKeyFile) {
        ArrayList<String> filePaths = new ArrayList<String>();
        List files = ListUtil.findAll(fileList, f -> FileUtil.getDirectoryName((String)f.getFileLocation()).replace("\\", "/").equals(parentDir));
        for (FileDataUnit file : files) {
            IFileStorage fileStorage;
            if (onlyKeyFile.booleanValue() && !file.isMainFile()) continue;
            String url = "";
            if (!serverIdUrlMap.containsKey(serviceId)) {
                fileStorage = null;
                try {
                    fileStorage = this.fileStorageService.openFileStorage(serviceId);
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u670d\u52a1\u5931\u8d25\uff01", (Throwable)e);
                }
                if (fileStorage == null) {
                    url = file.getFileSourceLocation();
                } else {
                    serverIdUrlMap.put(serviceId, fileStorage);
                    url = fileStorage.combinePaths(fileStorage.getStorageUrl(), new String[]{file.getFileLocation()});
                }
            } else {
                fileStorage = serverIdUrlMap.get(serviceId);
                url = fileStorage.combinePaths(fileStorage.getStorageUrl(), new String[]{file.getFileLocation()});
            }
            filePaths.add(url);
            if (file.getCatalogFileType() != CatalogFileTypeEnum.SingleFolder && file.getCatalogFileType() != CatalogFileTypeEnum.FolderWithChildren) continue;
            String curParentDir = file.getFileLocation().replace("\\", "/");
            filePaths.addAll(this.getFilePaths(serverIdUrlMap, serviceId, curParentDir, fileList, onlyKeyFile));
        }
        return filePaths;
    }

    private List<String> getMatchDataIdList(List<ImageMatchDataDTO> needMatchDataList, Map<String, JSONObject> dataIdDataMap) {
        ArrayList<String> dataIdList = new ArrayList<String>();
        ArrayList<String> conditionList = new ArrayList<String>();
        for (ImageMatchDataDTO item : needMatchDataList) {
            String condition = String.format("lower(%s) like '%s%%'", "F_DATANAME", item.getMatchDataNamePrefix());
            conditionList.add(condition);
        }
        String condition = String.join((CharSequence)" or ", conditionList);
        condition = String.format("f_image_type = %d and (%s)", ImageDatasetTypeEnum.OriginalImageDataset.getValue(), condition);
        log.info(String.format("\u5339\u914d\u6570\u636e\u67e5\u8be2\u6761\u4ef6\uff1a%s", condition));
        int rows = 10000;
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setCondition(condition);
        queryFilterDTO.setRows(Integer.valueOf(rows));
        int count = rows;
        int pageIndex = 0;
        while (count == rows) {
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            ++pageIndex;
            DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), queryFilterDTO);
            if (dataQueryResult != null && dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                for (FeatureResult item : dataQueryResult.getData()) {
                    String dataId = item.getAttributes().get("F_DATAID").toString();
                    Object satelliteObj = item.getAttributes().get("f_satellite");
                    String satellite = satelliteObj == null ? "" : satelliteObj.toString();
                    Object dataNameObj = item.getAttributes().get("F_DATANAME");
                    String dataName = dataNameObj == null ? "" : dataNameObj.toString();
                    String dataNamePrefix = ImageDataMatchUtil.getDataNamePrefix((String)dataName, (String)satellite);
                    ImageMatchDataDTO matchData = (ImageMatchDataDTO)ListUtil.find(needMatchDataList, f -> f.getDataName().toLowerCase(Locale.ROOT).startsWith(dataNamePrefix));
                    if (matchData == null) continue;
                    dataIdList.add(matchData.getDataId());
                    dataIdList.add(dataId);
                    log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u5339\u914d[%s]", dataName, matchData.getDataName()));
                    needMatchDataList.remove(matchData);
                    JSONObject data = new JSONObject();
                    data.put("name", item.getAttributes().get("F_DATANAME"));
                    data.put("geometry", (Object)item.getGeometry());
                    data.put("dataId", (Object)dataId);
                    data.put("resolution", item.getAttributes().get("f_resolution"));
                    data.put("scenetime", item.getAttributes().get("f_product_time"));
                    dataIdDataMap.put(dataId, data);
                }
                continue;
            }
            count = 0;
        }
        for (ImageMatchDataDTO item : needMatchDataList) {
            log.warn(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u672a\u5339\u914d\u5230\uff0c\u4e0d\u53d1\u9001", item.getDataName()));
        }
        return dataIdList;
    }
}

