/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.imagedb.apply.constant.ImageRequirementStatusEnum;
import com.geoway.imagedb.apply.dao.ImgRequirementDao;
import com.geoway.imagedb.apply.dto.RequirementPageList;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementApprovalDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementCreateDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementDataDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementExportDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementFilterDTO;
import com.geoway.imagedb.apply.dto.requirement.ImageRequirementVO;
import com.geoway.imagedb.apply.entity.ImgRequirement;
import com.geoway.imagedb.apply.service.ImageRequirementService;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImageRequirementServiceImpl
implements ImageRequirementService {
    @Resource
    private ImgRequirementDao imgRequirementDao;
    @Resource
    private UserInfoService userInfoService;

    @Override
    public String createImageRequirement(ImageRequirementCreateDTO createDTO) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Assert.isTrue((boolean)user.getUserId().equals(createDTO.getApply_userId()), (String)"\u53c2\u6570\u4e2d\u63d0\u4ea4\u7684\u7528\u6237\u4fe1\u606f\u4e0e\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e0d\u7b26");
        if (createDTO.getApply_dataList() == null || createDTO.getApply_dataList().size() == 0) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u6570\u636e\u9700\u6c42");
        }
        Assert.notNull((Object)createDTO.getApply_phoneNumber(), (String)"\u8bf7\u586b\u5199\u8054\u7cfb\u7535\u8bdd");
        Assert.notNull((Object)createDTO.getApply_name(), (String)"\u8bf7\u586b\u5199\u9700\u6c42\u540d\u79f0");
        Assert.notNull((Object)createDTO.getApply_fillingType(), (String)"\u8bf7\u9009\u62e9\u586b\u62a5\u7c7b\u578b");
        Date createTime = new Date();
        ImgRequirement group = new ImgRequirement();
        boolean groupIsAdd = false;
        if (StringUtil.isEmptyOrWhiteSpace((String)createDTO.getApply_id())) {
            createDTO.setApply_id(UUID.randomUUID().toString().replace("-", ""));
            groupIsAdd = true;
            group.setFId(createDTO.getApply_id());
            group.setFCreatetime(createTime);
            group.setFApplytime(createTime);
            group.setFApplyTimephase("-");
            group.setFApplyDatatype("-");
            group.setFApplyDatarange("-");
            group.setFApplyResolution("-");
        } else {
            group = this.imgRequirementDao.selectByPrimaryKey(createDTO.getApply_id());
            Assert.notNull((Object)group, (String)("\u5f71\u50cf\u6570\u636e\u9700\u6c42\u4e0d\u5b58\u5728" + createDTO.getApply_id()));
        }
        group.setFType(0);
        group.setFGroupId("-1");
        group.setFApplyUserid(createDTO.getApply_userId());
        group.setFApplyUsername(createDTO.getApply_userName());
        group.setFApplyUserunit(createDTO.getApply_userUnit());
        group.setFApplyPhonenumber(createDTO.getApply_phoneNumber());
        group.setFApplyEmail(createDTO.getApply_email());
        group.setFApplyFillingtype(createDTO.getApply_fillingType());
        group.setFName(createDTO.getApply_name());
        group.setFStatus(String.valueOf(ImageRequirementStatusEnum.Ready.getValue()));
        group.setFIsdeleted(0);
        if (groupIsAdd) {
            this.imgRequirementDao.insert(group);
        } else {
            this.imgRequirementDao.updateGroupByGroupId(group);
            if (createDTO.getApply_dataList() != null && createDTO.getApply_dataList().size() > 0) {
                List subIds = ListUtil.convertAll(createDTO.getApply_dataList(), ImageRequirementDataDTO::getApply_subId);
                this.imgRequirementDao.deleteDataNotInGroup(group.getFId(), subIds);
            }
        }
        for (ImageRequirementDataDTO data : createDTO.getApply_dataList()) {
            ImgRequirement ir = this.imgRequirementDao.selectByPrimaryKey(data.getApply_subId());
            boolean isAdd = false;
            if (ir == null) {
                isAdd = true;
                ir = new ImgRequirement();
                ir.setFId(data.getApply_subId());
                ir.setFCreatetime(createTime);
                ir.setFApplytime(createTime);
            }
            ir.setFType(1);
            ir.setFApplyDatatype(data.getApply_dataType());
            ir.setFApplySatellitetype(data.getApply_satelliteType());
            ir.setFApplyProductdesc(data.getApply_productDesc());
            ir.setFApplyFrequency(data.getApply_frequency());
            ir.setFApplyDatarange(data.getApply_dataRange());
            ir.setFApplyResolution(data.getApply_resolution());
            ir.setFApplyProvidedtype(data.getApply_providedType());
            ir.setFApplyDesc(data.getApply_desc());
            ir.setFApplyBusiness(data.getApply_business());
            ir.setFApplyDirection(data.getApply_direction());
            ir.setFApplyPurpose(data.getApply_purpose());
            ir.setFApplyTimephase(data.getApply_frequency());
            ir.setFApplyUserid(createDTO.getApply_userId());
            ir.setFApplyUsername(createDTO.getApply_userName());
            ir.setFApplyUserunit(createDTO.getApply_userUnit());
            ir.setFApplyPhonenumber(createDTO.getApply_phoneNumber());
            ir.setFApplyEmail(createDTO.getApply_email());
            ir.setFGroupId(createDTO.getApply_id());
            ir.setFApplyFillingtype(createDTO.getApply_fillingType());
            ir.setFName(createDTO.getApply_name());
            ir.setFStatus(String.valueOf(ImageRequirementStatusEnum.Ready.getValue()));
            ir.setFIsdeleted(0);
            if (isAdd) {
                this.imgRequirementDao.insert(ir);
                continue;
            }
            this.imgRequirementDao.updateDataByPrimaryKey(ir);
        }
        return createDTO.getApply_id();
    }

    @Override
    public PageList<ImageRequirementVO> listImageRequirement(ImageRequirementFilterDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Integer pageIndex = dto.getPageIndex();
        Integer rows = dto.getRows();
        List<ImgRequirement> list = null;
        List<ImgRequirement> stalist = null;
        if (this.userInfoService.isAdminOrApprove(user).booleanValue()) {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgRequirementDao.selectAllGroup(dto);
            PageHelper.startPage((int)1, (int)100000);
            if (dto.getStatus() == null || dto.getStatus().trim().isEmpty()) {
                dto.setStatus("1");
            } else if (dto.getStatus().equals("0")) {
                dto.setStatus("-1");
            }
            stalist = this.imgRequirementDao.selectAllGroup(dto);
        } else {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgRequirementDao.selectGroupByUser(user.getUserId(), dto);
            PageHelper.startPage((int)1, (int)100000);
            if (dto.getStatus() == null || dto.getStatus().trim().isEmpty()) {
                dto.setStatus("1");
            } else if (dto.getStatus().equals("0")) {
                dto.setStatus("-1");
            }
            stalist = this.imgRequirementDao.selectGroupByUser(user.getUserId(), dto);
        }
        return this.convertPageListImageRequirementVO(list, stalist);
    }

    @Override
    public PageList<ImageRequirementVO> myListImageRequirement(ImageRequirementFilterDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        Integer pageIndex = dto.getPageIndex();
        Integer rows = dto.getRows();
        List<ImgRequirement> list = null;
        List<ImgRequirement> stalist = null;
        if (this.userInfoService.isAdmin(user).booleanValue()) {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgRequirementDao.selectAllGroup(dto);
            PageHelper.startPage((int)1, (int)100000);
            if (dto.getStatus() == null || dto.getStatus().trim().isEmpty()) {
                dto.setStatus("1");
            } else if (dto.getStatus().equals("0")) {
                dto.setStatus("-1");
            }
            stalist = this.imgRequirementDao.selectAllGroup(dto);
        } else {
            PageHelper.startPage((int)(pageIndex + 1), (int)rows);
            list = this.imgRequirementDao.selectGroupByUser(user.getUserId(), dto);
            PageHelper.startPage((int)1, (int)100000);
            if (dto.getStatus() == null || dto.getStatus().trim().isEmpty()) {
                dto.setStatus("1");
            } else if (dto.getStatus().equals("0")) {
                dto.setStatus("-1");
            }
            stalist = this.imgRequirementDao.selectGroupByUser(user.getUserId(), dto);
        }
        return this.convertPageListImageRequirementVO(list, stalist);
    }

    @Override
    public ImageRequirementVO getDetail(String applyId) {
        ImgRequirement imgRequirement = this.imgRequirementDao.selectByPrimaryKey(applyId);
        ImageRequirementVO vo = this.convertImageRequirementVO(imgRequirement);
        List<ImgRequirement> dataList = this.imgRequirementDao.selectDataByGroupId(applyId);
        if (StringUtil.isEmptyOrWhiteSpace((String)imgRequirement.getFName()) && dataList.size() == 0) {
            dataList = new ArrayList<ImgRequirement>();
            dataList.add(imgRequirement);
        }
        vo.setApply_dataList(ListUtil.convertAll(dataList, this::convertImageRequirementDataDTO));
        return vo;
    }

    private PageList<ImageRequirementVO> convertPageListImageRequirementVO(List<ImgRequirement> list, List<ImgRequirement> stalist) {
        PageInfo pageInfo = new PageInfo(list);
        PageInfo staPageInfo = new PageInfo(stalist);
        List imageRequirementVo = ListUtil.convertAll(list, this::convertImageRequirementVO);
        return new RequirementPageList(imageRequirementVo, pageInfo.getTotal(), staPageInfo.getTotal());
    }

    private ImageRequirementVO convertImageRequirementVO(ImgRequirement imgRequirement) {
        ImageRequirementVO vo = new ImageRequirementVO();
        vo.setApply_id(imgRequirement.getFId());
        vo.setApply_name(imgRequirement.getFName());
        if (StringUtil.isEmptyOrWhiteSpace((String)vo.getApply_name())) {
            vo.setApply_name(imgRequirement.getFApplyDatarange() + imgRequirement.getFApplyResolution() + imgRequirement.getFApplyDatatype());
        }
        vo.setApply_userId(imgRequirement.getFApplyUserid());
        vo.setApply_userName(imgRequirement.getFApplyUsername());
        vo.setApply_userUnit(imgRequirement.getFApplyUserunit());
        vo.setApply_phoneNumber(imgRequirement.getFApplyPhonenumber());
        vo.setApply_email(imgRequirement.getFApplyEmail());
        vo.setApply_fillingType(imgRequirement.getFApplyFillingtype());
        vo.setApprove_userName(imgRequirement.getFApproveUsername());
        vo.setApprove_reply(imgRequirement.getFApproveReply());
        vo.setApply_time(imgRequirement.getFApplytime());
        vo.setApprove_time(imgRequirement.getFApprovaltime());
        vo.setStatus(imgRequirement.getFStatus());
        vo.setApply_dataList(new ArrayList<ImageRequirementDataDTO>());
        return vo;
    }

    private ImageRequirementDataDTO convertImageRequirementDataDTO(ImgRequirement imgRequirement) {
        ImageRequirementDataDTO dto = new ImageRequirementDataDTO();
        dto.setApply_subId(imgRequirement.getFId());
        dto.setApply_dataType(imgRequirement.getFApplyDatatype());
        dto.setApply_satelliteType(imgRequirement.getFApplySatellitetype());
        dto.setApply_productDesc(imgRequirement.getFApplyProductdesc());
        dto.setApply_frequency(imgRequirement.getFApplyFrequency());
        dto.setApply_dataRange(imgRequirement.getFApplyDatarange());
        dto.setApply_resolution(imgRequirement.getFApplyResolution());
        dto.setApply_providedType(imgRequirement.getFApplyProvidedtype());
        dto.setApply_business(imgRequirement.getFApplyBusiness());
        dto.setApply_direction(imgRequirement.getFApplyDirection());
        dto.setApply_purpose(imgRequirement.getFApplyPurpose());
        dto.setApply_desc(imgRequirement.getFApplyDesc());
        return dto;
    }

    @Override
    public void repealImageRequirement(String apply_ids) {
        Assert.hasLength((String)apply_ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf\u9700\u6c42");
        String[] idArr = apply_ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        for (int i = 0; i < idArr.length; ++i) {
            ImgRequirement ir = this.imgRequirementDao.selectByPrimaryKey(idArr[i]);
            Assert.notNull((Object)ir, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u9700\u6c42"));
            Assert.isTrue((boolean)ir.getFApplyUserid().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u9700\u6c42\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            this.imgRequirementDao.deleteByPrimaryKey(idArr[i]);
        }
    }

    @Override
    public String approveImageRequirement(ImageRequirementApprovalDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgRequirement ir = this.imgRequirementDao.selectByPrimaryKey(dto.getApply_id());
        Assert.notNull((Object)ir, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + dto.getApply_id() + "\u7684\u5f71\u50cf\u9700\u6c42"));
        ir.setFApproveUserid(user.getUserId());
        ir.setFApproveUsername(user.getUserName());
        ir.setFApproveReply(dto.getApprove_reply());
        ImageRequirementStatusEnum statusEnum = ImageRequirementStatusEnum.getByValue(Integer.parseInt(dto.getStatus()));
        ir.setFApprovaltime(new Date());
        ir.setFStatus(String.valueOf(statusEnum.getValue()));
        this.imgRequirementDao.updateGroupByGroupId(ir);
        return ir.getFId();
    }

    @Override
    public List<ImageRequirementDataDTO> readRequirementDataFromExcel(MultipartFile file) {
        if (file == null) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u6570\u636e\u9700\u6c42\u6587\u4ef6\uff01");
        }
        ArrayList<ImageRequirementDataDTO> list = new ArrayList<ImageRequirementDataDTO>();
        String fileName = file.getOriginalFilename();
        if (StringUtil.isEmptyOrWhiteSpace((String)fileName)) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u6570\u636e\u9700\u6c42\u6587\u4ef6\u7684\u6587\u4ef6\u540d\uff01");
        }
        if ((fileName = fileName.toLowerCase(Locale.ROOT)).endsWith(".xls") || fileName.endsWith(".xlsx")) {
            try (InputStream fis = file.getInputStream();){
                List excelContents = ExcelUtil.readExcelDataList((InputStream)fis, null);
                for (int i = 1; i < excelContents.size(); ++i) {
                    ImageRequirementDataDTO dto = new ImageRequirementDataDTO();
                    dto.setApply_dataType((String)((List)excelContents.get(i)).get(0));
                    dto.setApply_satelliteType((String)((List)excelContents.get(i)).get(1));
                    dto.setApply_productDesc((String)((List)excelContents.get(i)).get(2));
                    dto.setApply_frequency((String)((List)excelContents.get(i)).get(3));
                    dto.setApply_dataRange((String)((List)excelContents.get(i)).get(4));
                    dto.setApply_resolution((String)((List)excelContents.get(i)).get(5));
                    dto.setApply_providedType((String)((List)excelContents.get(i)).get(6));
                    dto.setApply_desc((String)((List)excelContents.get(i)).get(7));
                    dto.setApply_business((String)((List)excelContents.get(i)).get(8));
                    dto.setApply_direction((String)((List)excelContents.get(i)).get(9));
                    dto.setApply_purpose((String)((List)excelContents.get(i)).get(10));
                    list.add(dto);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("\u6570\u636e\u9700\u6c42\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
        }
        return list;
    }

    @Override
    public void downloadTemplateExcel() {
        ArrayList dataList = new ArrayList();
        LinkedList<String> title = new LinkedList<String>();
        title.add("*\u6570\u636e\u7c7b\u578b");
        title.add("\u536b\u661f\u7c7b\u578b");
        title.add("\u6570\u636e\u4ea7\u54c1");
        title.add("*\u5206\u8fa8\u7387");
        title.add("*\u66f4\u65b0\u9891\u7387");
        title.add("*\u8986\u76d6\u533a\u57df");
        title.add("*\u63d0\u4f9b\u65b9\u5f0f");
        title.add("\u6570\u636e\u8d44\u6e90\u63cf\u8ff0");
        title.add("*\u5e94\u7528\u884c\u4e1a");
        title.add("*\u5e94\u7528\u65b9\u5411");
        title.add("*\u4e3b\u8981\u7528\u9014\u63cf\u8ff0");
        dataList.add(title);
        String fileName = String.format("Requirement_%s.xls", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        String path = Paths.get(UploadPathConfig.getUploadPath().toString(), fileName).toAbsolutePath().toString();
        ExcelUtil.writeExcel(dataList, (String)path);
        DownloadUtil.downloadFile((String)path);
    }

    @Override
    public void exportRequirementData(ImageRequirementExportDTO dto) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        List<Object> list = new ArrayList();
        ImageRequirementFilterDTO dtoFilter = new ImageRequirementFilterDTO();
        dtoFilter.setStatus(dto.getStatus());
        dtoFilter.setKey(dto.getKey());
        dtoFilter.setStartTime(dto.getStartTime());
        dtoFilter.setEndTime(dto.getEndTime());
        list = this.userInfoService.isAdminOrApprove(user) != false ? this.imgRequirementDao.selectAllGroup(dtoFilter) : this.imgRequirementDao.selectGroupByUser(user.getUserId(), dtoFilter);
        ArrayList dataList = new ArrayList();
        LinkedList<String> title = new LinkedList<String>();
        title.add("\u6570\u636e\u7c7b\u578b");
        title.add("\u536b\u661f\u7c7b\u578b");
        title.add("\u6570\u636e\u4ea7\u54c1");
        title.add("\u5206\u8fa8\u7387");
        title.add("\u66f4\u65b0\u9891\u7387");
        title.add("\u8986\u76d6\u533a\u57df");
        title.add("\u63d0\u4f9b\u65b9\u5f0f");
        title.add("\u6570\u636e\u8d44\u6e90\u63cf\u8ff0");
        title.add("\u5e94\u7528\u884c\u4e1a");
        title.add("\u5e94\u7528\u65b9\u5411");
        title.add("\u4e3b\u8981\u7528\u9014\u63cf\u8ff0");
        title.add("\u9700\u6c42\u7c7b\u578b");
        title.add("\u8054\u7cfb\u4eba");
        title.add("\u8054\u7cfb\u7535\u8bdd");
        title.add("\u5355\u4f4d");
        title.add("\u90ae\u7bb1");
        dataList.add(title);
        for (ImgRequirement imgRequirement : list) {
            LinkedList<String> data = new LinkedList<String>();
            data.add(imgRequirement.getFApplyDatatype());
            data.add(imgRequirement.getFApplySatellitetype());
            data.add(imgRequirement.getFApplyProductdesc());
            data.add(imgRequirement.getFApplyResolution());
            data.add(imgRequirement.getFApplyFrequency());
            data.add(imgRequirement.getFApplyDatarange());
            data.add(imgRequirement.getFApplyProvidedtype());
            data.add(imgRequirement.getFApplyDesc());
            data.add(imgRequirement.getFApplyBusiness());
            data.add(imgRequirement.getFApplyDirection());
            data.add(imgRequirement.getFApplyPurpose());
            data.add(imgRequirement.getFApplyFillingtype());
            data.add(imgRequirement.getFApplyUsername());
            data.add(imgRequirement.getFApplyPhonenumber());
            data.add(imgRequirement.getFApplyUserunit());
            data.add(imgRequirement.getFApplyEmail());
            dataList.add(data);
        }
        String fileName = String.format("Requirement_%s.xls", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        String string = Paths.get(UploadPathConfig.getUploadPath().toString(), fileName).toAbsolutePath().toString();
        ExcelUtil.writeExcel(dataList, (String)string);
        DownloadUtil.downloadFile((String)string);
    }
}

