/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.properties.DefaultCoordSchemeProperties;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.imagedb.apply.dao.ImgCoverageAnalyseDao;
import com.geoway.imagedb.apply.dto.coverage.StatResultItemDTO;
import com.geoway.imagedb.apply.dto.statistic.DistributeStatisticFilterDTO;
import com.geoway.imagedb.apply.dto.statistic.ImageStatisticResultDTO;
import com.geoway.imagedb.apply.dto.statistic.RepertoryStatisticFilterDTO;
import com.geoway.imagedb.apply.entity.ImgCoverageAnalyse;
import com.geoway.imagedb.apply.service.ImageStatisticService;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.query.CoverageAnalyseResultDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.TimeFilterDTO;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ImageStatisticServiceImpl
implements ImageStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ImageStatisticServiceImpl.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private ImgCoverageAnalyseDao imgCoverageAnalyseDao;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private DefaultCoordSchemeProperties defaultCoordSchemeProperties;

    @Override
    public ImageStatisticResultDTO repertoryStatistic(RepertoryStatisticFilterDTO filterDTO) {
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue((Integer)filterDTO.getImageType());
        ImageStatisticResultDTO resultDTO = new ImageStatisticResultDTO();
        ArrayList<ReturnField> displayFields = new ArrayList<ReturnField>();
        if (filterDTO.getStatisticType() == 3 || filterDTO.getStatisticType() == 4) {
            displayFields.add(new ReturnField("name", "\u65f6\u95f4"));
        }
        switch (imageType) {
            case OriginalImageDataset: 
            case ProcessedImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u6570\u636e\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u6570\u636e\u91cf\uff08\u666f\uff09"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                displayFields.add(new ReturnField("coverArea", "\u8986\u76d6\u9762\u79ef\uff08KM2\uff09"));
                resultDTO.setStatResults(this.statisticImageBusiness(filterDTO, imageType));
                break;
            }
            case ImageSampleImageDataset: 
            case TileSampleImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u5206\u7c7b\u65b9\u6848"));
                }
                displayFields.add(new ReturnField("count", "\u6837\u672c\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(this.statisticSampleTable(filterDTO, imageType));
                break;
            }
            default: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u4ea7\u54c1\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u4ea7\u54c1\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(new ArrayList<Map<String, Object>>());
            }
        }
        resultDTO.setFields(displayFields);
        return resultDTO;
    }

    @Override
    public ImageStatisticResultDTO distributeStatistic(DistributeStatisticFilterDTO filterDTO) {
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue((Integer)filterDTO.getImageType());
        ImageStatisticResultDTO resultDTO = new ImageStatisticResultDTO();
        ArrayList<ReturnField> displayFields = new ArrayList<ReturnField>();
        if (filterDTO.getStatisticType() == 3 || filterDTO.getStatisticType() == 4) {
            displayFields.add(new ReturnField("name", "\u65f6\u95f4"));
        } else if (filterDTO.getStatisticType() == 1) {
            displayFields.add(new ReturnField("name", "\u5206\u53d1\u5355\u4f4d"));
        }
        switch (imageType) {
            case OriginalImageDataset: 
            case ProcessedImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u6570\u636e\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u6570\u636e\u91cf\uff08\u666f\uff09"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                displayFields.add(new ReturnField("coverArea", "\u8986\u76d6\u9762\u79ef\uff08KM2\uff09"));
                resultDTO.setStatResults(this.distributeStatistic(filterDTO, imageType));
                break;
            }
            case ImageSampleImageDataset: 
            case TileSampleImageDataset: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u5206\u7c7b\u65b9\u6848"));
                }
                displayFields.add(new ReturnField("count", "\u6837\u672c\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(new ArrayList<Map<String, Object>>());
                break;
            }
            default: {
                if (filterDTO.getStatisticType() == 2) {
                    displayFields.add(new ReturnField("name", "\u4ea7\u54c1\u7c7b\u578b"));
                }
                displayFields.add(new ReturnField("count", "\u4ea7\u54c1\u6570\u91cf"));
                displayFields.add(new ReturnField("dataSize", "\u6570\u636e\u5927\u5c0f\uff08GB\uff09"));
                resultDTO.setStatResults(new ArrayList<Map<String, Object>>());
            }
        }
        resultDTO.setFields(displayFields);
        return resultDTO;
    }

    @Override
    public void exportStatisticResult(ImageStatisticResultDTO resultDTO) {
        String fileName = ImageDateUtil.format((Date)new Date(), (String)"yyyyMMddHH:mm") + ".xls";
        ArrayList datas = new ArrayList();
        LinkedList<String> title = new LinkedList<String>();
        for (ReturnField returnField : resultDTO.getFields()) {
            title.add(returnField.getAlias());
        }
        datas.add(title);
        for (Map map : resultDTO.getStatResults()) {
            LinkedList data = new LinkedList();
            for (ReturnField returnField : resultDTO.getFields()) {
                Object value = map.get(returnField.getName());
                data.add(value);
            }
            datas.add(data);
        }
        DownloadUtil.downloadExcelFile((String)fileName, datas);
    }

    @Override
    public List<Integer> getCoverageAnalyseYears() {
        return this.imgCoverageAnalyseDao.selectYears();
    }

    @Override
    public CoverageAnalyseResultDTO getCoverageAnalyseResult(Integer year, Integer timeType) {
        List<ImgCoverageAnalyse> analyseResultList = this.imgCoverageAnalyseDao.selectByTimeGroup(year, timeType);
        if (analyseResultList == null || analyseResultList.size() == 0) {
            CoverageAnalyseResultDTO rootResult = new CoverageAnalyseResultDTO();
            rootResult.setId(UUID.randomUUID().toString().replace("-", ""));
            rootResult.setObjectIdArray(new ArrayList());
            rootResult.setPid(null);
            rootResult.setSatellite("\u603b\u4f53\u8986\u76d6");
            rootResult.setSensor("");
            rootResult.setCoveragePercent(Double.valueOf(0.0));
            rootResult.setCount(Integer.valueOf(0));
            rootResult.setDataSize("0B");
            return rootResult;
        }
        Map<String, List<ImgCoverageAnalyse>> groupMap = analyseResultList.stream().collect(Collectors.groupingBy(ImgCoverageAnalyse::getGroupId));
        List<CoverageAnalyseResultDTO> resultList = this.convertCoverageAnalyseResult(groupMap, "-1");
        CoverageAnalyseResultDTO rootResult = resultList.get(0);
        DatasetDTO datasetDTO = this.geoDatabaseService.getDatasetDetail(this.imageDatasetService.getBusinessSnapshotDataSource(), DatasetTypeEnum.FeatureClass, "tbimg_coverageanalyse");
        rootResult.setRangeRender(datasetDTO.getRender());
        return rootResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StatResultItemDTO> statOriginalImageDataByImportTime(Date time) {
        DmDictValueDTO originalDictValue = this.dictionaryService.getDictionaryTree("DIC_SensorClassification");
        if (originalDictValue == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u4f20\u611f\u5668\u5206\u7c7b\u5b57\u5178DIC_SensorClassification");
        }
        if (originalDictValue.getChildren() == null || originalDictValue.getChildren().size() == 0) {
            throw new RuntimeException("\u672a\u627e\u5230\u4f20\u611f\u5668\u5206\u7c7b\u5b57\u5178DIC_SensorClassification\u7684\u5b50\u9879");
        }
        ArrayList<StatResultItemDTO> result = new ArrayList<StatResultItemDTO>();
        for (DmDictValueDTO child : originalDictValue.getChildren()) {
            StatResultItemDTO item = new StatResultItemDTO();
            item.setName(child.getCode());
            item.setCount(0);
            item.setDataSize("0");
            result.add(item);
        }
        Map originalGroup = this.imageQueryService.getSatelliteGroup(originalDictValue, null, new ArrayList());
        DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);
        if (workspace == null) {
            throw new RuntimeException("\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        }
        ArrayList<TimeFilterDTO> timeArray = new ArrayList<TimeFilterDTO>();
        TimeFilterDTO timeFilter = new TimeFilterDTO();
        timeFilter.setStartTime(time);
        timeFilter.setEndTime(time);
        timeArray.add(timeFilter);
        List filterArray = ImageDateUtil.convertTimeFilters(timeArray, (String)"f_import_time");
        QueryFilter queryFilter = new QueryFilter();
        queryFilter.setWhereClause((String)filterArray.get(0) + " and f_image_type = 11");
        IFeatureCursor cursor = null;
        try {
            IFeatureClass businessSnapshotFc = workspace.openFeatureClass("GWMD_tbimg_businesssnapshot_CAT");
            cursor = businessSnapshotFc.searchFeature((IQueryFilter)queryFilter);
            IFeature feature = null;
            while ((feature = cursor.nextFeature()) != null) {
                List groupNames;
                String groupName;
                StatResultItemDTO group;
                String satellite = feature.getValue("f_satellite").toString();
                Long dataSize = Long.parseLong(feature.getValue("F_DATASIZE").toString());
                if (!originalGroup.containsKey(satellite) || (group = (StatResultItemDTO)ListUtil.find(result, arg_0 -> ImageStatisticServiceImpl.lambda$statOriginalImageDataByImportTime$0(groupName = (String)(groupNames = (List)originalGroup.get(satellite)).get(0), arg_0))) == null) continue;
                group.setCount(group.getCount() + 1);
                dataSize = Long.parseLong(group.getDataSize()) + dataSize;
                group.setDataSize(dataSize + "");
            }
            for (StatResultItemDTO item : result) {
                BigDecimal bigDecimal = new BigDecimal(item.getDataSize() + "");
                String[] unit = new String[]{"B", "KB", "MB", "GB", "TB"};
                int index = 0;
                while (bigDecimal.compareTo(new BigDecimal(1024)) > 0) {
                    ++index;
                    bigDecimal = bigDecimal.divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP);
                }
                item.setDataSize(bigDecimal + " " + unit[index]);
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return result;
    }

    @Override
    public ImageQueryResult queryOriginalImageByImportTime(Date time, Integer pageIndex, Integer rows) {
        ArrayList<TimeFilterDTO> timeArray = new ArrayList<TimeFilterDTO>();
        TimeFilterDTO timeFilter = new TimeFilterDTO();
        timeFilter.setStartTime(time);
        timeFilter.setEndTime(time);
        timeArray.add(timeFilter);
        List filterArray = ImageDateUtil.convertTimeFilters(timeArray, (String)"f_import_time");
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setCondition((String)filterArray.get(0) + " and f_image_type = 11");
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
        queryFilterDTO.setPageIndex(pageIndex);
        queryFilterDTO.setRows(rows);
        return this.imageQueryService.query(queryFilterDTO, Integer.valueOf(0), ImageDatasetTypeEnum.OriginalImageDataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> statisticImageBusiness(RepertoryStatisticFilterDTO filterDTO, ImageDatasetTypeEnum imageType) {
        ArrayList<Map<String, Object>> statResults = new ArrayList<Map<String, Object>>();
        SpatialQueryFilter queryFilter = new SpatialQueryFilter();
        String timeFilterFld = 1 == filterDTO.getTimeFilterType() ? "f_product_time" : "f_import_time";
        ArrayList<String> queryFieldList = new ArrayList<String>();
        String groupFld = "f_satellite";
        String queryGroupFld = "f_satellite";
        switch (filterDTO.getStatisticType()) {
            case 2: {
                queryGroupFld = "f_satellite";
                groupFld = "f_satellite";
                break;
            }
            case 3: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY-MM') AS month", timeFilterFld);
                groupFld = "month";
                break;
            }
            case 4: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY') AS year_quarter", timeFilterFld);
                groupFld = "year_quarter";
                break;
            }
        }
        queryFieldList.add(queryGroupFld);
        queryFieldList.add(String.format("Count(distinct %s) as count", "f_dataid"));
        queryFieldList.add(String.format("Sum(%s) as sum", "f_datasize"));
        int srid = this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid();
        ISpatialReferenceSystem sp = SpatialReferenceSystemFunc.createSpatialReference((int)srid);
        if (sp != null && sp.getType() == SpatialReferenceSystemType.Geographic) {
            queryFieldList.add("ST_Area(ST_Union(shape)::geography) AS area_sq");
        } else {
            queryFieldList.add("ST_Area(ST_Union(shape)) AS area_sq");
        }
        String queryFields = String.join((CharSequence)",", queryFieldList);
        queryFilter.setSubFields(queryFields);
        String postfix = String.format(" group by %s order by %s", groupFld, groupFld);
        queryFilter.setPostfixClause(postfix);
        queryFilter.setWhereClause(String.format("%s = %d", "f_image_type", imageType.getValue()));
        if (filterDTO.getTimeFilter() != null) {
            ArrayList<TimeFilterDTO> timeFilterList = new ArrayList<TimeFilterDTO>();
            timeFilterList.add(filterDTO.getTimeFilter());
            List timeFilterStrList = ImageDateUtil.convertTimeFilters(timeFilterList, (String)timeFilterFld);
            String timeFilter = String.join((CharSequence)" or ", timeFilterStrList);
            queryFilter.setWhereClause(queryFilter.getWhereClause() + " and " + timeFilter);
        }
        DataSourceDTO dataSource = this.imageDatasetService.getBusinessSnapshotDataSource();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        ICursor cursor = null;
        try {
            IFeatureClass catFc = workspace.openFeatureClass("GWMD_tbimg_businesssnapshot_CAT");
            ITable table = (ITable)catFc;
            cursor = table.searchRow((IQueryFilter)queryFilter);
            IRow row = cursor.nextRow();
            while (row != null) {
                HashMap<String, Object> statResult = new HashMap<String, Object>(0);
                statResult.put("name", row.getValue(groupFld));
                statResult.put("count", row.getValue("count"));
                statResult.put("dataSize", this.convertByte2GB(row.getValue("sum")));
                statResult.put("coverArea", this.convertKM2(row.getValue("area_sq")));
                statResults.add(statResult);
                row = cursor.nextRow();
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return statResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> statisticSampleTable(RepertoryStatisticFilterDTO filterDTO, ImageDatasetTypeEnum imageType) {
        ArrayList<Map<String, Object>> statResults = new ArrayList<Map<String, Object>>();
        SpatialQueryFilter queryFilter = new SpatialQueryFilter();
        ArrayList<String> queryFieldList = new ArrayList<String>();
        String timeFilterFld = "f_import_time";
        String groupFld = "samplescheme";
        String queryGroupFld = "samplescheme";
        switch (filterDTO.getStatisticType()) {
            case 2: {
                queryGroupFld = "samplescheme";
                groupFld = "samplescheme";
                break;
            }
            case 3: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY-MM') AS month", timeFilterFld);
                groupFld = "month";
                break;
            }
            case 4: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY') AS year_quarter", timeFilterFld);
                groupFld = "year_quarter";
                break;
            }
        }
        queryFieldList.add(queryGroupFld);
        queryFieldList.add(String.format("Count(distinct %s) as count", "f_dataid"));
        queryFieldList.add(String.format("Sum(%s) as sum", "f_datasize"));
        String queryFields = String.join((CharSequence)",", queryFieldList);
        queryFilter.setSubFields(queryFields);
        String postfix = String.format(" group by %s order by %s", groupFld, groupFld);
        queryFilter.setPostfixClause(postfix);
        queryFilter.setWhereClause(String.format("%s = %d", "f_image_type", imageType.getValue()));
        if (filterDTO.getTimeFilter() != null) {
            ArrayList<TimeFilterDTO> timeFilterList = new ArrayList<TimeFilterDTO>();
            timeFilterList.add(filterDTO.getTimeFilter());
            List timeFilterStrList = ImageDateUtil.convertTimeFilters(timeFilterList, (String)timeFilterFld);
            String timeFilter = String.join((CharSequence)" or ", timeFilterStrList);
            queryFilter.setWhereClause(queryFilter.getWhereClause() + " and " + timeFilter);
        }
        DataSourceDTO dataSource = this.imageDatasetService.getBusinessSnapshotDataSource();
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        ICursor cursor = null;
        try {
            IFeatureClass catFc = workspace.openFeatureClass("tb_sample_data");
            ITable table = (ITable)catFc;
            cursor = table.searchRow((IQueryFilter)queryFilter);
            IRow row = cursor.nextRow();
            while (row != null) {
                HashMap<String, Object> statResult = new HashMap<String, Object>(0);
                statResult.put("name", row.getValue(groupFld));
                statResult.put("count", row.getValue("count"));
                statResult.put("dataSize", this.convertByte2GB(row.getValue("sum")));
                statResults.add(statResult);
                row = cursor.nextRow();
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return statResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> distributeStatistic(DistributeStatisticFilterDTO filterDTO, ImageDatasetTypeEnum imageType) {
        ArrayList<Map<String, Object>> statResults = new ArrayList<Map<String, Object>>();
        String timeFilterFld = "f_approvaltime";
        ArrayList<String> queryFieldList = new ArrayList<String>();
        String groupFld = "f_apply_userunit";
        String queryGroupFld = "f_apply_userunit";
        switch (filterDTO.getStatisticType()) {
            case 1: {
                queryGroupFld = "f_apply_userunit";
                groupFld = "f_apply_userunit";
                break;
            }
            case 2: {
                queryGroupFld = "tbimg_order_img.f_satellite as f_satellite_img";
                groupFld = "f_satellite_img";
                break;
            }
            case 3: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY-MM') AS month", timeFilterFld);
                groupFld = "month";
                break;
            }
            case 4: {
                queryGroupFld = String.format("TO_CHAR(%s, 'YYYY') AS year_quarter", timeFilterFld);
                groupFld = "year_quarter";
                break;
            }
        }
        queryFieldList.add(queryGroupFld);
        queryFieldList.add(String.format("Count(%s) as count", "tbimg_order_img.f_dataid"));
        queryFieldList.add(String.format("Sum(%s) as sum", "tbimg_order_img.f_data_size"));
        int srid = this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid();
        ISpatialReferenceSystem sp = SpatialReferenceSystemFunc.createSpatialReference((int)srid);
        if (sp != null && sp.getType() == SpatialReferenceSystemType.Geographic) {
            queryFieldList.add("ST_Area(ST_Union(gwmd_tbimg_businesssnapshot_cat.shape)::geography) AS area_sq");
        } else {
            queryFieldList.add("ST_Area(ST_Union(gwmd_tbimg_businesssnapshot_cat.shape)) AS area_sq");
        }
        String queryFields = String.join((CharSequence)",", queryFieldList);
        String condition = "";
        if (filterDTO.getTimeFilter() != null) {
            ArrayList<TimeFilterDTO> timeFilterList = new ArrayList<TimeFilterDTO>();
            timeFilterList.add(filterDTO.getTimeFilter());
            List timeFilterStrList = ImageDateUtil.convertTimeFilters(timeFilterList, (String)timeFilterFld);
            String timeFilter = String.join((CharSequence)" or ", timeFilterStrList);
            condition = " and " + timeFilter;
        }
        DataSourceDTO dataSource = this.imageDatasetService.getBusinessSnapshotDataSource();
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);){
            String sql = String.format("select %s from tbimg_order_img left join tbimg_order on tbimg_order_img.f_orderid = tbimg_order.f_id left join gwmd_tbimg_businesssnapshot_cat on tbimg_order_img.f_dataid = gwmd_tbimg_businesssnapshot_cat.f_dataid where tbimg_order.f_status='2' and tbimg_order_img.f_image_type = %d %s group by %s order by %s", queryFields, imageType.getValue(), condition, groupFld, groupFld);
            List queryResults = workspace.queryList(sql, new Object[0]);
            for (Map item : queryResults) {
                HashMap statResult = new HashMap(0);
                statResult.put("name", item.get(groupFld));
                statResult.put("count", item.get("count"));
                statResult.put("dataSize", this.convertKb2GB(item.get("sum")));
                statResult.put("coverArea", this.convertKM2(item.get("area_sq")));
                statResults.add(statResult);
            }
        }
        return statResults;
    }

    private String convertByte2GB(Object dataSizeObj) {
        if (dataSizeObj == null) {
            return "0";
        }
        BigDecimal mb = NumberUtil.div((Number)new BigDecimal(dataSizeObj.toString()), (Number)BigDecimal.valueOf(0x100000L));
        BigDecimal gb = NumberUtil.div((Number)mb, (Number)BigDecimal.valueOf(1024L), (int)2);
        return gb + "";
    }

    private String convertKb2GB(Object dataSizeObj) {
        if (dataSizeObj == null) {
            return "0";
        }
        BigDecimal gb = NumberUtil.div((Number)new BigDecimal(dataSizeObj.toString()), (Number)BigDecimal.valueOf(0x100000L), (int)2);
        return gb + "";
    }

    private String convertKM2(Object areaObj) {
        if (areaObj == null) {
            return "0";
        }
        return NumberUtil.div((Number)new BigDecimal(areaObj.toString()), (Number)BigDecimal.valueOf(1000000L), (int)2) + "";
    }

    private List<CoverageAnalyseResultDTO> convertCoverageAnalyseResult(Map<String, List<ImgCoverageAnalyse>> groupMap, String pid) {
        List<ImgCoverageAnalyse> list = groupMap.get(pid);
        ArrayList<CoverageAnalyseResultDTO> resultList = new ArrayList<CoverageAnalyseResultDTO>();
        for (ImgCoverageAnalyse item : list) {
            CoverageAnalyseResultDTO resultItem = new CoverageAnalyseResultDTO();
            resultItem.setId(item.getObjectId());
            resultItem.setPid(item.getGroupId());
            resultItem.setObjectIdArray(new ArrayList());
            resultItem.setSatellite(item.getName());
            resultItem.setSensor("");
            resultItem.setCoveragePercent(item.getCoveragePercent());
            resultItem.setCount(item.getDataCount());
            resultItem.setDataSize(item.getDisplayDataSize());
            resultItem.setChildren(new ArrayList());
            if (groupMap.containsKey(item.getObjectId())) {
                resultItem.setChildren(this.convertCoverageAnalyseResult(groupMap, item.getObjectId()));
            }
            resultList.add(resultItem);
        }
        return resultList;
    }

    private static /* synthetic */ boolean lambda$statOriginalImageDataByImportTime$0(String groupName, StatResultItemDTO item) {
        return item.getName().equals(groupName);
    }
}

