/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IMEServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(IMEServiceHelper.class);
    @Resource
    private DataSourceService dataSourceService;

    public Map<String, Set<String>> getGeoDatabaseLayers(String serviceUrl) {
        HashMap<String, Set<String>> dbKeyLayerMap = new HashMap<String, Set<String>>(0);
        try {
            if (serviceUrl.endsWith("/")) {
                serviceUrl = serviceUrl.substring(0, serviceUrl.length() - 1);
            }
            String[] array = serviceUrl.split("/");
            String serviceName = array[array.length - 2];
            StringBuilder url = new StringBuilder();
            for (int i = 0; i < array.length - 2; ++i) {
                url.append(array[i]).append("/");
            }
            url = new StringBuilder(String.format("%sadmin/detail?name=%s", url, serviceName));
            String resultString = HttpClientUtil.doGet((String)url.toString());
            JSONObject resultJson = JSONObject.parseObject((String)resultString);
            JSONArray configArray = resultJson.getJSONObject("result").getJSONArray("configs");
            List geoDatabaseList = null;
            for (int i = 0; i < configArray.size(); ++i) {
                String tableName;
                String dbUrl = configArray.getJSONObject(i).getJSONObject("source").getString("connParams");
                String userName = configArray.getJSONObject(i).getJSONObject("source").getString("user");
                String geoDbKey = StringUtil.MD5((String)(userName + "@" + dbUrl));
                if (geoDatabaseList == null) {
                    geoDatabaseList = this.dataSourceService.listDataSource(Arrays.asList(DataStoreTypeEnum.GeoDatabase), null, null);
                }
                for (DataSourceDTO geoDatabase : geoDatabaseList) {
                    if (!geoDatabase.getUrl().equals(dbUrl) || !geoDatabase.getUserName().equals(userName)) continue;
                    geoDbKey = geoDatabase.getKey();
                    break;
                }
                if ((tableName = configArray.getJSONObject(i).getString("dataset")).contains(".")) {
                    tableName = tableName.substring(tableName.indexOf(".") + 1);
                }
                if (dbKeyLayerMap.containsKey(geoDbKey)) {
                    ((Set)dbKeyLayerMap.get(geoDbKey)).add(tableName);
                    continue;
                }
                HashSet<String> layerNames = new HashSet<String>();
                layerNames.add(tableName);
                dbKeyLayerMap.put(geoDbKey, layerNames);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u52a8\u6001\u5f71\u50cf\u670d\u52a1\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
        }
        return dbKeyLayerMap;
    }
}

