/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.apply.service.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.IdUtil;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.imagedb.apply.dao.ImgApplyGroupDao;
import com.geoway.imagedb.apply.dto.apply.ImageApplyCreateDTO;
import com.geoway.imagedb.apply.dto.apply.ImageApplyVO;
import com.geoway.imagedb.apply.entity.ImgApplyGroup;
import com.geoway.imagedb.apply.service.ImageApplyService;
import com.geoway.imagedb.apply.user.LoginUserInfoWithDep;
import com.geoway.imagedb.apply.user.UserInfoService;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.dto.ImgPageList;
import com.geoway.imagedb.dataset.dto.match.ImageMatchDataDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageResult;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.util.ImageDataMatchUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ImageApplyServiceImpl
implements ImageApplyService {
    private static final Logger log = LoggerFactory.getLogger(ImageApplyServiceImpl.class);
    @Resource
    private ImgApplyGroupDao imgApplyGroupDao;
    @Resource
    private ImageQueryService imageQueryService;
    @Resource
    private UserInfoService userInfoService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private ImageDatasetService imageDatasetService;

    @Override
    public String createImageApply(ImageApplyCreateDTO createDTO) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgApplyGroup iag = new ImgApplyGroup();
        iag.setFId(IdUtil.getSnowflakeNextIdStr());
        iag.setFName(createDTO.getName());
        iag.setFDesc(createDTO.getDesc());
        String dataIds = createDTO.getData();
        if (Boolean.TRUE.equals(createDTO.getNeedMatch())) {
            List dataIdList = com.geoway.adf.dms.common.util.ListUtil.convertAll((Object[])createDTO.getData().split(","), String::trim);
            List<ImageMatchDataDTO> needMatchDataList = this.getNeedMatchDataList(dataIdList);
            if (needMatchDataList.size() > 0) {
                dataIdList.addAll(this.getMatchDataIdList(needMatchDataList));
            }
            dataIds = String.join((CharSequence)",", dataIdList);
        }
        if (!org.apache.commons.lang3.StringUtils.startsWith((CharSequence)dataIds, (CharSequence)",")) {
            createDTO.setData("," + dataIds);
        }
        if (!org.apache.commons.lang3.StringUtils.endsWith((CharSequence)dataIds, (CharSequence)",")) {
            createDTO.setData(dataIds + ",");
        }
        iag.setFData(dataIds);
        iag.setFCreatetime(new Date());
        iag.setFCreateuser(user.getUserId());
        this.imgApplyGroupDao.insert(iag);
        return iag.getFId();
    }

    @Override
    public PageList<ImageApplyVO> getImageApplyList(Integer pageIndex, Integer rows) {
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        List<ImgApplyGroup> list = this.imgApplyGroupDao.selectByUser(user.getUserId());
        PageInfo pageInfo = new PageInfo(list);
        List imangeApplyVo = com.geoway.adf.dms.common.util.ListUtil.convertAll(list, t -> {
            ImageApplyVO vo = new ImageApplyVO();
            vo.setId(t.getFId());
            vo.setName(t.getFName());
            vo.setDesc(t.getFDesc());
            vo.setApply_time(t.getFCreatetime());
            return vo;
        });
        return new PageList(imangeApplyVo, Long.valueOf(pageInfo.getTotal()));
    }

    @Override
    public void delImageApply(String ids) {
        Assert.hasLength((String)ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf\u7533\u8bf7");
        String[] idArr = ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        for (int i = 0; i < idArr.length; ++i) {
            ImgApplyGroup ig = this.imgApplyGroupDao.selectByPrimaryKey(idArr[i]);
            Assert.notNull((Object)ig, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7"));
            Assert.isTrue((boolean)ig.getFCreateuser().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + idArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            this.imgApplyGroupDao.deleteByPrimaryKey(idArr[i]);
        }
    }

    @Override
    public ImgPageList<ImageResult> getImageList(String applyId, Integer pageIndex, Integer rows, Integer size) {
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        String[] applyIdArr = applyId.trim().split(",");
        StringBuilder sb = new StringBuilder();
        ImgApplyGroup ig = null;
        String img = "";
        for (int i = 0; i < applyIdArr.length; ++i) {
            if (applyIdArr[i].trim().isEmpty()) continue;
            ig = this.imgApplyGroupDao.selectByPrimaryKey(applyIdArr[i]);
            Assert.notNull((Object)ig, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + applyIdArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7"));
            Assert.isTrue((boolean)ig.getFCreateuser().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + applyIdArr[i] + "\u7684\u5f71\u50cf\u7533\u8bf7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
            img = StringUtils.trimLeadingCharacter((String)ig.getFData(), (char)',');
            img = StringUtils.trimTrailingCharacter((String)img, (char)',');
            sb.append(img).append(",");
        }
        return this.innerGetImageList(sb.toString(), pageIndex, rows, size, true);
    }

    private List<String> deleteDuplicate(String[] imgArr) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String str : imgArr) {
            if (str.trim().isEmpty()) continue;
            set.add(str);
        }
        return new ArrayList<String>(set);
    }

    private ImgPageList<ImageResult> innerGetImageList(String ids, Integer pageIndex, Integer rows, Integer size, boolean dd) {
        String[] imgArr = ids.split(",");
        List<String> imgList = this.deleteDuplicate(imgArr);
        ImageQueryResult result = this.imageQueryService.queryByDataIds(imgList, size);
        Double sum = result.getData().size() == 0 ? Double.valueOf(0.0) : result.getData().stream().map(n -> Double.valueOf(n.getAttributes().get("F_DATASIZE").toString())).reduce(Double::sum).get();
        for (ImageResult imageResult : result.getData()) {
            BigDecimal bigDecimal = new BigDecimal(imageResult.getAttributes().get("F_DATASIZE") + "");
            String[] unit = new String[]{"KB", "MB", "GB", "TB"};
            int index = 0;
            while (bigDecimal.compareTo(new BigDecimal(1024)) > 0) {
                ++index;
                bigDecimal = bigDecimal.divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP);
            }
            imageResult.getAttributes().put("F_DATASIZE", bigDecimal + " " + unit[index]);
        }
        return new ImgPageList(ListUtil.page((int)pageIndex, (int)rows, (List)result.getData()), result.getTotal(), Integer.valueOf(sum.intValue()));
    }

    private PageList<ImageResult> innerGetImageList2(String ids, Integer pageIndex, Integer rows, Integer size, boolean dd) {
        String img = StringUtils.trimLeadingCharacter((String)ids, (char)',');
        img = StringUtils.trimTrailingCharacter((String)img, (char)',');
        Object imgArr = img.split(",");
        if (dd) {
            // empty if block
        }
        Long imgNumber = ((String[])imgArr).length;
        if (img.isEmpty()) {
            imgNumber = 0L;
        }
        if ((imgArr = ((String[])imgArr).length > pageIndex * rows && !img.isEmpty() ? Arrays.copyOfRange(imgArr, pageIndex * rows, (pageIndex + 1) * rows > ((String[])imgArr).length ? ((String[])imgArr).length : (pageIndex + 1) * rows) : null) != null && ((String[])imgArr).length > 0) {
            List imgList = Arrays.stream(imgArr).collect(Collectors.toList());
            return new PageList(this.imageQueryService.queryByDataIds(imgList, size).getData(), imgNumber);
        }
        return new PageList(new ArrayList(), imgNumber);
    }

    @Override
    public void delImage(String applyId, String ids) {
        Assert.hasLength((String)ids, (String)"\u8bf7\u9009\u62e9\u5f71\u50cf");
        String[] idArr = ids.split(",");
        LoginUserInfoWithDep user = this.userInfoService.getUserInfo();
        ImgApplyGroup ig = this.imgApplyGroupDao.selectByPrimaryKey(applyId);
        Assert.notNull((Object)ig, (String)("\u672a\u67e5\u8be2\u5230\u6807\u8bc6\u4e3a" + applyId + "\u7684\u5f71\u50cf\u7533\u8bf7"));
        Assert.isTrue((boolean)ig.getFCreateuser().equals(user.getUserId()), (String)("\u6807\u8bc6\u4e3a" + applyId + "\u7684\u5f71\u50cf\u7533\u8bf7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237"));
        String imgIds = ig.getFData();
        for (int i = 0; i < idArr.length; ++i) {
            imgIds = imgIds.replace("," + idArr[i] + ",", ",");
        }
        ig.setFData(imgIds);
        this.imgApplyGroupDao.updateByPrimaryKey(ig);
    }

    private List<ImageMatchDataDTO> getNeedMatchDataList(List<String> dataIdList) {
        List filters = com.geoway.adf.dms.common.util.ListUtil.convertAll(dataIdList, f -> String.format("%s = '%s'", "F_DATAID", f));
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(false));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
        ArrayList<String> satelliteFilters = new ArrayList<String>();
        for (String satellite : ImageDataMatchUtil.ZY_SATELLITE) {
            satelliteFilters.add(String.format("lower(%s) = '%s'", "f_satellite", satellite.toLowerCase(Locale.ROOT)));
        }
        for (String satellite : ImageDataMatchUtil.GF7_SATELLITE) {
            satelliteFilters.add(String.format("lower(%s) = '%s'", "f_satellite", satellite.toLowerCase(Locale.ROOT)));
        }
        String condition = String.format("(%s) and (%s)", String.join((CharSequence)" or ", satelliteFilters), String.join((CharSequence)" or ", filters));
        queryFilterDTO.setCondition(condition);
        int rows = 10000;
        queryFilterDTO.setRows(Integer.valueOf(rows));
        int count = rows;
        int pageIndex = 0;
        ArrayList<ImageMatchDataDTO> needMatchDataList = new ArrayList<ImageMatchDataDTO>();
        while (count == rows) {
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            ++pageIndex;
            DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), queryFilterDTO);
            if (dataQueryResult != null && dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                for (FeatureResult item : dataQueryResult.getData()) {
                    String satellite;
                    String dataId = item.getAttributes().get("F_DATAID").toString();
                    Object satelliteObj = item.getAttributes().get("f_satellite");
                    String string = satellite = satelliteObj == null ? "" : satelliteObj.toString();
                    if (Arrays.stream(ImageDataMatchUtil.GF7_SATELLITE).anyMatch(f -> f.equalsIgnoreCase(satellite)) || Arrays.stream(ImageDataMatchUtil.ZY_SATELLITE).anyMatch(f -> f.equalsIgnoreCase(satellite))) {
                        ImageMatchDataDTO needMatchData = new ImageMatchDataDTO();
                        needMatchData.setDataId(dataId);
                        Object dataNameObj = item.getAttributes().get("F_DATANAME");
                        String dataName = dataNameObj == null ? "" : dataNameObj.toString();
                        log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u5339\u914d\u5f00\u59cb...", dataName));
                        String dataNamePrefix = ImageDataMatchUtil.getDataNamePrefix((String)dataName, (String)satellite);
                        ImageMatchDataDTO matchData = (ImageMatchDataDTO)com.geoway.adf.dms.common.util.ListUtil.find(needMatchDataList, f -> f.getDataName().toLowerCase(Locale.ROOT).startsWith(dataNamePrefix));
                        if (matchData == null) {
                            needMatchData.setDataName(dataName);
                            needMatchData.setSatellite(satellite);
                            needMatchData.setMatchDataNamePrefix(dataNamePrefix);
                            needMatchDataList.add(needMatchData);
                            log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u8fdb\u5165\u5f85\u5339\u914d\u533a", dataName));
                            continue;
                        }
                        log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u5339\u914d[%s]", dataName, matchData.getDataName()));
                        needMatchDataList.remove(matchData);
                    }
                    dataIdList.add(dataId);
                }
                continue;
            }
            count = 0;
        }
        return needMatchDataList;
    }

    private List<String> getMatchDataIdList(List<ImageMatchDataDTO> needMatchDataList) {
        ArrayList<String> dataIdList = new ArrayList<String>();
        ArrayList<String> conditionList = new ArrayList<String>();
        for (ImageMatchDataDTO item : needMatchDataList) {
            String condition = String.format("lower(%s) like '%s%%'", "F_DATANAME", item.getMatchDataNamePrefix());
            conditionList.add(condition);
        }
        String condition = String.join((CharSequence)" or ", conditionList);
        condition = String.format("f_image_type = %d and (%s)", ImageDatasetTypeEnum.OriginalImageDataset.getValue(), condition);
        log.info(String.format("\u5339\u914d\u6570\u636e\u67e5\u8be2\u6761\u4ef6\uff1a%s", condition));
        int rows = 10000;
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setCondition(condition);
        queryFilterDTO.setRows(Integer.valueOf(rows));
        int count = rows;
        int pageIndex = 0;
        while (count == rows) {
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            ++pageIndex;
            DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), queryFilterDTO);
            if (dataQueryResult != null && dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                for (FeatureResult item : dataQueryResult.getData()) {
                    String dataId = item.getAttributes().get("F_DATAID").toString();
                    Object satelliteObj = item.getAttributes().get("f_satellite");
                    String satellite = satelliteObj == null ? "" : satelliteObj.toString();
                    Object dataNameObj = item.getAttributes().get("F_DATANAME");
                    String dataName = dataNameObj == null ? "" : dataNameObj.toString();
                    String dataNamePrefix = ImageDataMatchUtil.getDataNamePrefix((String)dataName, (String)satellite);
                    ImageMatchDataDTO matchData = (ImageMatchDataDTO)com.geoway.adf.dms.common.util.ListUtil.find(needMatchDataList, f -> f.getDataName().toLowerCase(Locale.ROOT).startsWith(dataNamePrefix));
                    if (matchData == null) continue;
                    dataIdList.add(matchData.getDataId());
                    dataIdList.add(dataId);
                    log.info(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u5339\u914d[%s]", dataName, matchData.getDataName()));
                    needMatchDataList.remove(matchData);
                }
                continue;
            }
            count = 0;
        }
        for (ImageMatchDataDTO item : needMatchDataList) {
            log.warn(String.format("\u539f\u59cb\u5f71\u50cf[%s]\u672a\u5339\u914d\u5230", item.getDataName()));
            dataIdList.add(item.getDataId());
        }
        return dataIdList;
    }
}

