/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.catalog.constant.ResCatalogNodeTypeEnum;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.ResCatalogNodeService;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.entity.ImgRecycle;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageRecycleService;
import com.geoway.imagedb.dataset.service.ImgDatumTypeService;
import com.geoway.imagedb.dataset.service.ImgRecycleCatalogService;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ImgRecycleCatalogServiceImpl
implements ImgRecycleCatalogService {
    private static final Logger log = LoggerFactory.getLogger(ImgRecycleCatalogServiceImpl.class);
    @Resource
    private ResCatalogNodeService resCatalogNodeService;
    @Resource
    private ImageRecycleService imageRecycleService;
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private ImgDatumTypeService imgDatumTypeService;

    @Override
    public ResCatalogNodeDTO getCatalogTree(String keyword) {
        List<String> imageDatasetIds = this.imageRecycleService.queryAllDataset();
        if (imageDatasetIds == null || imageDatasetIds.size() == 0) {
            ResCatalogNodeDTO result = new ResCatalogNodeDTO();
            result.setNodeName("\u6570\u636e\u76ee\u5f55");
            result.setNodeId("-1");
            result.setNodeType(Integer.valueOf(ResCatalogNodeTypeEnum.FolderNode.getValue()));
            return result;
        }
        String datasetTypes = DatasetTypeEnum.DatumDataset.getValue() + "";
        ResCatalogNodeDTO catalogTree = this.resCatalogNodeService.getCatalogTree("-1", keyword, datasetTypes, Boolean.valueOf(false), Boolean.valueOf(false));
        this.filterRecycleDataset(catalogTree, imageDatasetIds);
        return catalogTree;
    }

    @Override
    public DataQueryResult queryRecycleImageData(String datasetId, Integer pageIndex, Integer rows) {
        ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
        Assert.notNull((Object)imgDataset, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        List<ImgRecycle> imgRecycleList = this.imageRecycleService.queryByDatasetId(datasetId);
        ImageDatasetTypeEnum imageDatasetType = ImageDatasetTypeEnum.getByValue(imgDataset.getImageDatasetType());
        LinkedList<String> queryFields = new LinkedList<String>();
        queryFields.add("F_DATANAME");
        if (imageDatasetType == ImageDatasetTypeEnum.ProcessedImageDataset) {
            queryFields.add("f_classification");
            queryFields.add("f_time");
            queryFields.add("f_resolution");
        } else {
            queryFields.add("f_sensor");
            queryFields.add("f_product_time");
            queryFields.add("f_cloud");
        }
        queryFields.add("f_import_user");
        queryFields.add("f_import_time");
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setCondition(String.format("%s = 1", "f_flag"));
        queryFilterDTO.setFields(String.join((CharSequence)",", queryFields));
        queryFilterDTO.setPageIndex(pageIndex);
        queryFilterDTO.setRows(rows);
        DataQueryResult queryResult = this.geoDatabaseService.queryGeoDataset(imgDataset.getGeoDatasetId(), queryFilterDTO);
        if (queryResult.getData() != null && queryResult.getData().size() > 0) {
            for (FeatureResult featureResult : queryResult.getData()) {
                ImgRecycle recycle = (ImgRecycle)ListUtil.find(imgRecycleList, f -> featureResult.getObjectId().toString().equals(f.getObjectId()));
                if (recycle == null) {
                    featureResult.getAttributes().put("f_delete_time", "");
                    continue;
                }
                featureResult.getAttributes().put("f_delete_time", DateUtil.format((Date)recycle.getDeleteTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
        if (queryResult.getFields().size() > 4) {
            ReturnField returnField = new ReturnField("f_delete_time", "\u5220\u9664\u65f6\u95f4");
            queryResult.getFields().add(4, returnField);
        }
        return queryResult;
    }

    private void filterRecycleDataset(ResCatalogNodeDTO resCatalogTree, List<String> imageDatasetIds) {
        List children = resCatalogTree.getChildren();
        ArrayList<ResCatalogNodeDTO> filterChildren = new ArrayList<ResCatalogNodeDTO>();
        if (children != null && children.size() > 0) {
            for (ResCatalogNodeDTO child : children) {
                if (child.getNodeType().intValue() == ResCatalogNodeTypeEnum.FolderNode.getValue()) {
                    this.filterRecycleDataset(child, imageDatasetIds);
                    if (child.getChildren().size() <= 0) continue;
                    filterChildren.add(child);
                    continue;
                }
                if (!imageDatasetIds.contains(((ResCatalogDataNodeDTO)child).getDatasetId())) continue;
                filterChildren.add(child);
            }
        }
        resCatalogTree.setChildren(filterChildren);
    }
}

