/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.util;

import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ImageDownloadUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageDownloadUtil.class);
    private static final String[] IE_BROWSERS = new String[]{"MSIE", "Trident", "Edge"};

    public static void downloadFile(String filePath) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        ImageDownloadUtil.downloadFile(filePath, servletRequestAttributes.getRequest(), servletRequestAttributes.getResponse());
    }

    public static void downloadTxtFile(List<String> contents) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
    }

    public static void downloadFile(String filePath, HttpServletRequest request, HttpServletResponse response) {
        File file = new File(filePath);
        Assert.state((boolean)file.exists(), (String)("\u8def\u5f84\u6709\u8bef : " + filePath));
        ServletOutputStream out = null;
        BufferedInputStream buff = null;
        FileInputStream is = null;
        String fileName = file.getName();
        try {
            int j;
            response.resetBuffer();
            String userAgent = request.getHeader("User-Agent");
            String rangeInfo = request.getHeader("range");
            fileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", fileName));
            response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
            response.setHeader("Content-Length", String.valueOf(file.length()));
            response.setHeader("Accept-Ranges", "bytes");
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            is = new FileInputStream(file);
            long start = 0L;
            long end = file.length() - 1L;
            if (rangeInfo != null && rangeInfo.startsWith("bytes=")) {
                String[] ranges = (rangeInfo = rangeInfo.substring("bytes=".length())).split("-");
                if (ranges.length == 1) {
                    if (rangeInfo.startsWith("-")) {
                        end = Long.parseLong(ranges[0]);
                    } else if (rangeInfo.endsWith("-")) {
                        start = Long.parseLong(ranges[0]);
                    }
                } else {
                    try {
                        start = Long.parseLong(ranges[0]);
                        end = Long.parseLong(ranges[1]);
                    }
                    catch (Exception e) {
                        log.error("range\u89e3\u6790\u5931\u8d25\uff01", (Throwable)e);
                    }
                }
                response.setStatus(206);
                response.setHeader("Content-Length", String.valueOf(end + 1L - start));
            }
            response.setHeader("Content-Range", "bytes " + start + "-" + end + "/" + file.length());
            response.setHeader("Access-Control-Expose-Headers", "Accept-Ranges");
            response.setHeader("Access-Control-Expose-Headers", "Content-Range");
            out = response.getOutputStream();
            buff = new BufferedInputStream(is);
            byte[] b = new byte[2048];
            buff.skip(start);
            for (long l = 0L; l < end + 1L - start; l += (long)j) {
                j = buff.read(b, 0, 2048);
                out.write(b, 0, j);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, is, buff});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out, is, buff});
    }
}

