/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.config.dto.dict.DmDictValueDTO;
import com.geoway.adf.dms.config.entity.DmDictValue;
import com.geoway.adf.dms.config.properties.DefaultCoordSchemeProperties;
import com.geoway.adf.dms.config.service.DictionaryService;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.ThumbDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.ThumbService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.constant.ImageExportTypeEnum;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeDTO;
import com.geoway.imagedb.dataset.dto.ImgDatumTypeFieldDTO;
import com.geoway.imagedb.dataset.dto.query.CoverageAnalyseFilterDTO;
import com.geoway.imagedb.dataset.dto.query.CoverageAnalyseResultDTO;
import com.geoway.imagedb.dataset.dto.query.ImageDetailQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageExportFilterDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryFilterDTO;
import com.geoway.imagedb.dataset.dto.query.ImageQueryResult;
import com.geoway.imagedb.dataset.dto.query.ImageRangeDTO;
import com.geoway.imagedb.dataset.dto.query.ImageResult;
import com.geoway.imagedb.dataset.dto.query.ImageSampleDetailQueryResult;
import com.geoway.imagedb.dataset.dto.query.SatelliteFilterDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.service.ImageQueryService;
import com.geoway.imagedb.dataset.service.ImgDatumTypeService;
import com.geoway.imagedb.dataset.util.FileReadUtil;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImageQueryServiceImpl
implements ImageQueryService {
    private static final Logger log = LoggerFactory.getLogger(ImageQueryServiceImpl.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private ThumbService thumbService;
    @Resource
    private ImgDatumTypeService imgDatumTypeService;
    @Resource
    private DictionaryService dictionaryService;
    @Resource
    private DefaultCoordSchemeProperties defaultCoordSchemeProperties;
    private final String DIC_SensorClassification = "DIC_SensorClassification";
    private final String DIC_ImageClassification = "DIC_DOMClassification";
    private Cache<String, ImageExportFilterDTO> exportFilter;

    @Autowired
    public void initCache() {
        this.exportFilter = Caffeine.newBuilder().expireAfterWrite(3L, TimeUnit.MINUTES).maximumSize(10000L).build();
    }

    @Override
    public ImageQueryResult queryByGeometry(ImageQueryFilterDTO filterDTO) {
        if (filterDTO.getImageType() == null || filterDTO.getImageType() == 0) {
            filterDTO.setImageType(11);
        }
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(filterDTO.getRows());
        queryFilterDTO.setPageIndex(filterDTO.getPageIndex());
        LinkedList<String> geometryList = new LinkedList<String>();
        if (StringUtil.isNotEmpty((String)filterDTO.getGeometry())) {
            geometryList.add(filterDTO.getGeometry());
        }
        queryFilterDTO.setGeometryList(geometryList);
        queryFilterDTO.setRelation(filterDTO.getRelation() == null ? SpatialRelationType.Intersects : filterDTO.getRelation());
        queryFilterDTO.setCondition(this.getImageQueryCondition(filterDTO));
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue(filterDTO.getImageType());
        return this.query(queryFilterDTO, filterDTO.getThumbSize(), imageType);
    }

    @Override
    public ImageQueryResult queryByDataIds(List<String> dataIdArray, Integer size) {
        if (dataIdArray == null || dataIdArray.size() == 0) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6edataId\uff01");
        }
        List filters = ListUtil.convertAll(dataIdArray, f -> String.format("%s = '%s'", "F_DATAID", f));
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(Integer.valueOf(dataIdArray.size()));
        queryFilterDTO.setCondition(String.join((CharSequence)" or ", filters));
        return this.query(queryFilterDTO, size, null);
    }

    @Override
    public ImageQueryResult queryByName(Integer imageType, MultipartFile file, Integer pageIndex, Integer rows, Integer thumbSize) {
        List<String> dataNames = this.readDataNameFromFile(file);
        List filters = ListUtil.convertAll(dataNames, f -> String.format("%s = '%s'", "F_DATANAME", f));
        String condition = String.format("%s = %d", "f_image_type", imageType);
        condition = StringUtil.isNotEmpty((String)condition) ? String.format("(%s) and %s", String.join((CharSequence)" or ", filters), condition) : String.join((CharSequence)" or ", filters);
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(rows);
        queryFilterDTO.setPageIndex(pageIndex);
        queryFilterDTO.setCondition(condition);
        ImageDatasetTypeEnum imageTypeEnum = ImageDatasetTypeEnum.getByValue(imageType);
        return this.query(queryFilterDTO, thumbSize, imageTypeEnum);
    }

    @Override
    public ImageRangeDTO queryDataIds(ImageQueryFilterDTO filterDTO) {
        if (filterDTO.getImageType() == null || filterDTO.getImageType() == 0) {
            filterDTO.setImageType(11);
        }
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(false));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
        queryFilterDTO.setRows(Integer.valueOf(10000));
        queryFilterDTO.setGeometry(filterDTO.getGeometry());
        queryFilterDTO.setRelation(filterDTO.getRelation() == null ? SpatialRelationType.Intersects : filterDTO.getRelation());
        queryFilterDTO.setCondition(this.getImageQueryCondition(filterDTO));
        return this.queryDataIds(queryFilterDTO, filterDTO.getImageType());
    }

    @Override
    public ImageRangeDTO queryDataIdsByName(Integer imageType, MultipartFile file) {
        List<String> dataNames = this.readDataNameFromFile(file);
        List filters = ListUtil.convertAll(dataNames, f -> String.format("%s = '%s'", "F_DATANAME", f));
        String condition = "";
        if (imageType == 11) {
            condition = String.format("(%s is not null)", "f_sensor");
        } else if (imageType == 21) {
            condition = String.format("(%s is null or %s ~'^\\d+(\\.\\d+)?$')", "f_sensor", "f_sensor");
        }
        condition = StringUtil.isNotEmpty((String)condition) ? String.format("(%s) and %s", String.join((CharSequence)" or ", filters), condition) : String.join((CharSequence)" or ", filters);
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(false));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(false));
        queryFilterDTO.setRows(Integer.valueOf(10000));
        queryFilterDTO.setCondition(condition);
        return this.queryDataIds(queryFilterDTO, imageType);
    }

    @Override
    public CoverageAnalyseResultDTO coverageAnalyse(ImageQueryFilterDTO filterDTO) {
        if (filterDTO.getImageType() == null || filterDTO.getImageType() == 0) {
            filterDTO.setImageType(11);
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)filterDTO.getGeometry())) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u8303\u56f4\uff01");
        }
        DmDictValueDTO dictTree = null;
        if (filterDTO.getImageType() == 11) {
            dictTree = this.dictionaryService.getDictionaryTree("DIC_SensorClassification");
            Assert.notNull((Object)dictTree, (String)"\u5b57\u5178DIC_SensorClassification\u4e0d\u5b58\u5728\uff01");
        } else if (filterDTO.getImageType() == 21) {
            dictTree = this.dictionaryService.getDictionaryTree("DIC_DOMClassification");
            Assert.notNull((Object)dictTree, (String)"\u5b57\u5178DIC_DOMClassification\u4e0d\u5b58\u5728\uff01");
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5f71\u50cf\u7c7b\u578b\uff01");
        }
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue(filterDTO.getImageType());
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(Integer.valueOf(10000));
        queryFilterDTO.setGeometry(filterDTO.getGeometry());
        queryFilterDTO.setRelation(filterDTO.getRelation() == null ? SpatialRelationType.Intersects : filterDTO.getRelation());
        queryFilterDTO.setCondition(this.getImageQueryCondition(filterDTO));
        return this.coverageAnalyseByFilter(dictTree, imageType, queryFilterDTO, filterDTO.getGeometry());
    }

    @Override
    public CoverageAnalyseResultDTO coverageAnalyseByDataIds(CoverageAnalyseFilterDTO filterDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)filterDTO.getGeometry())) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u8303\u56f4\uff01");
        }
        if (filterDTO.getDataIdArray() == null || filterDTO.getDataIdArray().size() == 0) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5f85\u5206\u6790\u7684\u7ed3\u679c\uff01");
        }
        List filters = ListUtil.convertAll(filterDTO.getDataIdArray(), f -> String.format("%s = '%s'", "F_DATAID", f));
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setReturnCount(Boolean.valueOf(true));
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        queryFilterDTO.setRows(Integer.valueOf(10000));
        queryFilterDTO.setCondition(String.join((CharSequence)" or ", filters));
        return this.coverageAnalyseByFilter(null, null, queryFilterDTO, filterDTO.getGeometry());
    }

    @Override
    public void exportCoverageRange(CoverageAnalyseResultDTO resultDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)resultDTO.getIntersectionBoundary()) && StringUtil.isEmptyOrWhiteSpace((String)resultDTO.getUnIntersectionBoundary())) {
            throw new RuntimeException("\u8bf7\u6307\u5b9a\u5bfc\u51fa\u7684\u8303\u56f4\u8fb9\u754c\uff01");
        }
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            localPath.toFile().mkdirs();
        }
        IFeatureWorkspace targetWorkspace = null;
        IFeatureCursor insertCursor = null;
        String targetFile = localPath.resolve("coverageArea").toString();
        try {
            targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)targetFile);
            Fields fields = new Fields();
            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"ObjectID"));
            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"ObjectID", (GeometryType)GeometryType.Polygon, (int)(this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid())));
            fields.addField((IField)new Field("SATE", "SATE", FieldType.String, 300));
            fields.addField((IField)new Field("PERCENT", "PERCENT", FieldType.Float));
            fields.addField((IField)new Field("AREA", "AREA", FieldType.Double));
            fields.addField((IField)new Field("INRER", "INRER", FieldType.Double));
            fields.addField((IField)new Field("COUNT", "COUNT", FieldType.Double));
            IFeatureClass featureClass = targetWorkspace.createFeatureClass("coverageArea", (IFields)fields, FeatureType.Polygon, "shape", "");
            if (featureClass == null) {
                throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25\uff01");
            }
            featureClass.createSpatialIndex();
            insertCursor = featureClass.insertFeature();
            IFeature feature = featureClass.createFeature();
            feature.setValue("SATE", (Object)resultDTO.getSatellite());
            feature.setValue("PERCENT", (Object)resultDTO.getCoveragePercent());
            feature.setValue("AREA", (Object)resultDTO.getRegionArea());
            feature.setValue("INRER", (Object)resultDTO.getIntersectionArea());
            feature.setValue("COUNT", (Object)resultDTO.getCount());
            IGeometry geometry = null;
            geometry = StringUtil.isNotEmpty((String)resultDTO.getIntersectionBoundary()) ? GeometryFunc.createGeometry((String)resultDTO.getIntersectionBoundary()) : GeometryFunc.createGeometry((String)resultDTO.getUnIntersectionBoundary());
            feature.setGeometry(geometry);
            insertCursor.insertFeature(feature);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
        String zipFile = localPath.resolve("coverageArea.zip").toString();
        ZipAndRarUtil.toZip((String)targetFile, (String)zipFile, (boolean)true);
        DownloadUtil.downloadFile((String)(localPath.resolve("coverageArea") + ".zip"));
    }

    @Override
    public List<ThumbDTO> queryThumb(List<String> dataIdArray, Integer size) {
        return this.thumbService.queryThumbs(dataIdArray, size);
    }

    @Override
    public DataQueryResult imageDetail(String datasetId, String dataId, Integer size) {
        ReturnField dataSizeField;
        ThumbDTO thumb;
        ImgDataset imgDataset = this.imageDatasetService.getImgDataset(datasetId);
        Assert.notNull((Object)imgDataset, (String)"\u672a\u77e5\u7684\u5f71\u50cf\u6570\u636e\u96c6\uff01");
        QueryFilterDTO filter = new QueryFilterDTO();
        filter.setReturnCount(Boolean.valueOf(true));
        filter.setReturnGeometry(Boolean.valueOf(true));
        filter.setCondition(String.format("%s = '%s'", "F_DATAID", dataId));
        DataQueryResult queryResult = this.dataSourceService.queryData(datasetId, filter);
        if (queryResult.getData() == null || queryResult.getData().size() == 0) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u76ee\u6807\u5f71\u50cf\uff01");
        }
        ImgDatumTypeDTO datumType = (ImgDatumTypeDTO)this.imgDatumTypeService.getDetail(imgDataset.getDatumTypeModelId());
        ArrayList<ReturnField> returnFields = new ArrayList<ReturnField>();
        for (ReturnField returnField : queryResult.getFields()) {
            Object field = (ImgDatumTypeFieldDTO)((Object)ListUtil.find(datumType.getFields(), f -> f.getName().equalsIgnoreCase(returnField.getName())));
            if (field == null || !field.getDisplay().booleanValue()) continue;
            returnFields.add(returnField);
        }
        queryResult.setFields(returnFields);
        if (size > 64 && (thumb = this.thumbService.queryThumb(dataId, size)) != null) {
            ((FeatureResult)queryResult.getData().get(0)).getAttributes().put("F_THUMB", thumb.getImageBase64());
        }
        if ((dataSizeField = (ReturnField)ListUtil.find((List)queryResult.getFields(), f -> f.getName().equalsIgnoreCase("F_DATASIZE"))) != null) {
            String originalFldName = dataSizeField.getName();
            dataSizeField.setName(dataSizeField.getName() + "_CONVERT");
            dataSizeField.setType(Integer.valueOf(FieldType.String.getValue()));
            for (FeatureResult featureResult : queryResult.getData()) {
                BigDecimal bigDecimal = new BigDecimal(featureResult.getAttributes().get(originalFldName) + "");
                String[] unit = new String[]{"B", "KB", "MB", "GB", "TB"};
                int index = 0;
                while (bigDecimal.compareTo(new BigDecimal(1024)) > 0) {
                    ++index;
                    bigDecimal = bigDecimal.divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP);
                }
                featureResult.getAttributes().put(dataSizeField.getName(), bigDecimal + " " + unit[index]);
            }
        }
        ImageDetailQueryResult imageDetailQueryResult = new ImageDetailQueryResult();
        BeanUtils.copyProperties((Object)queryResult, (Object)((Object)imageDetailQueryResult));
        if (datumType.getImageType().intValue() == ImageDatasetTypeEnum.OriginalImageDataset.getValue()) {
            DatasetNameInfo geoDatasetNameInfo = new DatasetNameInfo(imgDataset.getGeoDatasetId());
            String snapshotDatasetId = geoDatasetNameInfo.getType().intValue() == DatasetTypeEnum.MosaicDataset.getValue() ? imgDataset.getGeoDatasetId() : this.imageDatasetService.getSnapshotDatasetId(imgDataset.getGeoDatasetId());
            imageDetailQueryResult.setSnapshotRender(this.dataSourceManager.getDatasetRender(snapshotDatasetId));
            filter.setCondition(String.format("%s = '%s'", "F_DATAID", dataId));
            DataQueryResult snapshotResult = this.dataSourceService.queryData(snapshotDatasetId, filter);
            if (snapshotResult.getData() == null || snapshotResult.getData().size() == 0) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5feb\u89c6\u56fe");
            }
            String objectId = ((FeatureResult)snapshotResult.getData().get(0)).getObjectId().toString();
            imageDetailQueryResult.setObjectId(objectId);
        } else if (datumType.getImageType().intValue() == ImageDatasetTypeEnum.ProcessedImageDataset.getValue()) {
            imageDetailQueryResult.setSnapshotRender(this.dataSourceManager.getDatasetRender(imgDataset.getGeoDatasetId()));
            imageDetailQueryResult.setObjectId(((FeatureResult)queryResult.getData().get(0)).getObjectId().toString());
        } else {
            if (datumType.getImageType().intValue() == ImageDatasetTypeEnum.ImageSampleImageDataset.getValue()) {
                ImageSampleDetailQueryResult sampleDetail = new ImageSampleDetailQueryResult();
                BeanUtils.copyProperties((Object)queryResult, (Object)((Object)sampleDetail));
                HashMap<String, DatasetRenderDTO> subDatasetRenderMap = new HashMap<String, DatasetRenderDTO>(0);
                for (String typeKey : imgDataset.getSubDatasetIds().keySet()) {
                    DatasetRenderDTO render = this.dataSourceManager.getDatasetRender(imgDataset.getSubDatasetIds().get(typeKey));
                    if (render == null) continue;
                    subDatasetRenderMap.put(typeKey, render);
                }
                sampleDetail.setSubDatasetRenderMap(subDatasetRenderMap);
                return sampleDetail;
            }
            if (datumType.getImageType().intValue() == ImageDatasetTypeEnum.TileSampleImageDataset.getValue()) {
                // empty if block
            }
        }
        return imageDetailQueryResult;
    }

    @Override
    public String exportImagePermit(ImageExportFilterDTO filterDTO) {
        String permit = UUID.randomUUID().toString().replace("-", "");
        this.exportFilter.put((Object)permit, (Object)filterDTO);
        return permit;
    }

    public void exportImageShp(List<String> dataIdArray) {
        QueryFilterDTO filter = new QueryFilterDTO();
        filter.setReturnCount(Boolean.valueOf(false));
        filter.setReturnGeometry(Boolean.valueOf(false));
        filter.setRows(Integer.valueOf(10000));
        filter.setCondition(String.join((CharSequence)" or ", ListUtil.convertAll(dataIdArray, f -> String.format("%s = '%s'", "F_DATAID", f))));
        DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), filter);
        if (dataQueryResult.getData() == null || dataQueryResult.getData().size() == 0) {
            throw new RuntimeException("\u65e0\u5f85\u4e0b\u8f7d\u6570\u636e\uff01");
        }
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            localPath.toFile().mkdirs();
        }
        HashMap<String, List<String>> dataIdMap = new HashMap<String, List<String>>(0);
        for (FeatureResult item : dataQueryResult.getData()) {
            String datasetId = item.getAttributes().get("f_image_dataset_id").toString();
            String dataId = item.getAttributes().get("F_DATAID").toString();
            if (dataIdMap.containsKey(datasetId)) {
                ((List)dataIdMap.get(datasetId)).add(dataId);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(dataId);
            dataIdMap.put(datasetId, list);
        }
        this.exportCoverageArea(dataIdMap, localPath.toString());
    }

    @Override
    public void exportImage(ImageExportFilterDTO filterDTO) {
        List<String> dataIdArray = filterDTO.getDataIdArray();
        ImageExportTypeEnum exportTypeEnum = ImageExportTypeEnum.getByValue(filterDTO.getExportType());
        boolean returnGeometry = exportTypeEnum == ImageExportTypeEnum.ExportImageShp || exportTypeEnum == ImageExportTypeEnum.ExportUnIntersectionBoundary;
        QueryFilterDTO filter = new QueryFilterDTO();
        filter.setReturnCount(Boolean.valueOf(false));
        filter.setReturnGeometry(Boolean.valueOf(returnGeometry));
        filter.setRows(Integer.valueOf(10000));
        filter.setCondition(String.join((CharSequence)" or ", ListUtil.convertAll(dataIdArray, f -> String.format("%s = '%s'", "F_DATAID", f))));
        DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), filter);
        if (dataQueryResult.getData() == null || dataQueryResult.getData().size() == 0) {
            throw new RuntimeException("\u65e0\u5f85\u4e0b\u8f7d\u6570\u636e\uff01");
        }
        Integer imageTypeInt = Integer.parseInt(((FeatureResult)dataQueryResult.getData().get(0)).getAttributes().get("f_image_type").toString());
        ImageDatasetTypeEnum imageType = ImageDatasetTypeEnum.getByValue(imageTypeInt);
        switch (exportTypeEnum) {
            case ExportImageShp: {
                this.exportImageQueryShp(dataQueryResult, imageType);
                break;
            }
            case ExportImageSnapshot: {
                this.exportImageSnapshot(dataQueryResult);
                break;
            }
            case ExportExcel: {
                this.exportImageExcel(dataQueryResult, imageType);
                break;
            }
            case ExportUnIntersectionBoundary: {
                this.exportImageUnIntersectionBoundary(dataQueryResult, filterDTO.getGeometry());
                break;
            }
        }
    }

    @Override
    public void exportImageByPermit(String permit) {
        ImageExportFilterDTO filterDTO = (ImageExportFilterDTO)this.exportFilter.getIfPresent((Object)permit);
        if (filterDTO == null) {
            throw new RuntimeException("\u65e0\u6548\u7684\u901a\u884c\u8bc1\uff01");
        }
        this.exportImage(filterDTO);
    }

    private ImageRangeDTO queryDataIds(QueryFilterDTO queryFilterDTO, Integer imageType) {
        queryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        ImageRangeDTO imageRangeDTO = new ImageRangeDTO();
        long count = 10000L;
        int pageIndex = 0;
        ArrayList<String> dataIds = new ArrayList<String>();
        ArrayList<String> objectIds = new ArrayList<String>();
        ArrayList<String> satelliteArray = new ArrayList<String>();
        IGeometry geometry = null;
        while (count == 10000L) {
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), queryFilterDTO);
            if (dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                ++pageIndex;
                for (FeatureResult item : dataQueryResult.getData()) {
                    dataIds.add(item.getAttributes().get("F_DATAID").toString());
                    objectIds.add(item.getAttributes().get("objectid").toString());
                    if (imageType == 11) {
                        Object satelliteObj = item.getAttributes().get("f_satellite");
                        satelliteArray.add(satelliteObj == null ? "" : satelliteObj.toString());
                    }
                    if (item.getGeometry() == null) continue;
                    if (geometry == null) {
                        geometry = GeometryFunc.createGeometry((String)item.getGeometry());
                        continue;
                    }
                    geometry = geometry.union(GeometryFunc.createGeometry((String)item.getGeometry()));
                }
                continue;
            }
            count = 0L;
        }
        imageRangeDTO.setDataIdArray(dataIds);
        imageRangeDTO.setObjectIdArray(objectIds);
        imageRangeDTO.setSatelliteArray(satelliteArray);
        imageRangeDTO.setSnapshotRender(this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotDatasetId()));
        imageRangeDTO.setRangeRender(this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotCatDatasetId()));
        imageRangeDTO.setMergeGeometry(geometry == null ? null : geometry.toWkt());
        return imageRangeDTO;
    }

    private List<String> readDataNameFromFile(MultipartFile file) {
        LinkedList<String> dataNames;
        block24: {
            if (file == null) {
                throw new RuntimeException("\u8bf7\u6307\u5b9a\u6570\u636e\u540d\u79f0\u6587\u4ef6\uff01");
            }
            dataNames = new LinkedList<String>();
            String fileName = file.getOriginalFilename();
            if (StringUtil.isEmptyOrWhiteSpace((String)fileName)) {
                throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u6570\u636e\u540d\u79f0\u6587\u4ef6\u7684\u6587\u4ef6\u540d\uff01");
            }
            if ((fileName = fileName.toLowerCase(Locale.ROOT)).endsWith(".xls") || fileName.endsWith(".xlsx")) {
                try (InputStream fis = file.getInputStream();){
                    List excelContents = ExcelUtil.readExcelDataList((InputStream)fis, null);
                    if (excelContents.size() < 2) {
                        throw new RuntimeException("\u672a\u4ece\u6570\u636e\u540d\u79f0\u6587\u4ef6\u8bfb\u53d6\u5230\u6709\u6548\u7684\u6570\u636e\u540d\u79f0\uff01");
                    }
                    for (int i = 1; i < excelContents.size(); ++i) {
                        dataNames.add((String)((List)excelContents.get(i)).get(0));
                    }
                    break block24;
                }
                catch (IOException e) {
                    throw new RuntimeException("\u5b57\u6bb5\u6a21\u677f\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
                }
            }
            if (fileName.endsWith(".txt")) {
                List<String> lines = FileReadUtil.readFileLines(file);
                for (String line : lines) {
                    String[] array;
                    for (String item : array = line.split(",")) {
                        String utf_8_bom;
                        if (StringUtil.isEmptyOrWhiteSpace((String)item)) continue;
                        String dataName = item.trim();
                        if (dataName.startsWith(utf_8_bom = "\ufeff")) {
                            dataName = dataName.substring(1);
                        }
                        dataNames.add(dataName);
                    }
                }
            }
        }
        if (dataNames.size() == 0) {
            throw new RuntimeException("\u672a\u4ece\u6570\u636e\u540d\u79f0\u6587\u4ef6\u8bfb\u53d6\u5230\u6709\u6548\u7684\u6570\u636e\u540d\u79f0\uff01");
        }
        return dataNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportImageQueryShp(DataQueryResult dataQueryResult, ImageDatasetTypeEnum imageType) {
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            boolean bl = localPath.toFile().mkdirs();
        }
        IFeatureWorkspace targetWorkspace = null;
        IFeatureCursor insertCursor = null;
        String shpName = String.format("\u7ed3\u5408\u8868_%s", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        String targetShpFile = localPath.resolve(String.format("%s", shpName)).toString();
        try {
            targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)targetShpFile);
            Fields fields = new Fields();
            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"ObjectID"));
            List<ReturnField> returnFields = this.getReturnFields(imageType);
            for (ReturnField returnField : returnFields) {
                String fldName = returnField.getName();
                if (returnField.getName().length() > 10) {
                    fldName = fldName.substring(0, 9);
                }
                fields.addField((IField)new Field(fldName, returnField.getAlias(), FieldType.String, 500));
            }
            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"ObjectID", (GeometryType)GeometryType.Polygon, (int)(this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid())));
            IFeatureClass featureClass = targetWorkspace.createFeatureClass(shpName, (IFields)fields, FeatureType.Polygon, "shape", "");
            if (featureClass == null) {
                throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25\uff01");
            }
            featureClass.createSpatialIndex();
            insertCursor = featureClass.insertFeature();
            for (FeatureResult item : dataQueryResult.getData()) {
                Map<String, Object> attributes = this.convertImageQueryResultAttributes(imageType, item);
                IFeature feature = featureClass.createFeature();
                IGeometry geometry = GeometryFunc.createGeometry((String)item.getGeometry());
                feature.setGeometry(geometry);
                for (String fldName : attributes.keySet()) {
                    if (fldName.length() > 10) {
                        feature.setValue(fldName.substring(0, 9), attributes.get(fldName));
                        continue;
                    }
                    feature.setValue(fldName, attributes.get(fldName));
                }
                insertCursor.insertFeature(feature);
            }
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
        String zipFile = localPath.resolve(shpName + ".zip").toString();
        ZipAndRarUtil.toZip((String)targetShpFile, (String)zipFile, (boolean)true);
        DownloadUtil.downloadFile((String)(localPath.resolve(shpName) + ".zip"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportImageSnapshot(DataQueryResult dataQueryResult) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        String[] IE_BROWSERS = new String[]{"MSIE", "Trident", "Edge"};
        String zipFileName = String.format("\u5feb\u89c6\u56fe__%s.zip", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        try {
            response.resetBuffer();
            String userAgent = request.getHeader("User-Agent");
            zipFileName = Arrays.stream(IE_BROWSERS).anyMatch(userAgent::contains) ? URLEncoder.encode(zipFileName, "UTF-8") : new String(zipFileName.getBytes("UTF-8"), "ISO-8859-1");
            response.setHeader("Content-disposition", String.format("attachment; filename=\"%s\"", zipFileName));
            response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
            for (FeatureResult item : dataQueryResult.getData()) {
                File[] files;
                String imagePath = item.getAttributes().get("urihash").toString();
                File imageFile = new File(imagePath);
                if (!imageFile.exists() || (files = imageFile.getParentFile().listFiles()) == null || files.length == 0) continue;
                String imageFileName = FileUtil.getFileNameWithoutExtension((String)imagePath);
                outputStream.putNextEntry(new ZipEntry(imageFileName + "/"));
                outputStream.closeEntry();
                for (File fileItem : files) {
                    FileInputStream fis;
                    block9: {
                        fis = null;
                        try {
                            int hasRead;
                            String fileItemName = FileUtil.getFileNameWithoutExtension((String)fileItem.getAbsolutePath());
                            if (!imageFileName.equalsIgnoreCase(fileItemName) && !fileItemName.startsWith(imageFileName)) break block9;
                            outputStream.putNextEntry(new ZipEntry(imageFileName + "/" + fileItem.getName()));
                            fis = new FileInputStream(fileItem);
                            byte[] buffer = new byte[2048];
                            while ((hasRead = fis.read(buffer)) != -1) {
                                outputStream.write(buffer, 0, hasRead);
                            }
                            outputStream.closeEntry();
                        }
                        catch (Exception e) {
                            try {
                                log.error("\u5feb\u89c6\u56fe\u4e0b\u8f7d\u5931\u8d25\uff01" + fileItem.getAbsolutePath(), (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{fis});
                                throw throwable;
                            }
                            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{fis});
                            continue;
                        }
                    }
                    ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{fis});
                }
            }
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{outputStream});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void exportImageExcel(DataQueryResult dataQueryResult, ImageDatasetTypeEnum imageType) {
        ArrayList datas = new ArrayList();
        List<ReturnField> returnFields = this.getReturnFields(imageType);
        LinkedList<String> title = new LinkedList<String>();
        for (ReturnField returnField : returnFields) {
            title.add(returnField.getAlias());
        }
        datas.add(title);
        for (FeatureResult item : dataQueryResult.getData()) {
            Map<String, Object> attributes = this.convertImageQueryResultAttributes(imageType, item);
            LinkedList<Object> data = new LinkedList<Object>();
            for (ReturnField returnField : returnFields) {
                Object value = attributes.get(returnField.getName());
                if (value instanceof Date) {
                    data.add(DateUtil.format((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss"));
                    continue;
                }
                data.add(value);
            }
            datas.add(data);
        }
        String fileName = String.format("\u5143\u6570\u636e_%s.xls", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        String path = Paths.get(UploadPathConfig.getUploadPath().toString(), fileName).toAbsolutePath().toString();
        ExcelUtil.writeExcel(datas, (String)path);
        DownloadUtil.downloadFile((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportImageUnIntersectionBoundary(DataQueryResult dataQueryResult, String geometryStr) {
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            boolean bl = localPath.toFile().mkdirs();
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)geometryStr)) {
            throw new RuntimeException("\u5bfc\u51fa\u672a\u8986\u76d6\u8303\u56f4\u9700\u8981\u4f20\u9012 geometry \u53c2\u6570\uff01");
        }
        IGeometry queryGeometry = GeometryFunc.createGeometry((String)geometryStr);
        IGeometry unionGeometry = null;
        for (FeatureResult item : dataQueryResult.getData()) {
            IGeometry geometry = GeometryFunc.createGeometry((String)item.getGeometry());
            if (unionGeometry == null) {
                unionGeometry = geometry.clone();
                continue;
            }
            unionGeometry = unionGeometry.union(geometry);
        }
        IGeometry unIntersectionGeometry = queryGeometry.difference(unionGeometry);
        IFeatureWorkspace targetWorkspace = null;
        IFeatureCursor insertCursor = null;
        String shpName = String.format("\u672a\u8986\u76d6\u8303\u56f4_%s", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmssSSS"));
        String targetShpFile = localPath.resolve(String.format("%s", shpName)).toString();
        try {
            targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)targetShpFile);
            Fields fields = new Fields();
            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"ObjectID"));
            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"ObjectID", (GeometryType)GeometryType.Polygon, (int)(this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid())));
            IFeatureClass featureClass = targetWorkspace.createFeatureClass(shpName, (IFields)fields, FeatureType.Polygon, "shape", "");
            if (featureClass == null) {
                throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25\uff01");
            }
            featureClass.createSpatialIndex();
            insertCursor = featureClass.insertFeature();
            IFeature feature = featureClass.createFeature();
            feature.setGeometry(unIntersectionGeometry);
            insertCursor.insertFeature(feature);
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
        String zipFile = localPath.resolve(shpName + ".zip").toString();
        ZipAndRarUtil.toZip((String)targetShpFile, (String)zipFile, (boolean)true);
        DownloadUtil.downloadFile((String)(localPath.resolve(shpName) + ".zip"));
    }

    private ImageQueryResult query(QueryFilterDTO queryFilterDTO, Integer thumbSize, ImageDatasetTypeEnum imageType) {
        ImageQueryResult queryResult = new ImageQueryResult();
        DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), queryFilterDTO);
        queryResult.setTotal(dataQueryResult.getTotal());
        queryResult.setData(new ArrayList<ImageResult>());
        ArrayList<String> dataIds = new ArrayList<String>();
        if (dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
            for (FeatureResult item2 : dataQueryResult.getData()) {
                ImageResult imageResult = new ImageResult();
                imageResult.setDatasetId(item2.getAttributes().get("f_image_dataset_id").toString());
                imageResult.setDataId(item2.getAttributes().get("F_DATAID").toString());
                imageResult.setObjectId(item2.getAttributes().get("objectid").toString());
                if (item2.getAttributes().containsKey("category")) {
                    imageResult.setRecycled(99 == Integer.parseInt(item2.getAttributes().get("category").toString()));
                } else {
                    imageResult.setRecycled(false);
                }
                if (imageType == null) {
                    Integer imageTypeInt = Integer.parseInt(item2.getAttributes().get("f_image_type").toString());
                    imageType = ImageDatasetTypeEnum.getByValue(imageTypeInt);
                }
                Map<String, Object> attributes = this.convertImageQueryResultAttributes(imageType, item2);
                imageResult.setAttributes(attributes);
                imageResult.setGeometry(item2.getGeometry());
                queryResult.getData().add(imageResult);
                dataIds.add(imageResult.getDataId());
            }
        }
        List thumbs = this.thumbService.queryThumbs(dataIds, thumbSize);
        queryResult.getData().forEach(item -> {
            ThumbDTO targetThumb = (ThumbDTO)ListUtil.find((List)thumbs, f -> f.getDataId().equals(item.getDataId()));
            item.setThumbBase64(targetThumb == null ? null : targetThumb.getImageBase64());
        });
        queryResult.setSnapshotRender(this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotDatasetId()));
        queryResult.setRangeRender(this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotCatDatasetId()));
        queryResult.setFields(this.getReturnFields(imageType));
        return queryResult;
    }

    private CoverageAnalyseResultDTO coverageAnalyseByFilter(DmDictValueDTO dictTree, ImageDatasetTypeEnum imageType, QueryFilterDTO queryFilterDTO, String queryGeometryString) {
        long count = 10000L;
        int pageIndex = 0;
        ArrayList<CoverageAnalyseResultDTO> resultItems = new ArrayList<CoverageAnalyseResultDTO>();
        while (count == 10000L) {
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), queryFilterDTO);
            if (dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                ++pageIndex;
                for (FeatureResult item : dataQueryResult.getData()) {
                    String[] satList;
                    String sensor;
                    if (dictTree == null) {
                        Integer imageTypeInt = Integer.parseInt(item.getAttributes().get("f_image_type").toString());
                        imageType = ImageDatasetTypeEnum.getByValue(imageTypeInt);
                        if (imageType == ImageDatasetTypeEnum.OriginalImageDataset) {
                            dictTree = this.dictionaryService.getDictionaryTree("DIC_SensorClassification");
                            Assert.notNull((Object)dictTree, (String)"\u5b57\u5178DIC_SensorClassification\u4e0d\u5b58\u5728\uff01");
                        } else if (imageType == ImageDatasetTypeEnum.ProcessedImageDataset) {
                            dictTree = this.dictionaryService.getDictionaryTree("DIC_DOMClassification");
                            Assert.notNull((Object)dictTree, (String)"\u5b57\u5178DIC_DOMClassification\u4e0d\u5b58\u5728\uff01");
                        }
                    }
                    BigDecimal dataSize = new BigDecimal(item.getAttributes().get("F_DATASIZE").toString());
                    String satellite = item.getAttributes().get("f_satellite").toString();
                    Object sensorObj = item.getAttributes().get("f_sensor");
                    String string = sensor = sensorObj == null ? "" : sensorObj.toString();
                    if (imageType == ImageDatasetTypeEnum.ProcessedImageDataset && (satList = satellite.split("_")).length > 1) {
                        satellite = satList[satList.length - 2];
                        sensor = satList[satList.length - 1];
                    }
                    CoverageAnalyseResultDTO resultItem = null;
                    if (resultItems.size() > 0) {
                        String sat = satellite;
                        String sen = sensor;
                        resultItem = (CoverageAnalyseResultDTO)ListUtil.find(resultItems, f -> f.getSatellite().equals(sat) && f.getSensor().equals(sen));
                    }
                    if (resultItem == null) {
                        resultItem = new CoverageAnalyseResultDTO();
                        resultItem.setId(UUID.randomUUID().toString().replace("-", ""));
                        resultItem.setSatellite(satellite);
                        resultItem.setSensor(sensor);
                        resultItem.setCount(1);
                        resultItem.setObjectIdArray(new ArrayList<String>());
                        resultItem.getObjectIdArray().add(item.getObjectId().toString());
                        resultItem.setDataSize(dataSize.toString());
                        resultItem.setIntersectionBoundary(item.getGeometry());
                        resultItems.add(resultItem);
                        continue;
                    }
                    resultItem.setCount(resultItem.getCount() + 1);
                    resultItem.getObjectIdArray().add(item.getObjectId().toString());
                    resultItem.setDataSize(dataSize.add(new BigDecimal(resultItem.getDataSize())).toString());
                    IGeometry unionGeometry = GeometryFunc.createGeometry((String)resultItem.getIntersectionBoundary()).union(GeometryFunc.createGeometry((String)item.getGeometry()));
                    resultItem.setIntersectionBoundary(unionGeometry.toWkt());
                }
                continue;
            }
            count = 0L;
        }
        IGeometry queryGeometry = GeometryFunc.createGeometry((String)queryGeometryString);
        String rootId = dictTree == null ? UUID.randomUUID().toString() : dictTree.getId() + "";
        CoverageAnalyseResultDTO rootResult = new CoverageAnalyseResultDTO();
        rootResult.setId(rootId);
        rootResult.setObjectIdArray(new ArrayList<String>());
        rootResult.setSnapshotRender(this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotDatasetId()));
        rootResult.setRangeRender(this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotCatDatasetId()));
        rootResult.setPid(null);
        rootResult.setSatellite("\u603b\u4f53\u8986\u76d6");
        rootResult.setSensor("");
        if (resultItems.size() == 0 || dictTree == null) {
            rootResult.setChildren(new ArrayList<CoverageAnalyseResultDTO>());
            return rootResult;
        }
        double area = queryGeometry.getArea();
        rootResult.setChildren(this.getAnalyseResultChildren(dictTree, resultItems, queryGeometry, area));
        IGeometry unionGeometry = null;
        double dataSize = 0.0;
        int childrenCount = 0;
        for (CoverageAnalyseResultDTO child : rootResult.getChildren()) {
            IGeometry geometry = GeometryFunc.createGeometry((String)child.getIntersectionBoundary());
            unionGeometry = unionGeometry == null ? geometry.clone() : unionGeometry.union(geometry);
            childrenCount += child.getCount().intValue();
            dataSize += Double.parseDouble(child.getDataSize());
            child.setDataSize(child.getDataSize() + "TB");
            rootResult.getObjectIdArray().addAll(child.getObjectIdArray());
        }
        rootResult.setCount(childrenCount);
        rootResult.setDataSize(dataSize + "TB");
        this.completeCoverageAnalyseResult(rootResult, unionGeometry, queryGeometry, area);
        return rootResult;
    }

    private String getImageQueryCondition(ImageQueryFilterDTO filterDTO) {
        Object timeFilter;
        List<String> timeFilters;
        ArrayList<Object> conditions = new ArrayList<Object>();
        conditions.add("category = 1");
        if (filterDTO.getProductTimeArray() != null && filterDTO.getProductTimeArray().size() > 0) {
            timeFilters = ImageDateUtil.convertTimeFilters(filterDTO.getProductTimeArray(), "f_product_time");
            timeFilter = String.join((CharSequence)" or ", timeFilters);
            if (timeFilters.size() == 1) {
                conditions.add(timeFilter);
            } else {
                conditions.add("(" + (String)timeFilter + ")");
            }
        }
        if (filterDTO.getImportTimeArray() != null && filterDTO.getImportTimeArray().size() > 0) {
            timeFilters = ImageDateUtil.convertTimeFilters(filterDTO.getImportTimeArray(), "f_import_time");
            timeFilter = String.join((CharSequence)" or ", timeFilters);
            if (timeFilters.size() == 1) {
                conditions.add(timeFilter);
            } else {
                conditions.add("(" + (String)timeFilter + ")");
            }
        }
        if (filterDTO.getMinCloudPercent() != null && filterDTO.getMaxCloudPercent() != null) {
            conditions.add(String.format("((%s >= %s and %s <= %s) or %s is null)", "f_cloud", filterDTO.getMinCloudPercent(), "f_cloud", filterDTO.getMaxCloudPercent(), "f_cloud"));
        }
        if (filterDTO.getSatelliteArray() != null && filterDTO.getSatelliteArray().size() > 0) {
            ArrayList<String> satelliteFilters = new ArrayList<String>();
            for (SatelliteFilterDTO satellite : filterDTO.getSatelliteArray()) {
                if (satellite.getSensorArray() == null || satellite.getSensorArray().size() == 0) {
                    String item = String.format("(%s = '%s')", "f_satellite", satellite.getName());
                    satelliteFilters.add(item);
                    continue;
                }
                for (String sensor : satellite.getSensorArray()) {
                    String item = String.format("(%s = '%s' and %s like '%s%%')", "f_satellite", satellite.getName(), "f_sensor", sensor);
                    satelliteFilters.add(item);
                }
            }
            String satelliteFilter = String.join((CharSequence)" or ", satelliteFilters);
            if (satelliteFilters.size() == 1) {
                conditions.add(satelliteFilter);
            } else {
                conditions.add("(" + satelliteFilter + ")");
            }
        } else {
            if (filterDTO.getImageType() == 11) {
                throw new RuntimeException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4f20\u611f\u5668\uff01");
            }
            if (filterDTO.getImageType() == 21) {
                throw new RuntimeException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5f71\u50cf\u5206\u7c7b\uff01");
            }
        }
        if (filterDTO.getClassifyArray() != null && filterDTO.getClassifyArray().size() > 0 && filterDTO.getImageType() == 21) {
            List classifyFilters = ListUtil.convertAll(filterDTO.getClassifyArray(), f -> String.format("%s = '%s'", "f_satellite", f));
            String classifyFilter = String.join((CharSequence)" or ", classifyFilters);
            if (filterDTO.getClassifyArray().size() == 1) {
                conditions.add(classifyFilter);
            } else {
                conditions.add("(" + classifyFilter + ")");
            }
        }
        if (conditions.size() == 0) {
            return "";
        }
        conditions.add(String.format("%s = %d", "f_image_type", filterDTO.getImageType()));
        return String.join((CharSequence)" and ", conditions);
    }

    private List<ReturnField> getReturnFields(ImageDatasetTypeEnum imageType) {
        ArrayList<ReturnField> list = new ArrayList<ReturnField>();
        if (imageType == ImageDatasetTypeEnum.ProcessedImageDataset) {
            list.add(new ReturnField("F_DATANAME", "\u6570\u636e\u540d\u79f0"));
            list.add(new ReturnField("f_time", "\u65f6\u76f8"));
            list.add(new ReturnField("F_DATASIZE_CONVERT", "\u6570\u636e\u5927\u5c0f"));
        } else {
            list.add(new ReturnField("f_satellite", "\u536b\u661f\u540d\u79f0"));
            list.add(new ReturnField("f_sensor", "\u4f20\u611f\u5668"));
            list.add(new ReturnField("f_product_time", "\u5f71\u50cf\u91c7\u96c6\u65f6\u95f4"));
            list.add(new ReturnField("f_cloud", "\u4e91\u91cf"));
            list.add(new ReturnField("F_DATASIZE_CONVERT", "\u6570\u636e\u5927\u5c0f"));
            list.add(new ReturnField("F_DATANAME", "\u6570\u636e\u540d\u79f0"));
        }
        list.add(new ReturnField("f_resolution", "\u5206\u8fa8\u7387"));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCoverageArea(Map<String, List<String>> dataIdMap, String resultPath) {
        IFeatureWorkspace targetWorkspace = null;
        IFeatureCursor insertCursor = null;
        Path localPath = Paths.get(resultPath, new String[0]);
        String targetFile = localPath.resolve("coverageArea").toString();
        int featureCount = 0;
        try {
            targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)targetFile);
            Fields fields = new Fields();
            fields.addField(FieldUtil.buildObjectIdField((String)"objectid", (String)"ObjectID"));
            fields.addField((IField)new Field("F_DATAID", "\u6570\u636eID", FieldType.String, 32));
            fields.addField(FieldUtil.buildShapeField((String)"shape", (String)"ObjectID", (GeometryType)GeometryType.Polygon, (int)(this.defaultCoordSchemeProperties.getSrid() == null ? 4490 : this.defaultCoordSchemeProperties.getSrid())));
            IFeatureClass featureClass = targetWorkspace.createFeatureClass("coverageArea", (IFields)fields, FeatureType.Polygon, "shape", "");
            if (featureClass == null) {
                throw new RuntimeException("\u8981\u7d20\u7c7b\u521b\u5efa\u5931\u8d25\uff01");
            }
            featureClass.createSpatialIndex();
            insertCursor = featureClass.insertFeature();
            for (String datasetId : dataIdMap.keySet()) {
                IFeatureWorkspace workspace;
                DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
                DataSourceDTO dataSourceDTO = this.dataSourceManager.getGeoDatabaseDetail(nameInfo.getDsKey());
                if (dataSourceDTO == null || (workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSourceDTO)) == null) continue;
                IFeatureCursor cursor = null;
                try {
                    IFeatureClass srcFeatureClass = workspace.openFeatureClass(nameInfo.getShortName());
                    QueryFilter filter = new QueryFilter();
                    filter.setWhereClause(String.join((CharSequence)" or ", ListUtil.convertAll(dataIdMap.get(datasetId), f -> String.format("%s = '%s'", "F_DATAID", f))));
                    cursor = srcFeatureClass.searchFeature((IQueryFilter)filter);
                    IFeature srcFeature = cursor.nextFeature();
                    while (srcFeature != null) {
                        String dataId = srcFeature.getValue("F_DATAID").toString();
                        IFeature feature = featureClass.createFeature();
                        feature.setValue("F_DATAID", (Object)dataId);
                        IGeometry geometry = srcFeature.getGeometry();
                        geometry = geometry.projectToCopy(srcFeatureClass.getSpatialReferenceSystem(), featureClass.getSpatialReferenceSystem());
                        feature.setGeometry(geometry);
                        insertCursor.insertFeature(feature);
                        ++featureCount;
                        srcFeature = cursor.nextFeature();
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.release();
                    }
                    workspace.close();
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (insertCursor != null) {
                insertCursor.release();
            }
            if (targetWorkspace != null) {
                targetWorkspace.close();
            }
        }
        if (featureCount == 0) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u5f85\u4e0b\u8f7d\u6570\u636e\uff01");
        }
        String zipFile = localPath.resolve("coverageArea.zip").toString();
        ZipAndRarUtil.toZip((String)targetFile, (String)zipFile, (boolean)true);
        DownloadUtil.downloadFile((String)(localPath.resolve("coverageArea") + ".zip"));
    }

    private List<CoverageAnalyseResultDTO> getAnalyseResultChildren(DmDictValueDTO dictValueDTO, List<CoverageAnalyseResultDTO> resultItems, IGeometry queryGeometry, double area) {
        ArrayList<CoverageAnalyseResultDTO> results = new ArrayList<CoverageAnalyseResultDTO>();
        if (dictValueDTO.getChildren() != null && dictValueDTO.getChildren().size() > 0) {
            for (DmDictValueDTO item : dictValueDTO.getChildren()) {
                List list;
                List<CoverageAnalyseResultDTO> children = this.getAnalyseResultChildren(item, resultItems, queryGeometry, area);
                if (children.size() > 0) {
                    CoverageAnalyseResultDTO resultItem = new CoverageAnalyseResultDTO();
                    resultItem.setId(item.getId() + "");
                    resultItem.setPid(item.getFatherId() + "");
                    resultItem.setObjectIdArray(new ArrayList<String>());
                    resultItem.setSatellite(item.getCode());
                    IGeometry unionGeometry = null;
                    double dataSize = 0.0;
                    int count = 0;
                    for (CoverageAnalyseResultDTO child : children) {
                        IGeometry geometry = GeometryFunc.createGeometry((String)child.getIntersectionBoundary());
                        unionGeometry = unionGeometry == null ? geometry.clone() : unionGeometry.union(geometry);
                        count += child.getCount().intValue();
                        dataSize += Double.parseDouble(child.getDataSize());
                        child.setDataSize(child.getDataSize() + "TB");
                        resultItem.getObjectIdArray().addAll(child.getObjectIdArray());
                        child.setPid(resultItem.getId());
                    }
                    resultItem.setCount(count);
                    resultItem.setDataSize(dataSize + "");
                    this.completeCoverageAnalyseResult(resultItem, unionGeometry, queryGeometry, area);
                    resultItem.setChildren(children);
                    results.add(resultItem);
                }
                if (item.getLevel() != 0L && item.getLevel() != 1L && item.getLevel() != 2L && !"\u536b\u661f".equals(item.getRemark()) || (list = ListUtil.findAll(resultItems, f -> {
                    ArrayList<String> satelliteNames = new ArrayList<String>();
                    satelliteNames.add(item.getCode());
                    if (StringUtil.isNotEmpty((String)item.getRemark())) {
                        String[] aliasNames;
                        String remark = item.getRemark();
                        if (remark.contains("|")) {
                            remark = remark.replace("|", ",");
                        }
                        for (String aliasName : aliasNames = remark.split(",")) {
                            if ("\u536b\u661f".equals(aliasName)) continue;
                            satelliteNames.add(aliasName);
                        }
                    }
                    for (String name : satelliteNames) {
                        if (!f.getSatellite().equalsIgnoreCase(name)) continue;
                        return true;
                    }
                    return false;
                })) == null || list.size() <= 0) continue;
                ArrayList<CoverageAnalyseResultDTO> targetList = new ArrayList<CoverageAnalyseResultDTO>();
                if (item.getChildren() != null && item.getChildren().size() > 0) {
                    for (DmDictValue sensorCode : item.getChildren()) {
                        for (CoverageAnalyseResultDTO sensorResult : list) {
                            ArrayList<String> sensorNames = new ArrayList<String>();
                            sensorNames.add(sensorCode.getCode());
                            if (StringUtil.isNotEmpty((String)sensorCode.getRemark())) {
                                String[] aliasNames;
                                for (String aliasName : aliasNames = sensorCode.getRemark().split(",")) {
                                    sensorNames.add(aliasName);
                                }
                            }
                            for (String name : sensorNames) {
                                if (!sensorResult.getSensor().startsWith(name)) continue;
                                targetList.add(sensorResult);
                            }
                        }
                    }
                } else {
                    targetList.addAll(list);
                }
                if (targetList.size() <= 0) continue;
                CoverageAnalyseResultDTO target = this.mergeAnalyseResult(targetList);
                IGeometry geometry = GeometryFunc.createGeometry((String)target.getIntersectionBoundary());
                this.completeCoverageAnalyseResult(target, geometry, queryGeometry, area);
                BigDecimal mb = NumberUtil.div((Number)new BigDecimal(target.getDataSize()), (Number)BigDecimal.valueOf(0x100000L));
                BigDecimal tb = NumberUtil.div((Number)mb, (Number)BigDecimal.valueOf(0x100000L), (int)2);
                target.setDataSize(tb + "");
                results.add(target);
            }
        }
        return results;
    }

    private CoverageAnalyseResultDTO mergeAnalyseResult(List<CoverageAnalyseResultDTO> list) {
        CoverageAnalyseResultDTO result = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            BigDecimal dataSize = new BigDecimal(list.get(i).getDataSize());
            result.setCount(result.getCount() + list.get(i).getCount());
            result.setDataSize(dataSize.add(new BigDecimal(result.getDataSize())).toString());
            IGeometry unionGeometry = GeometryFunc.createGeometry((String)result.getIntersectionBoundary()).union(GeometryFunc.createGeometry((String)list.get(i).getIntersectionBoundary()));
            result.setIntersectionBoundary(unionGeometry.toWkt());
            result.getObjectIdArray().addAll(list.get(i).getObjectIdArray());
        }
        return result;
    }

    private void completeCoverageAnalyseResult(CoverageAnalyseResultDTO resultItem, IGeometry geometry, IGeometry queryGeometry, double area) {
        if (geometry == null) {
            return;
        }
        IGeometry intersectionGeometry = queryGeometry.intersection(geometry);
        IGeometry unIntersectionGeometry = queryGeometry.difference(geometry);
        resultItem.setIntersectionBoundary(intersectionGeometry.toWkt());
        double intersectionArea = intersectionGeometry.getArea();
        resultItem.setRegionArea(area);
        resultItem.setIntersectionArea(intersectionArea);
        if (unIntersectionGeometry == null || unIntersectionGeometry.isEmpty()) {
            resultItem.setCoveragePercent(100.0);
            resultItem.setUnIntersectionBoundary(null);
        } else {
            BigDecimal percent = new BigDecimal(intersectionArea).divide(new BigDecimal(area), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            resultItem.setCoveragePercent(percent.doubleValue());
            resultItem.setUnIntersectionBoundary(unIntersectionGeometry.toWkt());
        }
    }

    private Map<String, Object> convertImageQueryResultAttributes(ImageDatasetTypeEnum imageType, FeatureResult item) {
        Object resolutionObj;
        HashMap<String, Object> attributes = new HashMap<String, Object>(0);
        if (imageType == ImageDatasetTypeEnum.OriginalImageDataset) {
            attributes.put("f_satellite", item.getAttributes().get("f_satellite"));
            attributes.put("f_sensor", item.getAttributes().get("f_sensor"));
            attributes.put("f_product_time", item.getAttributes().get("f_product_time"));
            attributes.put("f_cloud", item.getAttributes().get("f_cloud"));
        } else if (imageType == ImageDatasetTypeEnum.ProcessedImageDataset) {
            attributes.put("f_time", item.getAttributes().get("f_product_time"));
            attributes.put("f_classification", item.getAttributes().get("f_satellite"));
        }
        Double resolution = null;
        if (item.getAttributes().containsKey("f_resolution") && (resolutionObj = item.getAttributes().get("f_resolution")) != null && StringUtil.isNotEmpty((String)resolutionObj.toString())) {
            resolution = Double.parseDouble(resolutionObj.toString());
        }
        attributes.put("f_resolution", resolution);
        BigDecimal bigDecimal = new BigDecimal(item.getAttributes().get("F_DATASIZE") + "");
        long dataSize = Long.parseLong(item.getAttributes().get("F_DATASIZE").toString());
        double size = NumberUtil.div((float)dataSize, (float)1024.0f, (int)2);
        attributes.put("F_DATASIZE", size + "");
        String[] unit = new String[]{"B", "KB", "MB", "GB", "TB"};
        int index = 0;
        while (bigDecimal.compareTo(new BigDecimal(1024)) > 0) {
            ++index;
            bigDecimal = bigDecimal.divide(new BigDecimal(1024), 2, RoundingMode.HALF_UP);
        }
        attributes.put("F_DATASIZE_CONVERT", bigDecimal + " " + unit[index]);
        attributes.put("F_DATANAME", item.getAttributes().get("F_DATANAME"));
        return attributes;
    }
}

