/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.geoway.adf.dms.catalog.entity.AppCatalogNode;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.imagedb.dataset.dto.dataset.ImageGeoDatasetDTO;
import com.geoway.imagedb.dataset.dto.query.catalog.ImageSampleDataQueryResultDTO;
import com.geoway.imagedb.dataset.dto.query.catalog.TileSampleDTO;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageCatalogQueryService;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class ImageCatalogQueryServiceImpl
implements ImageCatalogQueryService {
    private static final Logger log = LoggerFactory.getLogger(ImageCatalogQueryServiceImpl.class);
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private ImageDatasetService imageDatasetService;

    @Override
    public List<TileSampleDTO> queryTileSample(String nodeId, String objectId) {
        AppCatalogNode appCatalogNode = this.appCatalogNodeService.selectByNodeId(nodeId);
        if (appCatalogNode == null) {
            throw new RuntimeException(String.format("\u5e94\u7528\u76ee\u5f55\u8282\u70b9\u3010%S\u3011\u4e0d\u5b58\u5728\uff01", nodeId));
        }
        ImgDataset imgDataset = this.imageDatasetService.getImgDataset(appCatalogNode.getDatasetId());
        if (imgDataset == null) {
            throw new RuntimeException(String.format("\u5f71\u50cf\u6570\u636e\u96c6\u3010%S\u3011\u4e0d\u5b58\u5728\uff01", appCatalogNode.getDatasetId()));
        }
        ArrayList<TileSampleDTO> tileSamples = new ArrayList<TileSampleDTO>();
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setCondition("objectId = '" + objectId + "'");
        DataQueryResult queryResult = this.dataSourceService.queryData(appCatalogNode.getDatasetId(), queryFilterDTO);
        if (queryResult.getData() != null && queryResult.getData().size() > 0) {
            for (FeatureResult item : queryResult.getData()) {
                Object y2PathObj;
                Object y1PathObj;
                Object pathYObj;
                Object x2PathObj;
                Object x1PathObj = item.getAttributes().get("x1path");
                if (x1PathObj != null && StringUtil.isNotEmpty((String)x1PathObj.toString())) {
                    TileSampleDTO tileSampleX1 = new TileSampleDTO();
                    tileSampleX1.setName("\u524d\u671f\u5f71\u50cf");
                    tileSampleX1.setPicture(this.getTileSamplePicture(x1PathObj.toString()));
                    tileSamples.add(tileSampleX1);
                }
                if ((x2PathObj = item.getAttributes().get("x2path")) != null && StringUtil.isNotEmpty((String)x2PathObj.toString())) {
                    TileSampleDTO tileSampleX2 = new TileSampleDTO();
                    tileSampleX2.setName("\u540e\u671f\u5f71\u50cf");
                    tileSampleX2.setPicture(this.getTileSamplePicture(x2PathObj.toString()));
                    tileSamples.add(tileSampleX2);
                }
                if ((pathYObj = item.getAttributes().get("ypath")) != null && StringUtil.isNotEmpty((String)pathYObj.toString())) {
                    TileSampleDTO tileSampleY = new TileSampleDTO();
                    tileSampleY.setName("\u6837\u672c\u6807\u7b7e\u6210\u679c");
                    tileSampleY.setPicture(this.getTileSamplePicture(pathYObj.toString()));
                    tileSamples.add(tileSampleY);
                }
                if ((y1PathObj = item.getAttributes().get("y1path")) != null && StringUtil.isNotEmpty((String)y1PathObj.toString())) {
                    TileSampleDTO tileSampleY1 = new TileSampleDTO();
                    tileSampleY1.setName("\u524d\u671f\u5206\u7c7b\u6210\u679c");
                    tileSampleY1.setPicture(this.getTileSamplePicture(y1PathObj.toString()));
                    tileSamples.add(tileSampleY1);
                }
                if ((y2PathObj = item.getAttributes().get("y2path")) == null || !StringUtil.isNotEmpty((String)y2PathObj.toString())) continue;
                TileSampleDTO tileSampleY2 = new TileSampleDTO();
                tileSampleY2.setName("\u540e\u671f\u5206\u7c7b\u6210\u679c");
                tileSampleY2.setPicture(this.getTileSamplePicture(y2PathObj.toString()));
                tileSamples.add(tileSampleY2);
            }
        }
        return tileSamples;
    }

    @Override
    public ImageSampleDataQueryResultDTO queryImageSample(String nodeId, String objectId) {
        AppCatalogNode appCatalogNode = this.appCatalogNodeService.selectByNodeId(nodeId);
        if (appCatalogNode == null) {
            throw new RuntimeException(String.format("\u5e94\u7528\u76ee\u5f55\u8282\u70b9\u3010%S\u3011\u4e0d\u5b58\u5728\uff01", nodeId));
        }
        DatumDatasetDTO datumDatasetDTO = this.datumDatabaseService.getDatasetDetail(appCatalogNode.getDatasetId());
        if (datumDatasetDTO instanceof ImageGeoDatasetDTO) {
            ImageGeoDatasetDTO sampleDatasetDTO = (ImageGeoDatasetDTO)datumDatasetDTO;
            String dataId = "";
            QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
            queryFilterDTO.setCondition("objectId = '" + objectId + "'");
            DataQueryResult queryResult = this.dataSourceService.queryData(appCatalogNode.getDatasetId(), queryFilterDTO);
            if (queryResult.getData() != null && queryResult.getData().size() > 0) {
                for (FeatureResult item : queryResult.getData()) {
                    dataId = item.getAttributes().get("F_DATAID").toString();
                }
            }
            String imgDatasetId = sampleDatasetDTO.getSubsets().get("img").getId();
            queryFilterDTO.setCondition(String.format("%s = '%s'", "F_DATAID", dataId));
            queryResult = this.dataSourceService.queryData(imgDatasetId, queryFilterDTO);
            ArrayList<String> imageObjectIdList = new ArrayList<String>();
            if (queryResult.getData() != null && queryResult.getData().size() > 0) {
                for (FeatureResult item : queryResult.getData()) {
                    imageObjectIdList.add(item.getObjectId().toString());
                }
            }
            ImageSampleDataQueryResultDTO imageSampleDataQueryResultDTO = new ImageSampleDataQueryResultDTO();
            imageSampleDataQueryResultDTO.setDataId(dataId);
            imageSampleDataQueryResultDTO.setImageObjectIdList(imageObjectIdList);
            imageSampleDataQueryResultDTO.setImageRender(sampleDatasetDTO.getSubsets().get("img").getRender());
            imageSampleDataQueryResultDTO.setRegionRender(sampleDatasetDTO.getSubsets().get("range").getRender());
            imageSampleDataQueryResultDTO.setLabelRender(sampleDatasetDTO.getSubsets().get("label").getRender());
            return imageSampleDataQueryResultDTO;
        }
        throw new RuntimeException("\u6570\u636e\u96c6\u7c7b\u578b\u9519\u8bef\uff01");
    }

    private String getTileSamplePicture(String path) {
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            String picture = "";
            File file = new File(path);
            picture = encoder.encodeBuffer(Files.readAllBytes(file.toPath())).trim();
            picture = picture.replaceAll("\n", "").replaceAll("\r", "");
            String format = "image/png";
            if (path.toUpperCase(Locale.ROOT).endsWith(".PNG")) {
                format = "image/png";
            } else if (path.toUpperCase(Locale.ROOT).endsWith(".TIF") || path.toUpperCase(Locale.ROOT).endsWith(".TIFF")) {
                format = "image/tiff";
            } else if (path.toUpperCase(Locale.ROOT).endsWith(".JPG") || path.toUpperCase(Locale.ROOT).endsWith(".JPEG")) {
                format = "image/jpeg";
            }
            picture = "data:" + format + ";base64," + picture;
            return picture;
        }
        catch (Exception e) {
            log.error("\u5feb\u89c6\u56fe\u8f6cBase64\u5931\u8d25\uff01" + path, (Throwable)e);
            return null;
        }
    }
}

