/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.listener;

import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.event.DatasetAfterDeleteEvent;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.entity.ImgDataset;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class DatasetAfterDeleteEventListener
implements ApplicationListener<DatasetAfterDeleteEvent> {
    private static final Logger log = LoggerFactory.getLogger(DatasetAfterDeleteEventListener.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    protected GeoDatabaseService geoDatabaseService;
    @Resource
    protected DataSourceManager dataSourceManager;
    @Resource
    protected RenderIndexService renderIndexService;

    public void onApplicationEvent(DatasetAfterDeleteEvent event) {
        ImgDataset imgDataset;
        String geoDatasetId = event.getDatasetId();
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)geoDatasetId);
        if ((nameInfo.getType().equals(DatasetTypeEnum.FeatureClass.getValue()) || nameInfo.getType().equals(DatasetTypeEnum.MosaicDataset.getValue())) && (imgDataset = this.imageDatasetService.getImgDatasetByGeoDatasetId(geoDatasetId)) != null) {
            try {
                if (ImageDatasetTypeEnum.OriginalImageDataset.getValue() == imgDataset.getImageDatasetType().intValue() && nameInfo.getType().equals(DatasetTypeEnum.FeatureClass.getValue())) {
                    this.geoDatabaseService.deleteDataset(this.imageDatasetService.getSnapshotDatasetId(geoDatasetId));
                }
            }
            catch (Exception e) {
                log.error(geoDatasetId + "\u5173\u8054\u6570\u636e\u96c6\u5220\u9664\u5931\u8d25\uff01", (Throwable)e);
            }
            if (imgDataset.getSubDatasetIds() != null) {
                for (String id : imgDataset.getSubDatasetIds().values()) {
                    try {
                        this.geoDatabaseService.deleteDataset(id);
                    }
                    catch (Exception e) {
                        log.error(id + "\u5220\u9664\u5931\u8d25\uff01", (Throwable)e);
                    }
                }
            }
            this.imageDatasetService.deleteBusinessSnapshotByDatasetId(imgDataset.getDatasetId());
            this.deleteSampleBusinessInfo(imgDataset.getDatasetId());
            this.imageDatasetService.deleteImgBusinessInfo(imgDataset.getDatasetId());
            try {
                DatasetRenderDTO businessSnapshotDatasetRender = this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotDatasetId());
                if (businessSnapshotDatasetRender != null) {
                    this.renderIndexService.reloadRenderIndexCache(businessSnapshotDatasetRender);
                }
                DatasetRenderDTO businessSnapshotCatDatasetRender = this.dataSourceManager.getDatasetRender(this.imageDatasetService.getBusinessSnapshotCatDatasetId());
                if (businessSnapshotDatasetRender != null) {
                    this.renderIndexService.reloadRenderIndexCache(businessSnapshotCatDatasetRender);
                }
            }
            catch (Exception e) {
                log.error("\u91cd\u5efa\u5168\u96c6\u5feb\u89c6\u56fe\u6e32\u67d3\u7d22\u5f15\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSampleBusinessInfo(String imageDatasetId) {
        DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
        String sql = String.format("delete from %s where %s = '%s'", "tb_sample_data", "f_image_dataset_id", imageDatasetId);
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);){
            workspace.excuteSql(sql);
        }
    }
}

