/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.query.StatQueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.StatQueryResultDTO;
import com.geoway.adf.dms.datasource.service.impl.GeoDatabaseServiceImpl;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.imagedb.dataset.service.ImageRecycleService;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class ImageGeoDatabaseServiceImpl
extends GeoDatabaseServiceImpl {
    @Resource
    private ImageRecycleService imageRecycleService;

    public ImageGeoDatabaseServiceImpl(DataSource dataSource, ApplicationEventPublisher applicationEventPublisher) {
        super(dataSource, applicationEventPublisher);
    }

    public List<StatQueryResultDTO> queryDataStatistics(String dsKey, String datasetName, StatQueryFilterDTO statFilter) {
        List<String> datasetIdList = this.imageRecycleService.queryAllDataset();
        if (datasetIdList != null && datasetIdList.size() > 0) {
            String dtName = datasetName;
            if (datasetName.contains(".")) {
                dtName = datasetName.substring(datasetName.indexOf(".") + 1);
            }
            for (String datasetId : datasetIdList) {
                DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
                String name = nameInfo.getShortName();
                if (!name.equalsIgnoreCase(dtName) || !dsKey.equals(nameInfo.getDsKey())) continue;
                if (StringUtil.isEmptyOrWhiteSpace((String)statFilter.getCondition())) {
                    statFilter.setCondition(String.format("%s = 0", "f_flag"));
                    break;
                }
                statFilter.setCondition(String.format("(%s) and %s = 0", statFilter.getCondition(), "f_flag"));
                break;
            }
        }
        return super.queryDataStatistics(dsKey, datasetName, statFilter);
    }
}

