/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.dataset.service.impl;

import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.imagedb.dataset.dao.ImgRecycleDao;
import com.geoway.imagedb.dataset.entity.ImgRecycle;
import com.geoway.imagedb.dataset.service.ImageRecycleService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ImageRecycleServiceImpl
implements ImageRecycleService {
    private static final Logger log = LoggerFactory.getLogger(ImageRecycleServiceImpl.class);
    @Resource
    private ImgRecycleDao imgRecycleDao;
    @Resource
    private LoginUserService loginUserService;

    @Override
    public ImgRecycle queryByDataId(String dataId) {
        return this.imgRecycleDao.selectByPrimaryKey(dataId);
    }

    @Override
    public List<ImgRecycle> queryByDatasetObjectIdList(String datasetId, List<String> objectIdList) {
        return this.imgRecycleDao.selectByDatasetObjectIdList(datasetId, objectIdList);
    }

    @Override
    public List<ImgRecycle> queryByDatasetId(String datasetId) {
        return this.imgRecycleDao.selectByDatasetId(datasetId);
    }

    @Override
    public void deleteImageRecycleByDataId(String dataId) {
        this.imgRecycleDao.deleteByPrimaryKey(dataId);
    }

    @Override
    public void deleteImageRecycleByDataIdList(List<String> dataIdList) {
        this.imgRecycleDao.deleteByDataIdList(dataIdList);
    }

    @Override
    public void deleteImageRecycleByDatasetId(String datasetId) {
        this.imgRecycleDao.deleteByDatasetId(datasetId);
    }

    @Override
    public List<String> queryAllDataset() {
        return this.imgRecycleDao.queryAllDatasetId();
    }

    @Override
    public void addImageToRecycle(String dataId, String objectId, String datasetId) {
        LoginUserInfo user = this.loginUserService.getUserInfo(null);
        ImgRecycle recycle = this.imgRecycleDao.selectByPrimaryKey(dataId);
        if (recycle != null) {
            return;
        }
        ImgRecycle imgRecycle = new ImgRecycle();
        imgRecycle.setDataId(dataId);
        imgRecycle.setObjectId(objectId);
        imgRecycle.setDatasetId(datasetId);
        imgRecycle.setDeleteTime(new Date());
        imgRecycle.setDeleteUser(user.getUserName());
        this.imgRecycleDao.insert(imgRecycle);
    }
}

