/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.component;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.datasource.dto.create.FieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.FileDataService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.dms.datasource.service.MosaicDatasetService;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geosrv.util.HttpClientUtil;
import com.geoway.imagedb.dataset.constant.ImageDatasetTypeEnum;
import com.geoway.imagedb.dataset.service.ImageDatasetService;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ImageAutomaticSchedule {
    private static final Logger log = LoggerFactory.getLogger(ImageAutomaticSchedule.class);
    @Resource
    private ImageDatasetService imageDatasetService;
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private FileDataService fileDataService;
    @Resource
    private FileStorageService fileStorageService;
    @Resource
    private MosaicDatasetService mosaicDatasetService;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);
    private final RunningScheduler task = new RunningScheduler();

    @PostConstruct
    public void initSchedules() {
        log.info("\u539f\u59cb\u5f71\u50cf\u65e0\u4eba\u503c\u5b88\u751f\u4ea7\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1");
        String starTimeStr = EnvironmentConfig.getProperty((String)"project.automatic-image-start-time", (String)"");
        if (StringUtil.isEmptyOrWhiteSpace((String)starTimeStr)) {
            log.error("project.automatic-image-start-time\u672a\u914d\u7f6e\uff0c\u4e0d\u542f\u52a8\u65e0\u4eba\u503c\u5b88\u5b9a\u65f6\u4efb\u52a1");
            return;
        }
        String intervalStr = EnvironmentConfig.getProperty((String)"project.automatic-image-interval", (String)"1");
        try {
            Date dateNow = new Date();
            Date startDate = ImageDateUtil.parse((String)starTimeStr);
            long period = Long.parseLong(intervalStr) * 3600L;
            Date nextDate = this.getNextDate(dateNow, startDate, period);
            long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
            this.task.future = this.scheduler.scheduleAtFixedRate(this::executeTask, initialDelay, period, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("\u539f\u59cb\u5f71\u50cf\u65e0\u4eba\u503c\u5b88\u751f\u4ea7\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @PreDestroy
    public void stopSchedules() {
        this.shutdownScheduler();
    }

    private Date getNextDate(Date nowDate, Date startDate, long period) {
        long interval = DateUtil.between((Date)nowDate, (Date)startDate, (DateUnit)DateUnit.SECOND);
        if (nowDate.compareTo(startDate) > 0) {
            interval = (long)((int)Math.ceil((double)interval / (double)period)) * period - interval;
        }
        if (interval == 0L) {
            interval = period;
        }
        return DateUtil.offsetSecond((Date)nowDate, (int)((int)interval));
    }

    private void executeTask() {
        this.checkIsPushFld();
        log.info("\u539f\u59cb\u5f71\u50cf\u65e0\u4eba\u503c\u5b88\u751f\u4ea7\u6570\u636e\u5f00\u59cb\u53d1\u9001...");
        int rows = 10000;
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setCondition(String.format("f_is_push = %d and f_image_type = %d", ConstantsValue.FALSE_VALUE, ImageDatasetTypeEnum.OriginalImageDataset.getValue()));
        queryFilterDTO.setRows(Integer.valueOf(rows));
        int count = rows;
        int pageIndex = 0;
        HashMap<String, IFileStorage> serverIdUrlMap = new HashMap<String, IFileStorage>(0);
        while (count == rows) {
            ArrayList<String> dataIdList = new ArrayList<String>();
            queryFilterDTO.setPageIndex(Integer.valueOf(pageIndex));
            ++pageIndex;
            DataQueryResult dataQueryResult = this.dataSourceService.queryData(this.imageDatasetService.getBusinessSnapshotDatasetId(), queryFilterDTO);
            if (dataQueryResult != null && dataQueryResult.getData() != null && dataQueryResult.getData().size() > 0) {
                count = dataQueryResult.getData().size();
                for (FeatureResult item : dataQueryResult.getData()) {
                    String dataId = item.getAttributes().get("F_DATAID").toString();
                    dataIdList.add(dataId);
                }
                JSONObject json = new JSONObject();
                JSONArray dataArray = new JSONArray();
                List fileDataList = this.fileDataService.getFileDataList(dataIdList);
                for (DmFileData item : fileDataList) {
                    String dataId = item.getDataId();
                    String dataName = item.getDataName();
                    List<String> filePaths = this.getFilePaths(serverIdUrlMap, item);
                    JSONObject data = new JSONObject();
                    data.put("dataId", (Object)dataId);
                    data.put("dataName", (Object)dataName);
                    data.put("files", filePaths);
                    dataArray.add((Object)data);
                }
                json.put("originalDataArray", (Object)dataArray);
                boolean success = this.sendOriginalImageData(json);
                if (!success) continue;
                this.updatePushStatus(dataIdList);
                continue;
            }
            count = 0;
        }
    }

    private boolean sendOriginalImageData(JSONObject json) {
        String jsonStr = json.toJSONString();
        String url = EnvironmentConfig.getProperty((String)"project.automatic-image-product-url", (String)"http://172.16.67.71:9220/rsmse-sz-seawatch-admin/");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        log.info("\u63a8\u9001\u5f71\u50cf\u6570\u636eURL\uff1a{}", (Object)url);
        HashMap<String, String> header = new HashMap<String, String>(0);
        header.put("Content-Type", "application/json;charset=UTF-8");
        String result = "";
        log.info(jsonStr);
        try {
            result = HttpClientUtil.doPostJson((String)String.format("%srs/unattended/unattendedSource", url), (String)jsonStr, header, (int)30000);
        }
        catch (Exception e) {
            log.error("\u539f\u59cb\u5f71\u50cf\u6570\u636e\u540c\u6b65\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (resultJson.getInteger("code") == 200) {
            log.info("\u539f\u59cb\u5f71\u50cf\u6570\u636e\u540c\u6b65\u6210\u529f\uff01");
            log.info(resultJson.toJSONString());
            return true;
        }
        log.error("\u539f\u59cb\u5f71\u50cf\u6570\u636e\u540c\u6b65\u5931\u8d25\uff01");
        log.info(resultJson.toJSONString());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePushStatus(List<String> dataIdList) {
        List dataIdInList = ListUtil.convertAll(dataIdList, f -> "'" + f + "'");
        String sql = String.format("update %s set f_is_push = %d where %s in (%s)", "GWMD_tbimg_businesssnapshot_CAT", ConstantsValue.TRUE_VALUE, "F_DATAID", StringUtil.join((String)",", (Iterable)dataIdInList));
        log.info("\u4fee\u6539\u6570\u636e\u53d1\u9001\u72b6\u6001\uff1a" + sql);
        DataSourceDTO dataSource = this.imageDatasetService.getBusinessSnapshotDataSource();
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)dataSource);){
            workspace.excuteSql(sql);
        }
    }

    private List<String> getFilePaths(Map<String, IFileStorage> serverIdUrlMap, DmFileData dmFileData) {
        ArrayList<String> filePaths = new ArrayList<String>();
        List fileList = JSONArray.parseArray((String)dmFileData.getCatalogFiles(), FileDataUnit.class);
        String finalDir = StringUtil.isEmptyOrWhiteSpace((String)dmFileData.getMainPath()) ? "/" : dmFileData.getMainPath().replace("\\", "/");
        List files = ListUtil.findAll((List)fileList, f -> FileUtil.getDirectoryName((String)f.getFileLocation()).replace("\\", "/").equals(finalDir));
        for (FileDataUnit file : files) {
            IFileStorage fileStorage;
            String url = "";
            if (!serverIdUrlMap.containsKey(dmFileData.getServerId())) {
                fileStorage = null;
                try {
                    fileStorage = this.fileStorageService.openFileStorage(dmFileData.getServerId());
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u670d\u52a1\u5931\u8d25\uff01", (Throwable)e);
                }
                if (fileStorage == null) {
                    url = file.getFileSourceLocation();
                } else {
                    serverIdUrlMap.put(dmFileData.getServerId(), fileStorage);
                    url = fileStorage.combinePaths(fileStorage.getStorageUrl(), new String[]{file.getFileLocation()});
                }
            } else {
                fileStorage = serverIdUrlMap.get(dmFileData.getServerId());
                url = fileStorage.combinePaths(fileStorage.getStorageUrl(), new String[]{file.getFileLocation()});
            }
            filePaths.add(url);
        }
        return filePaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIsPushFld() {
        DataSourceDTO targetDatabase = this.imageDatasetService.getBusinessSnapshotDataSource();
        try (IFeatureWorkspace businessSnapshotWorkspace = null;){
            businessSnapshotWorkspace = GeoDatabaseUtil.openGeoDatabase((DataSourceDTO)targetDatabase);
            IMosaicDataset businessSnapshotDataset = businessSnapshotWorkspace.openMosaicDataset(this.imageDatasetService.getBusinessSnapshotDatasetName());
            if (businessSnapshotDataset.getCatalog().getFields().findFieldIndex("f_is_push") < 0) {
                MosaicDatasetEditDTO editDTO = new MosaicDatasetEditDTO();
                editDTO.setId(this.imageDatasetService.getBusinessSnapshotDatasetId());
                editDTO.setAliasName("\u5feb\u89c6\u56fe");
                editDTO.setInvalidValue(Double.valueOf(0.0));
                FieldsEditDTO fieldsEditDTO = new FieldsEditDTO();
                ArrayList<FieldDTO> addFields = new ArrayList<FieldDTO>();
                FieldDTO isPushFld = new FieldDTO();
                isPushFld.setName("f_is_push");
                isPushFld.setAliasName("\u662f\u5426\u751f\u4ea7");
                isPushFld.setFieldType(Integer.valueOf(FieldType.Int.getValue()));
                isPushFld.setDefaultValue(ConstantsValue.FALSE_VALUE + "");
                addFields.add(isPushFld);
                fieldsEditDTO.setAddFields(addFields);
                editDTO.setFields(fieldsEditDTO);
                this.mosaicDatasetService.updateMosaicDataset(editDTO);
            }
        }
    }

    private void shutdownScheduler() {
        this.scheduler.shutdown();
    }

    static class RunningScheduler {
        public ScheduledFuture<?> future;
        public boolean canceled = false;

        RunningScheduler() {
        }
    }
}

