/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.imagedb.dataset.util.FileReadUtil;
import com.geoway.imagedb.input.dao.ImgMetaPluginDao;
import com.geoway.imagedb.input.dto.meta.ImageMetaPluginDTO;
import com.geoway.imagedb.input.dto.meta.MetaFieldMappingCheckDTO;
import com.geoway.imagedb.input.dto.meta.MetaFieldMappingDTO;
import com.geoway.imagedb.input.dto.meta.PluginDTO;
import com.geoway.imagedb.input.entity.ImgMetaPlugin;
import com.geoway.imagedb.input.plugin.meta.CommonMetaDataPlugin;
import com.geoway.imagedb.input.plugin.meta.IImageMetaDataPlugin;
import com.geoway.imagedb.input.plugin.meta.MetaPlugin;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import com.geoway.imagedb.input.service.ImageMetaPluginService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImageMetaPluginServiceImpl
implements ImageMetaPluginService {
    private static final Logger log = LoggerFactory.getLogger(ImageMetaPluginServiceImpl.class);
    @Resource
    private ImgMetaPluginDao imgMetaPluginDao;
    @Resource
    private FileStorageService fileStorageService;
    Map<String, PluginDTO> pluginMap = new HashMap<String, PluginDTO>();

    @Override
    public List<ImageMetaPluginDTO> getList(String keyword) {
        List<ImgMetaPlugin> pluginList = this.imgMetaPluginDao.selectAll(keyword);
        ArrayList<ImageMetaPluginDTO> list = new ArrayList<ImageMetaPluginDTO>();
        for (ImgMetaPlugin plugin : pluginList) {
            ImageMetaPluginDTO dto = new ImageMetaPluginDTO();
            dto.setId(plugin.getId());
            dto.setName(plugin.getName());
            dto.setDesc(plugin.getDesc());
            dto.setPluginAssembly(plugin.getAssembly());
            dto.setPluginClassname(plugin.getClassname());
            list.add(dto);
        }
        return list;
    }

    @Override
    public ImageMetaPluginDTO getDetail(String id) {
        ImgMetaPlugin plugin = this.imgMetaPluginDao.selectByPrimaryKey(id);
        if (plugin == null) {
            throw new RuntimeException("\u5143\u6570\u636e\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        return this.convert(plugin);
    }

    @Override
    public List<PluginDTO> getPluginList() {
        if (this.pluginMap.size() > 0) {
            return new ArrayList<PluginDTO>(this.pluginMap.values());
        }
        try {
            org.springframework.core.io.Resource[] resources;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory();
            for (org.springframework.core.io.Resource resource : resources = resolver.getResources("classpath*:com/geoway/imagedb/input/plugin/**/*.class")) {
                try {
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    Class<?> clazz = Class.forName(className);
                    if (!IImageMetaDataPlugin.class.isAssignableFrom(clazz) || !clazz.isAnnotationPresent(MetaPlugin.class) || clazz.isInterface() || this.pluginMap.values().stream().anyMatch(p -> p.getClass().equals(clazz))) continue;
                    MetaPlugin annotation = clazz.getAnnotation(MetaPlugin.class);
                    IImageMetaDataPlugin plugin = (IImageMetaDataPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    PluginDTO pluginDTO = new PluginDTO();
                    pluginDTO.setPluginName(plugin.getName());
                    pluginDTO.setPluginClassname(className);
                    this.pluginMap.put(annotation.name(), pluginDTO);
                    log.info("\u53d1\u73b0\u5143\u6570\u636e\u8bfb\u53d6\u63d2\u4ef6: " + plugin.getName() + " v" + annotation.version());
                }
                catch (Exception e) {
                    log.error("\u5143\u6570\u636e\u63d2\u4ef6\u83b7\u53d6\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5143\u6570\u636e\u63d2\u4ef6\u5217\u8868\u83b7\u53d6\u5931\u8d25\uff01", (Throwable)e);
        }
        return new ArrayList<PluginDTO>(this.pluginMap.values());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String addMetaPlugin(String name, String desc) {
        ImgMetaPlugin metaPlugin = new ImgMetaPlugin();
        metaPlugin.setId(UUID.randomUUID().toString().replace("-", ""));
        metaPlugin.setName(name);
        metaPlugin.setDesc(desc);
        metaPlugin.setPid("-1");
        metaPlugin.setType(1);
        metaPlugin.setClassname(CommonMetaDataPlugin.class.getName());
        ArrayList fieldMapping = new ArrayList();
        metaPlugin.setDetail(JSONArray.toJSONString(fieldMapping));
        this.imgMetaPluginDao.insert(metaPlugin);
        return metaPlugin.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateMetaPlugin(String id, String name, String desc) {
        ImgMetaPlugin plugin = this.imgMetaPluginDao.selectByPrimaryKey(id);
        if (plugin == null) {
            throw new RuntimeException("\u5143\u6570\u636e\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        plugin.setName(name);
        plugin.setDesc(desc);
        this.imgMetaPluginDao.updateByPrimaryKey(plugin);
        return plugin.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveMetaPlugin(ImageMetaPluginDTO metaPlugin) {
        if (metaPlugin.getId() == null) {
            throw new RuntimeException("\u8bf7\u8bbe\u7f6e\u6807\u8bc6");
        }
        ImgMetaPlugin plugin = this.imgMetaPluginDao.selectByPrimaryKey(metaPlugin.getId());
        if (plugin == null) {
            throw new RuntimeException("\u5143\u6570\u636e\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        plugin.setName(metaPlugin.getName());
        plugin.setDesc(metaPlugin.getDesc());
        plugin.setAssembly(metaPlugin.getPluginAssembly());
        plugin.setClassname(metaPlugin.getPluginClassname());
        for (MetaFieldMappingDTO mapping : metaPlugin.getFieldMapping()) {
            if (!StringUtil.isEmptyOrWhiteSpace((String)mapping.getId())) continue;
            mapping.setId(UUID.randomUUID().toString().replace("-", ""));
        }
        plugin.setDetail(JSONArray.toJSONString(metaPlugin.getFieldMapping()));
        this.imgMetaPluginDao.updateByPrimaryKey(plugin);
        return plugin.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer deleteMetaPlugin(String id) {
        return this.imgMetaPluginDao.deleteByPrimaryKey(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String copyMetaPlugin(String sourceId, String targetId) {
        ImgMetaPlugin sourcePlugin = this.imgMetaPluginDao.selectByPrimaryKey(sourceId);
        if (sourcePlugin == null) {
            throw new RuntimeException("\u5f85\u590d\u5236\u5143\u6570\u636e\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        ImgMetaPlugin targetPlugin = this.imgMetaPluginDao.selectByPrimaryKey(targetId);
        if (targetPlugin == null) {
            throw new RuntimeException("\u88ab\u7c98\u8d34\u5143\u6570\u636e\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        sourcePlugin.setId(targetId);
        sourcePlugin.setName(targetPlugin.getName());
        this.imgMetaPluginDao.updateByPrimaryKey(sourcePlugin);
        return targetId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String importMetaPlugin(MultipartFile file) {
        if (file == null || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(".json")) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        InputStreamReader streamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuffer = new StringBuilder();
        JSONObject jsonObject = null;
        try {
            streamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(streamReader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
            }
            bufferedReader.close();
            streamReader.close();
            jsonObject = JSONObject.parseObject((String)stringBuffer.toString());
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
        ImgMetaPlugin plugin = (ImgMetaPlugin)JSONObject.parseObject((String)jsonObject.toJSONString(), ImgMetaPlugin.class);
        plugin.setId(UUID.randomUUID().toString().replace("-", ""));
        this.imgMetaPluginDao.insert(plugin);
        return plugin.getId();
    }

    @Override
    public void exportMetaPlugin(String id) {
        ImgMetaPlugin plugin = this.imgMetaPluginDao.selectByPrimaryKey(id);
        if (plugin != null) {
            String name = plugin.getName();
            name = name.replaceAll("\\s*", "");
            name = name.replaceAll("[<>:\"/\\\\|?*]", "");
            DownloadUtil.downloadToFile((String)(name + ".json"), (String)JSONObject.toJSONString((Object)plugin));
        }
        DownloadUtil.downloadToFile((String)"\u5143\u6570\u636e\u63d2\u4ef6\u4e0d\u5b58\u5728.json", (String)"");
    }

    @Override
    public List<MetaFieldMappingCheckDTO> checkMetaPlugin(String id, String metaFilePath) {
        ImageMetaPluginDTO metaPlugin = this.getDetail(id);
        IImageMetaDataPlugin imageMetaDataPlugin = null;
        try {
            imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(metaPlugin);
        }
        catch (Exception e) {
            log.error("\u5143\u6570\u636e\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5143\u6570\u636e\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01" + e.getMessage());
        }
        ArrayList<MetaFieldMappingCheckDTO> checkList = new ArrayList<MetaFieldMappingCheckDTO>();
        DmFileData fileData = new DmFileData();
        ArrayList<FileDataUnit> files = new ArrayList<FileDataUnit>();
        FileDataUnit metaFile = new FileDataUnit();
        metaFile.setFileSourceLocation(metaFilePath);
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("CKMetaFile");
        metaFile.setProperties(properties);
        files.add(metaFile);
        fileData.setFiles(files);
        IFileStorage fileStorage = this.fileStorageService.openFileStorageByFilePath(metaFilePath);
        Map<String, Object> metaData = imageMetaDataPlugin.readMetaData(fileData, fileStorage);
        for (MetaFieldMappingDTO mapping : metaPlugin.getFieldMapping()) {
            MetaFieldMappingCheckDTO checkDTO = new MetaFieldMappingCheckDTO();
            checkDTO.setId(mapping.getId());
            checkDTO.setSourceField(mapping.getSourceField());
            checkDTO.setTargetField(mapping.getTargetField());
            checkDTO.setDefaultValue(mapping.getDefaultValue());
            checkDTO.setCheckResult("");
            if (metaData.containsKey(mapping.getTargetField())) {
                checkDTO.setCheckResult(metaData.get(mapping.getTargetField()) == null ? "" : metaData.get(mapping.getTargetField()) + "");
            }
            checkList.add(checkDTO);
        }
        return checkList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ImageMetaPluginDTO importMetaPluginMapping(String id, MultipartFile mappingFile) {
        ImgMetaPlugin plugin = this.imgMetaPluginDao.selectByPrimaryKey(id);
        if (plugin == null) {
            throw new RuntimeException("\u5143\u6570\u636e\u63d2\u4ef6\u4e0d\u5b58\u5728");
        }
        List lines = FileReadUtil.readFileLines((MultipartFile)mappingFile);
        List<MetaFieldMappingDTO> fieldMapping = new ArrayList();
        if (StringUtil.isNotEmpty((String)plugin.getDetail())) {
            fieldMapping = JSONArray.parseArray((String)plugin.getDetail(), MetaFieldMappingDTO.class);
        }
        for (String line : lines) {
            String[] array;
            if (StringUtil.isEmptyOrWhiteSpace((String)line.trim()) || (array = line.split(" ", 3)).length < 2) continue;
            MetaFieldMappingDTO mappingDTO = new MetaFieldMappingDTO();
            mappingDTO.setId(UUID.randomUUID().toString().replace("-", ""));
            mappingDTO.setSourceField(array[0]);
            mappingDTO.setTargetField(array[1]);
            if (array.length == 3) {
                mappingDTO.setDefaultValue(array[2]);
            }
            fieldMapping.add(mappingDTO);
        }
        plugin.setDetail(JSONArray.toJSONString(fieldMapping));
        this.imgMetaPluginDao.updateByPrimaryKey(plugin);
        return this.getDetail(id);
    }

    private ImageMetaPluginDTO convert(ImgMetaPlugin plugin) {
        ImageMetaPluginDTO dto = new ImageMetaPluginDTO();
        dto.setId(plugin.getId());
        dto.setName(plugin.getName());
        dto.setDesc(plugin.getDesc());
        dto.setPluginAssembly(plugin.getAssembly());
        dto.setPluginClassname(plugin.getClassname());
        if (StringUtil.isEmptyOrWhiteSpace((String)plugin.getDetail())) {
            dto.setFieldMapping(new ArrayList<MetaFieldMappingDTO>());
        } else {
            List fieldMapping = JSONArray.parseArray((String)plugin.getDetail(), MetaFieldMappingDTO.class);
            dto.setFieldMapping(fieldMapping);
        }
        try {
            Class<?> aClass = Class.forName(plugin.getClassname());
            IImageMetaDataPlugin imageMetaDataPlugin = (IImageMetaDataPlugin)aClass.newInstance();
            dto.setPluginName(imageMetaDataPlugin.getName());
        }
        catch (Exception e) {
            log.error("\u5143\u6570\u636e\u63d2\u4ef6\u7c7b\u521d\u59cb\u5316\u5931\u8d25\uff01", (Throwable)e);
            dto.setPluginClassname(plugin.getClassname());
        }
        return dto;
    }
}

