/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.listener;

import com.geoway.imagedb.input.component.ImageImportScheduleTask;
import com.geoway.imagedb.input.plugin.ImageDatasetScheduleImportPlugin;
import com.geoway.webstore.input.constant.TaskStatusEnum;
import com.geoway.webstore.input.dao.ImpTaskDao;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.entity.ImpTask;
import com.geoway.webstore.input.event.ImportTaskFinishedEvent;
import com.geoway.webstore.input.service.ImpTaskService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ImportTaskFinishedEventListener
implements ApplicationListener<ImportTaskFinishedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskFinishedEventListener.class);
    @Resource
    private ImageImportScheduleTask imageImportScheduleTask;
    @Resource
    private ImpTaskService impTaskService;
    @Resource
    private ImpTaskDao taskDao;

    public void onApplicationEvent(ImportTaskFinishedEvent event) {
        ImpTask impTask;
        ImpSchemaDTO impSchema = event.getImpSchema();
        if (impSchema != null && impSchema.getPlugin().getClassName().equals(ImageDatasetScheduleImportPlugin.class.getName()) && this.imageImportScheduleTask.hasScheduleTask((impTask = event.getImpTask()).getId()).booleanValue()) {
            impTask.setStatus(Integer.valueOf(TaskStatusEnum.Processing.getValue()));
            this.taskDao.updateStatus(impTask);
            this.impTaskService.disableCache();
        }
    }
}

