/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.filepackage.create.FileDataCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.ScanFileResultParam;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.directory.DirectoryFileStorage;
import com.geoway.imagedb.input.dao.ImgAutoScanDatumDao;
import com.geoway.imagedb.input.dto.meta.ImageMetaPluginDTO;
import com.geoway.imagedb.input.entity.ImgAutoScanDatum;
import com.geoway.imagedb.input.plugin.ImageDatasetImportPlugin;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetSettingParams;
import com.geoway.imagedb.input.plugin.ImageGeoDatasetTargetParams;
import com.geoway.imagedb.input.plugin.meta.MetaPluginInfo;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import com.geoway.webstore.input.dto.ImpTaskCreateDTO;
import com.geoway.webstore.input.plugin.data.IImportData;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.data.ImportDatum;
import com.geoway.webstore.input.plugin.data.ImportUnit;
import com.geoway.webstore.input.plugin.event.ImportScanUnitEventArgs;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.model.ExecuteResultDetail;
import com.geoway.webstore.input.plugin.params.ImportSourceParams;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ImageDatasetScheduleImportPlugin
extends ImageDatasetImportPlugin {
    protected ImgAutoScanDatumDao imgAutoScanDatumDao = (ImgAutoScanDatumDao)SpringContextUtil.getBean(ImgAutoScanDatumDao.class);
    protected IFileset autoImportDir;
    protected DataSourceDTO targetFileStorage = null;
    protected IFileStorage uploadFileStorage;
    protected ImpTaskCreateDTO createDTO;

    @Override
    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        this.allowEmptyTask = true;
        this.sourceParams = (ImportSourceParams)JSONObject.parseObject((String)sourceParamsStr, ImportSourceParams.class);
        this.deleteRepeatedData = DataDuplicateStrategyEnum.getByValue((Integer)this.sourceParams.getDataDuplicateStrategy()) == DataDuplicateStrategyEnum.Delete;
        this.settingParams = (ImageGeoDatasetSettingParams)JSONObject.parseObject((String)settingParamsStr, ImageGeoDatasetSettingParams.class);
        this.targetParams = (ImageGeoDatasetTargetParams)JSONObject.parseObject((String)targetParamsStr, ImageGeoDatasetTargetParams.class);
        this.autoImportDir = this.getImageDataAutoImportPath();
        if (StringUtil.isEmptyOrWhiteSpace((String)this.settingParams.sourceFolderPath)) {
            this.settingParams.sourceFolderPath = this.autoImportDir.getFullPath();
        }
        this.dataPackage = this.fileModelService.getDataPackage(this.targetParams.fileModelId);
        this.targetFileStorage = this.dataSourceManager.getDataSourceDetail(this.settingParams.serviceId);
        if (this.targetFileStorage == null) {
            throw new RuntimeException("\u83b7\u53d6\u5b58\u50a8\u8282\u70b9\u5931\u8d25\uff01");
        }
        if (Boolean.TRUE.equals(this.settingParams.isUpload) && StringUtil.isNotEmpty((String)this.settingParams.uploadDir) && !this.settingParams.uploadDir.contains(this.targetFileStorage.getUrl())) {
            throw new RuntimeException("\u6570\u636e\u4f4d\u7f6e\u4e0e\u5b58\u50a8\u8282\u70b9\u4e0d\u5339\u914d\uff01");
        }
        this.uploadFileStorage = this.fileStorageService.openFileStorage(this.targetFileStorage.getKey());
        this.dataPath = this.settingParams.sourceFolderPath;
        if (StringUtil.isEmptyOrWhiteSpace((String)this.targetParams.metaPluginInfo)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5143\u6570\u636e\u89e3\u6790\u63d2\u4ef6");
        }
        try {
            MetaPluginInfo pluginInfo = this.targetParams.getImageMetaPluginInfo();
            if (StringUtil.isEmptyOrWhiteSpace((String)pluginInfo.getPluginClassName())) {
                ImageMetaPluginDTO metaPluginDTO = this.imageMetaPluginService.getDetail(pluginInfo.getConfigFile());
                this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(metaPluginDTO);
            } else {
                this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(this.targetParams.getImageMetaPluginInfo());
            }
        }
        catch (Exception e) {
            this.log.error("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01", (Throwable)e);
            throw new RuntimeException("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01");
        }
    }

    @Override
    public void scanData() {
        this.imageDataset = this.datumDatabaseService.getDatasetDetail(this.targetParams.datasetId);
        if (this.imageDataset == null) {
            throw new RuntimeException("\u6253\u5f00\u76ee\u6807\u6570\u636e\u96c6\u5931\u8d25\uff01");
        }
        if (this.dataPackage.getDataKeyObject().getNodeType().intValue() == FileModelNodeTypeEnum.CompactPackage.getValue()) {
            this.dataPackage.setUncompress(false);
            this.hasCompact = true;
        }
        try {
            IFileset dataFile = this.scanFileStorage.getFile(this.dataPath);
            ScanResultDTO scanResultDTO = this.dataPackage.scanFile(dataFile, Boolean.valueOf(false));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        ImportUnit importUnit = new ImportUnit();
        importUnit.setName(FileUtil.getFileNameWithoutExtension((String)this.dataPath));
        importUnit.setCode(FileUtil.getFileNameWithoutExtension((String)this.dataPath));
        importUnit.setPath(this.dataPath);
        ArrayList<ImportDatum> importDataList = new ArrayList<ImportDatum>();
        List scanFileResultParams = this.dataPackage.getScanFileResultParams();
        for (ScanFileResultParam resultItem : scanFileResultParams) {
            if (!this.hasCompact && !resultItem.getScanResult().booleanValue()) {
                this.log.error(String.format("\u6570\u636e\u5305[%s]\u6709\u6548\u6027\u68c0\u67e5\u672a\u901a\u8fc7\u3002", resultItem.getMainFilePath()));
                continue;
            }
            DmFileData fileData = resultItem.getData();
            if (importDataList.stream().anyMatch(c -> c.getName().equals(fileData.getDataName()))) {
                this.log.error(String.format("\u6307\u5b9a\u6570\u636e\u76ee\u5f55\u4e0b\u6570\u636e\u5305[%s]\u5b58\u5728\u91cd\u590d\u3002", fileData.getDataName()));
                continue;
            }
            ImportDatum importDatum = new ImportDatum();
            importDatum.setName(fileData.getDataName());
            importDatum.setPath(resultItem.getMainFilePath());
            importDatum.setDatasetName(this.imageDataset.getName());
            importDatum.setFileData(JSONObject.toJSONString((Object)fileData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            importDataList.add(importDatum);
        }
        if (importDataList.size() == 0) {
            return;
        }
        ImportScanUnitEventArgs args = new ImportScanUnitEventArgs((Object)this, (IImportUnit)importUnit, importDataList);
        this.onDataUnitScaned(args);
    }

    protected void onDataUnitScaned(ImportScanUnitEventArgs eventArgs) {
        ArrayList dataList = new ArrayList(eventArgs.getImportDataList());
        int count = eventArgs.getImportDataList().size();
        for (IImportData importData : dataList) {
            ImgAutoScanDatum imgAutoScanDatum;
            ImportDatum importDatum = (ImportDatum)importData;
            if (importDatum == null) continue;
            DmFileData fileData = (DmFileData)JSONObject.parseObject((String)importDatum.getFileData(), DmFileData.class);
            FileDataUnit mainFile = (FileDataUnit)ListUtil.find((List)fileData.getFiles(), FileDataUnit::isMainFile);
            String dataPath = importDatum.getPath();
            if (mainFile != null) {
                dataPath = mainFile.getFileSourceLocation();
            }
            if ((imgAutoScanDatum = this.imgAutoScanDatumDao.selectByPrimaryKey(dataPath = dataPath.replace("\\", "/"))) == null) {
                imgAutoScanDatum = new ImgAutoScanDatum();
                imgAutoScanDatum.setDataPath(dataPath);
                imgAutoScanDatum.setDatasetId(this.targetParams.datasetId);
                imgAutoScanDatum.setServerId(this.settingParams.serviceId);
                imgAutoScanDatum.setCheckTime(new Date());
                imgAutoScanDatum.setCheckState(ConstantsValue.FALSE_VALUE);
                imgAutoScanDatum.setDataName(fileData.getDataName());
                this.imgAutoScanDatumDao.insert(imgAutoScanDatum);
                continue;
            }
            eventArgs.getImportDataList().remove(importData);
        }
        if (eventArgs.getImportDataList().size() == 0) {
            this.log.error("\u5171" + count + "\u4efd\u6570\u636e,\u5747\u5df2\u88ab\u626b\u63cf\uff01");
            return;
        }
        eventArgs.getImportUnit().setName("\u81ea\u52a8\u5f52\u6863_-" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd HH:mm:ss"));
        super.onDataUnitScaned(eventArgs);
    }

    @Override
    protected boolean uploadFileData() {
        try {
            FileDataUnit mainFile = (FileDataUnit)ListUtil.find((List)this.currentFileData.getFiles(), FileDataUnit::isMainFile);
            if (mainFile != null) {
                String dataPath = mainFile.getFileSourceLocation();
                ImgAutoScanDatum imgAutoScanDatum = this.imgAutoScanDatumDao.selectByPrimaryKey(dataPath = dataPath.replace("\\", "/"));
                if (imgAutoScanDatum != null) {
                    imgAutoScanDatum.setDataId(this.currentDataId);
                    imgAutoScanDatum.setCheckState(ConstantsValue.TRUE_VALUE);
                    this.imgAutoScanDatumDao.updateByPrimaryKey(imgAutoScanDatum);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u81ea\u52a8\u5f52\u6863\u626b\u63cf\u8def\u5f84\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25\uff01", (Throwable)e);
        }
        if (Boolean.TRUE.equals(this.settingParams.isUpload)) {
            String uploadDir = this.settingParams.uploadDir;
            if (StringUtil.isEmptyOrWhiteSpace((String)uploadDir)) {
                uploadDir = this.targetFileStorage.getUrl();
            }
            List files = this.currentFileData.getFiles();
            String mainPathDir = this.currentFileData.getSrcMainPath();
            for (FileDataUnit dataUnit : files) {
                if (dataUnit.getFileSourceLocation().replace("\\", "/").startsWith(UploadPathConfig.getUploadPath().toString().replace("\\", "/"))) continue;
                IFileset srcFileset = this.scanFileStorage.getFile(dataUnit.getFileSourceLocation());
                if (srcFileset == null) {
                    this.onImportDataLog(String.format("\u6587\u4ef6[%s]\u4e0d\u5b58\u5728\u3002", dataUnit.getFileSourceLocation()));
                    continue;
                }
                String targetPath = this.uploadFileStorage.combinePaths(uploadDir, new String[]{dataUnit.getFileSourceLocation().substring(mainPathDir.length())});
                if (srcFileset.getIsDirectory()) {
                    this.uploadFileStorage.createDirectory(targetPath, "");
                    continue;
                }
                this.uploadFileStorage.upload(srcFileset.openFileStream(), targetPath, true);
            }
            return true;
        }
        return true;
    }

    @Override
    protected String insertFileData(DmFileData fileData) {
        String uploadDir = this.settingParams.uploadDir;
        if (StringUtil.isEmptyOrWhiteSpace((String)uploadDir)) {
            uploadDir = this.targetFileStorage.getUrl();
        }
        String mainPathDir = fileData.getSrcMainPath();
        FileDataCreateDTO createDTO = new FileDataCreateDTO();
        createDTO.setDataName(fileData.getDataName());
        createDTO.setDatatype(fileData.getDatatype());
        createDTO.setDatumDatasetId(this.imageDataset.getId());
        createDTO.setServerId(this.targetFileStorage.getKey());
        createDTO.setRegisterUser(this.sourceParams.getImportUser());
        createDTO.setDataAmount(fileData.getDataAmount());
        createDTO.setFileModelId(this.dataPackage.getId());
        createDTO.setRealPkgName(fileData.getRealPkgName());
        if (Boolean.TRUE.equals(this.settingParams.isUpload)) {
            createDTO.setMainPath(this.getUploadFilePrePath(fileData, uploadDir, mainPathDir).replace("\\", "/"));
        } else {
            createDTO.setMainPath(this.getFilePrePath(fileData).replace("\\", "/"));
        }
        createDTO.setIsOnServer(Boolean.valueOf(true));
        createDTO.setSrcMainPath(fileData.getSrcMainPath().replace("\\", "/"));
        for (FileDataUnit unit : fileData.getFiles()) {
            String fileLocation;
            String serviceAddress = this.targetFileStorage.getUrl();
            if (Boolean.TRUE.equals(this.settingParams.isUpload)) {
                fileLocation = Paths.get(uploadDir, unit.getFileSourceLocation().substring(mainPathDir.length())).toString();
                fileLocation = fileLocation.substring(serviceAddress.length());
                unit.setServerId(this.targetFileStorage.getKey());
            } else {
                fileLocation = unit.getFileLocation().substring(serviceAddress.length());
            }
            unit.setFileLocation(fileLocation);
        }
        createDTO.setFiles(fileData.getFiles());
        String dataId = this.fileDataService.addFileData(createDTO);
        return dataId;
    }

    protected String getUploadFilePrePath(DmFileData catalogData, String uploadDir, String mainPathDir) {
        String serviceAddress = this.targetFileStorage.getUrl();
        String storagePath = Paths.get(uploadDir, catalogData.getSrcMainPath().substring(mainPathDir.length())).toString();
        storagePath = storagePath.substring(serviceAddress.length());
        if (catalogData.getContainsRootFolder() != null && catalogData.getContainsRootFolder().equals(ConstantsValue.TRUE_VALUE.longValue())) {
            if (storagePath.endsWith(File.separator)) {
                storagePath = storagePath.substring(0, storagePath.length() - 1);
            }
            storagePath = FileUtil.getDirectoryName((String)storagePath);
        }
        return storagePath;
    }

    @Override
    protected String getFilePrePath(DmFileData catalogData) {
        if (Boolean.TRUE.equals(this.settingParams.isUpload)) {
            String uploadDir = this.settingParams.uploadDir;
            if (StringUtil.isEmptyOrWhiteSpace((String)uploadDir)) {
                uploadDir = this.targetFileStorage.getUrl();
            }
            String mainPathDir = catalogData.getSrcMainPath();
            return this.getUploadFilePrePath(catalogData, uploadDir, mainPathDir);
        }
        return super.getFilePrePath(catalogData);
    }

    @Override
    public ExecuteResultDetail executeImport(IImportData importData) {
        try {
            ExecuteResultDetail resultDetail = super.executeImport(importData);
            if (!resultDetail.getSuccess().booleanValue()) {
                this.copyToFailedCopyDir(importData);
            }
            return resultDetail;
        }
        catch (Exception e) {
            this.copyToFailedCopyDir(importData);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void importFinised(IImportUnit importUnit) {
        super.importFinised();
    }

    @Override
    public void importFinised() {
        this.log.info("\u5165\u5e93\u7ed3\u675f\u3002");
    }

    private void copyToFailedCopyDir(IImportData importData) {
        ImportDatum importDatum = ImportDatum.getImportData((Long)importData.getId());
        if (importDatum == null || importDatum.getFileData() == null) {
            return;
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)this.settingParams.failedCopyDir)) {
            this.onImportDataLog("\u672a\u8bbe\u7f6e\u5931\u8d25\u6570\u636e\u5b58\u50a8\u4f4d\u7f6e\uff0c\u4e0d\u62f7\u8d1d\u5931\u8d25\u6570\u636e\uff01");
            return;
        }
        IFileStorage failedFileStorage = this.fileStorageService.openFileStorageByFilePath(this.settingParams.failedCopyDir);
        IFileset uploadDir = failedFileStorage.getFile(this.settingParams.failedCopyDir);
        if (uploadDir == null) {
            failedFileStorage.createDirectory(this.settingParams.failedCopyDir, "");
        }
        DmFileData fileData = (DmFileData)JSONObject.parseObject((String)importDatum.getFileData(), DmFileData.class);
        String mainPathDir = fileData.getSrcMainPath();
        for (FileDataUnit unit : fileData.getFiles()) {
            IFileset srcFileset = this.scanFileStorage.getFile(unit.getFileSourceLocation());
            if (srcFileset == null) {
                this.onImportDataLog(String.format("\u6e90\u6587\u4ef6%s\u4e0d\u5b58\u5728\uff01", unit.getFileSourceLocation()));
                continue;
            }
            String targetPath = failedFileStorage.combinePaths(this.settingParams.failedCopyDir, new String[]{unit.getFileSourceLocation().substring(mainPathDir.length())});
            if (srcFileset.getIsDirectory()) {
                failedFileStorage.createDirectory(targetPath, "");
            }
            failedFileStorage.upload(srcFileset.openFileStream(), targetPath, true);
        }
    }

    private IFileset getImageDataAutoImportPath() {
        if (StringUtil.isNotEmpty((String)this.targetParams.srcServiceId)) {
            if (!Boolean.TRUE.equals(this.settingParams.isUpload)) {
                this.settingParams.serviceId = this.targetParams.srcServiceId;
            }
            this.fileStorage = this.dataSourceManager.getDataSourceDetail(this.targetParams.srcServiceId);
            if (this.fileStorage == null) {
                throw new RuntimeException("\u83b7\u53d6\u5b58\u50a8\u8282\u70b9\u5931\u8d25\uff01");
            }
            this.scanFileStorage = this.fileStorageService.openFileStorage(this.fileStorage.getKey());
            return this.scanFileStorage.getFile(this.fileStorage.getUrl());
        }
        Path autoImportPath = Paths.get(EnvironmentConfig.getProperty((String)"project.image-data-auto-import-path", (String)"image_auto_import"), new String[0]);
        try {
            File file = autoImportPath.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            this.log.error("\u81ea\u52a8\u626b\u63cf\u5165\u5e93\u76ee\u5f55\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        DirectoryFileStorage directoryFileStorage = new DirectoryFileStorage(autoImportPath.toString(), "", "");
        return directoryFileStorage.getFile(autoImportPath.toString());
    }
}

