/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.service.impl;

import cn.hutool.core.io.resource.ResourceUtil;
import com.geoway.imagedb.input.plugin.meta.MetaPluginInfo;
import com.geoway.imagedb.input.service.ImageMetaDataPluginService;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Service
public class ImageMetaDataPluginServiceImpl
implements ImageMetaDataPluginService {
    private static final Logger log = LoggerFactory.getLogger(ImageMetaDataPluginServiceImpl.class);

    @Override
    public List<MetaPluginInfo> list() {
        ArrayList<MetaPluginInfo> list = new ArrayList<MetaPluginInfo>();
        try {
            URL resource;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            File pluginFile = new File("image/meta/plugin-config.xml");
            if (pluginFile.exists() && pluginFile.isFile()) {
                log.info("\u8bfb\u53d6\u5143\u6570\u636e\u63d2\u4ef6\u914d\u7f6e\u6587\u4ef6\uff1a" + pluginFile.getAbsolutePath());
                resource = pluginFile.toURI().toURL();
            } else {
                resource = ResourceUtil.getResource((String)"image/meta/plugin-config.xml");
                if (resource == null) {
                    log.error("\u8bfb\u53d6\u5143\u6570\u636e\u63d2\u4ef6\u914d\u7f6e\u6587\u4ef6\uff1aplugin-config.xml\u4e0d\u5b58\u5728");
                    return list;
                }
                log.info("\u8bfb\u53d6\u5143\u6570\u636e\u63d2\u4ef6\u914d\u7f6e\u6587\u4ef6\uff1a" + resource.getPath());
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(resource.openStream());
            Element confXml = (Element)document.getElementsByTagName("root").item(0);
            NodeList nodeList = confXml.getElementsByTagName("PluginInfo");
            int count = nodeList.getLength();
            for (int i = 0; i < count; ++i) {
                Element metaPlugin = (Element)nodeList.item(i);
                String name = metaPlugin.getAttribute("Name");
                String className = metaPlugin.getAttribute("ClassName");
                String configFile = metaPlugin.getAttribute("ConfigFile");
                MetaPluginInfo pluginInfo = new MetaPluginInfo();
                pluginInfo.setName(name);
                pluginInfo.setPluginClassName(className);
                pluginInfo.setConfigFile(configFile);
                list.add(pluginInfo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("plugin-config.xml\u89e3\u6790\u5931\u8d25:" + e.getMessage(), e);
        }
        return list;
    }
}

