/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.dms.config.filemodel.util.ArchivePackagePath;
import com.geoway.adf.dms.datasource.dto.datum.DatumFieldDTO;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.imagedb.dataset.util.ImageDateUtil;
import com.geoway.imagedb.input.dto.meta.ImageMetaPluginDTO;
import com.geoway.imagedb.input.plugin.ImageDatasetImportPluginBase;
import com.geoway.imagedb.input.plugin.meta.CommonMetaDataPlugin;
import com.geoway.imagedb.input.plugin.meta.IImageMetaDataPlugin;
import com.geoway.imagedb.input.plugin.meta.MetaPluginInfo;
import com.geoway.imagedb.input.plugin.meta.MetaPluginManager;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.TranslateOptions;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;

public class ImageMosaicDatasetImportPlugin
extends ImageDatasetImportPluginBase {
    protected IImageMetaDataPlugin imageMetaDataPlugin;
    protected String imageDataFile;

    @Override
    public void initialize(String sourceParamsStr, String targetParamsStr, String settingParamsStr) {
        super.initialize(sourceParamsStr, targetParamsStr, settingParamsStr);
        if (StringUtil.isNotEmpty((String)this.targetParams.metaPluginInfo)) {
            try {
                MetaPluginInfo pluginInfo = this.targetParams.getImageMetaPluginInfo();
                if (StringUtil.isEmptyOrWhiteSpace((String)pluginInfo.getPluginClassName())) {
                    ImageMetaPluginDTO metaPluginDTO = this.imageMetaPluginService.getDetail(pluginInfo.getConfigFile());
                    this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(metaPluginDTO);
                } else {
                    this.imageMetaDataPlugin = MetaPluginManager.createImageMetaDataPlugin(this.targetParams.getImageMetaPluginInfo());
                }
                if (StringUtil.isNotEmpty((String)this.settingParams.time)) {
                    // empty if block
                }
                if (StringUtil.isNotEmpty((String)this.settingParams.imageClassify)) {
                    String string = this.settingParams.imageClassify.replace("/", "_");
                }
            }
            catch (Exception e) {
                this.log.error("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01", (Throwable)e);
                throw new RuntimeException("\u5143\u6570\u636e\u5165\u5e93\u63d2\u4ef6\u521d\u59cb\u5316\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    protected Map<String, Object> getMetaData(DmFileData fileData) {
        List lstFile = fileData.getFiles();
        FileDataUnit sRasterFileData = (FileDataUnit)ListUtil.find((List)lstFile, f -> f.getProperties() != null && f.getProperties().contains("RasterFile"));
        if (sRasterFileData == null) {
            throw new RuntimeException("\u672a\u6307\u5b9a\u5f71\u50cf\u6570\u636e\u6587\u4ef6\uff01");
        }
        this.imageDataFile = sRasterFileData.getFileSourceLocation();
        HashMap<String, Object> contents = new HashMap<String, Object>(0);
        Map<String, Object> metaData = new HashMap<String, Object>(0);
        if (this.imageMetaDataPlugin != null) {
            metaData = this.imageMetaDataPlugin.readMetaData(fileData, this.scanFileStorage);
        }
        HashMap<String, String> meta = new HashMap<String, String>(0);
        metaData.forEach((key, value) -> meta.put((String)key, value == null ? "" : value.toString()));
        this.setExternalMetaValue(meta);
        List fieldList = this.imageDataset.getFields();
        block3: for (String key2 : meta.keySet()) {
            String matchKey = key2.replace(" ", "");
            String matchValue = meta.get(key2) == null ? null : (String)meta.get(key2);
            for (DatumFieldDTO field : fieldList) {
                if (!matchKey.equalsIgnoreCase(field.getName()) && !matchKey.equalsIgnoreCase(field.getAliasName())) continue;
                FieldType type = FieldType.getByValue((Integer)field.getFieldType());
                Object value2 = null;
                if (!StringUtil.isEmptyOrWhiteSpace((String)matchValue)) {
                    switch (type) {
                        case DateTime: {
                            value2 = ImageDateUtil.parse((String)matchValue);
                            break;
                        }
                        default: {
                            value2 = matchValue;
                        }
                    }
                }
                contents.put(field.getName(), value2);
                continue block3;
            }
        }
        return contents;
    }

    @Override
    protected String getSnapshotFile(DmFileData fileData) {
        String snapshotFile;
        Integer targetSrid = null;
        if (this.targetGeoDataset instanceof IFeatureClass) {
            targetSrid = ((IFeatureClass)this.targetGeoDataset).getSpatialReferenceSystem().getSrid();
        } else if (this.targetGeoDataset instanceof IMosaicDataset) {
            targetSrid = ((IMosaicDataset)this.targetGeoDataset).getSpatialReferenceSystem().getSrid();
        }
        if (this.imageMetaDataPlugin != null) {
            snapshotFile = this.imageMetaDataPlugin.createSnapshotFile(fileData, this.scanFileStorage, true, targetSrid);
        } else {
            CommonMetaDataPlugin commonMetaDataPlugin = new CommonMetaDataPlugin();
            commonMetaDataPlugin.setConfigFile(null);
            snapshotFile = commonMetaDataPlugin.createSnapshotFile(fileData, this.scanFileStorage, true, targetSrid);
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)snapshotFile) || !FileUtil.isFileExsit((String)snapshotFile).booleanValue()) {
            this.onImportDataLog("\u5feb\u89c6\u56fe\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return null;
        }
        return snapshotFile;
    }

    @Override
    protected IRasterDataset getRasterDataset(DmFileData fileData) {
        if (this.imageDataFile.replace("\\", "/").startsWith(ArchivePackagePath.getVirtualFolder((DataPackage)this.dataPackage).replace("\\", "/"))) {
            String fileName = FileUtil.getFileNameWithoutExtension((String)this.imageDataFile);
            File file = new File(FileUtil.getDirectoryName((String)this.imageDataFile));
            File[] subFiles = file.listFiles();
            if (subFiles == null || subFiles.length == 0) {
                return this.openRasterDataset(this.imageDataFile);
            }
            String guid = UUID.randomUUID().toString().replace("-", "");
            String snapshotDir = MetaPluginManager.getSnapshotUnZipDir().toString();
            String tifTempDir = Paths.get(snapshotDir, guid).toString();
            FileUtil.mkdirs((String)tifTempDir);
            File srcSnapshotFile = new File(this.imageDataFile);
            File targetSnapshotFile = new File(tifTempDir, srcSnapshotFile.getName());
            this.imageDataFile = targetSnapshotFile.getAbsolutePath();
            for (File subFile : subFiles) {
                String subFilePath = subFile.getAbsolutePath();
                if (!FileUtil.getFileNameWithoutExtension((String)subFilePath).equals(fileName)) continue;
                FileUtil.copyFile((String)subFile.getAbsolutePath(), (String)Paths.get(tifTempDir, subFile.getName()).toString());
            }
        }
        return this.openRasterDataset(this.imageDataFile);
    }

    @Override
    protected Map<String, Object> getBusinessValues(Map<String, Object> meta) {
        Map<String, Object> values = super.getBusinessValues(meta);
        values.put("f_classification", meta.get("f_classification"));
        values.put("f_satellite", values.get("f_classification") == null ? "" : values.get("f_classification").toString());
        values.put("f_sensor", meta.get("f_sensor"));
        values.put("f_resolution", meta.get("f_resolution"));
        values.put("f_time", meta.get("f_time"));
        values.put("f_product_time", meta.get("f_time"));
        values.put("f_cloud", null);
        return values;
    }

    @Override
    protected void insertRaster(IMosaicDataset mosaicDataset, IRasterDataset sourceRasterDataset, Map<String, Object> metaRow, IGeometry extentGeometry, Boolean overwrite) {
        if (!metaRow.containsKey("f_resolution") && !metaRow.containsKey("\u5206\u8fa8\u7387")) {
            try {
                double lowps = sourceRasterDataset.getRasterInfo().getXResolution();
                if (sourceRasterDataset.getRasterInfo().getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Geographic) {
                    lowps = 111319.49079327358 * lowps;
                }
                metaRow.put("f_resolution", lowps);
            }
            catch (Exception e) {
                this.log.error("\u83b7\u53d6\u5206\u8fa8\u7387\u5931\u8d25\uff01", (Throwable)e);
                throw new RuntimeException("\u83b7\u53d6\u5206\u8fa8\u7387\u5931\u8d25\uff01" + e.getMessage());
            }
        }
        super.insertRaster(mosaicDataset, sourceRasterDataset, metaRow, extentGeometry, overwrite);
    }

    @Override
    protected void addThumb(String dataId) {
        if (this.snapshotFile.toLowerCase(Locale.ROOT).endsWith(".jpg") || this.snapshotFile.toLowerCase(Locale.ROOT).endsWith(".png")) {
            this.addThumbByImageIO(this.snapshotFile, dataId);
            return;
        }
        String guid = UUID.randomUUID().toString().replace("-", "");
        String snapshotDir = MetaPluginManager.getSnapshotUnZipDir().toString();
        String targetTempPath = Paths.get(snapshotDir, guid + ".png").toString();
        try {
            TranslateOptions options;
            Dataset thumbDataset;
            Dataset dataset = gdal.Open((String)this.snapshotFile, (int)gdalconstConstants.GA_ReadOnly);
            if (dataset == null) {
                throw new RuntimeException("\u6805\u683c\u8bfb\u53d6\u5931\u8d25\uff01");
            }
            int xSize = dataset.getRasterXSize();
            if (xSize > 256) {
                xSize = 256;
            }
            Vector vector = gdal.ParseCommandLine((String)String.format("-of PNG -outsize %d %d -ot Byte -scale", xSize, 0));
            if (dataset.GetRasterCount() >= 4) {
                vector = gdal.ParseCommandLine((String)String.format("-of PNG -outsize %d %d -ot Byte -b 1 -b 2 -b 3 -scale", xSize, 0));
            }
            if ((thumbDataset = gdal.Translate((String)targetTempPath, (Dataset)dataset, (TranslateOptions)(options = new TranslateOptions(vector)))) != null) {
                thumbDataset.delete();
            }
            dataset.delete();
            this.addThumbByImageIO(targetTempPath, dataId);
            boolean s = Paths.get(snapshotDir, guid + ".png").toFile().delete();
            File tempFileAux = new File(targetTempPath + ".aux.xml");
            tempFileAux.delete();
        }
        catch (Exception e) {
            this.log.error(dataId + "\u62c7\u6307\u56fe\u91c7\u96c6\u5931\u8d25\uff01");
            this.onImportDataLog(dataId + "\u62c7\u6307\u56fe\u91c7\u96c6\u5931\u8d25\uff01");
        }
    }

    protected void setExternalMetaValue(Map<String, String> meta) {
        if (!meta.containsKey("f_classification")) {
            if (meta.containsKey("\u5f71\u50cf\u5206\u7c7b")) {
                meta.put("f_classification", meta.get("\u5f71\u50cf\u5206\u7c7b"));
            } else {
                if (StringUtil.isEmptyOrWhiteSpace((String)this.settingParams.imageClassify)) {
                    throw new RuntimeException("\u672a\u8bbe\u7f6e\u5f71\u50cf\u5206\u7c7b\uff01");
                }
                String imageClassify = this.settingParams.imageClassify.replace("/", "_");
                meta.put("f_classification", imageClassify);
            }
        }
        if (!meta.containsKey("f_time")) {
            if (meta.containsKey("\u65f6\u76f8")) {
                meta.put("f_time", meta.get("\u65f6\u76f8"));
            } else {
                if (StringUtil.isEmptyOrWhiteSpace((String)this.settingParams.time)) {
                    throw new RuntimeException("\u672a\u8bbe\u7f6e\u65f6\u76f8\uff01");
                }
                meta.put("f_time", this.settingParams.time);
            }
        }
    }
}

