/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin;

import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.entity.DmFileData;
import com.geoway.adf.dms.config.filemodel.FileDataUnit;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.util.XmlUtil;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.imagedb.dataset.util.FileReadUtil;
import com.geoway.imagedb.input.plugin.ImageDatasetImportPluginBase;
import com.geoway.webstore.input.plugin.model.ExecuteResult;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.TranslateOptions;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageTileSampleImportPlugin
extends ImageDatasetImportPluginBase {
    protected IFeatureClass businessFeatureClass;
    private ISpatialReferenceSystem srcSpatialReferenceSystem = null;

    @Override
    public ExecuteResult prepareImport() {
        ExecuteResult result = super.prepareImport();
        if (result.getSuccess().booleanValue()) {
            this.businessFeatureClass = this.businessSnapshotWorkspace.openFeatureClass("tb_sample_data");
            if (this.businessFeatureClass == null) {
                result.setSuccess(Boolean.valueOf(false));
                result.setErrorMessage("\u6253\u5f00\u4e1a\u52a1\u6837\u672c\u6570\u636e\u96c6\u5931\u8d25\uff01");
                return result;
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map<String, Object> getMetaData(DmFileData fileData) {
        FileDataUnit dataUnit = (FileDataUnit)ListUtil.find((List)fileData.getFiles(), FileDataUnit::isMainFile);
        String metaFile = dataUnit.getFileLocation();
        IFileset metaFileset = this.scanFileStorage.getFile(metaFile);
        if (metaFileset == null) {
            throw new RuntimeException(metaFile + "\u4e3b\u6570\u636e\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        try (InputStream metadataFileStream = metaFileset.openFileStream();){
            File y2File;
            String ypath;
            String x2path;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(metadataFileStream);
            Element root = document.getDocumentElement();
            NodeList tileInfoNodes = XmlUtil.findNodeList((Node)root, (String)"TileInfos/TileInfo");
            Element newTileInfoElement = null;
            Element oldTileInfoElement = null;
            if (tileInfoNodes.getLength() > 0) {
                for (int i = 0; i < tileInfoNodes.getLength(); ++i) {
                    Element tileInfoElement = (Element)tileInfoNodes.item(i);
                    Attr attr = tileInfoElement.getAttributeNode("type");
                    if (attr == null || "new".equals(attr.getValue())) {
                        newTileInfoElement = tileInfoElement;
                    }
                    if (attr == null || !"old".equals(attr.getValue())) continue;
                    oldTileInfoElement = tileInfoElement;
                }
            }
            if (newTileInfoElement == null) {
                throw new RuntimeException("\u6ca1\u6709\u74e6\u7247\u4fe1\u606f");
            }
            Node geometryInfoNode = XmlUtil.findfirstNode(newTileInfoElement, (String)"GeometryInfo");
            if (geometryInfoNode != null) {
                String projection;
                NodeList geoPointNodes = XmlUtil.findNodeList((Node)geometryInfoNode, (String)"ValidRange/GeoPoint");
                if (geoPointNodes.getLength() >= 4) {
                    ArrayList<String> geoCoords = new ArrayList<String>();
                    for (int i = 0; i < geoPointNodes.getLength(); ++i) {
                        Element geoPointElement = (Element)geoPointNodes.item(i);
                        geoCoords.add(geoPointElement.getAttribute("X") + " " + geoPointElement.getAttribute("Y"));
                    }
                    geoCoords.add((String)geoCoords.get(0));
                    this.currentDataGeometry = GeometryFunc.createGeometry((String)String.format("POLYGON((%s))", String.join((CharSequence)",", geoCoords)));
                }
                if (StringUtil.isNotEmpty((String)(projection = XmlUtil.findfirstNodeStringValue((Node)geometryInfoNode, (String)"Projection")))) {
                    this.srcSpatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((String)projection);
                }
            }
            if (this.currentDataGeometry == null) {
                throw new RuntimeException("\u5143\u6570\u636e\u51e0\u4f55\u56fe\u5f62\u91c7\u96c6\u5931\u8d25");
            }
            metaData.put("TileSize", XmlUtil.findfirstNodeStringValue(newTileInfoElement, (String)"TileBaseInfo/TileSize"));
            metaData.put("BandNum", XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"TileBaseInfo/BandNum"));
            metaData.put("BandBits", XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"TileBaseInfo/BandBits"));
            metaData.put("ImageName", XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"ImgBaseInfo/ImageName"));
            metaData.put("SatelliteName", XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"ImgBaseInfo/SatelliteName"));
            metaData.put("SensorType", XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"ImgBaseInfo/SensorType"));
            metaData.put("ImageTime", XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"ImgBaseInfo/ImageTime"));
            metaData.put("PixelSize", XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"ImgBaseInfo/PixelSize"));
            Node imageSourceNode = XmlUtil.findfirstNode((Node)newTileInfoElement, (String)"ImgBaseInfo/ImageSource");
            if (imageSourceNode != null) {
                metaData.put("ImageSource", ((Element)imageSourceNode).getAttribute("Value"));
            }
            if (StringUtil.isNotEmpty((String)(x2path = XmlUtil.findfirstNodeStringValue((Node)newTileInfoElement, (String)"TileBaseInfo/Path")))) {
                x2path = FileReadUtil.convertToAbsolutePath((String)metaFileset.getParentFile().getFullPath(), (String)x2path);
                x2path = this.convertPath2JPG(x2path);
            }
            metaData.put("x2path", x2path);
            if (oldTileInfoElement != null) {
                String x1path;
                metaData.put("OldTileSize", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"TileBaseInfo/TileSize"));
                metaData.put("OldBandNum", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"TileBaseInfo/BandNum"));
                metaData.put("OldBandBits", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"TileBaseInfo/BandBits"));
                metaData.put("OldImageName", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"ImgBaseInfo/ImageName"));
                metaData.put("OldSatelliteName", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"ImgBaseInfo/SatelliteName"));
                metaData.put("OldSensorType", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"ImgBaseInfo/SensorType"));
                metaData.put("OldImageTime", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"ImgBaseInfo/ImageTime"));
                metaData.put("OldPixelSize", XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"ImgBaseInfo/PixelSize"));
                Node oldImageSourceNode = XmlUtil.findfirstNode((Node)oldTileInfoElement, (String)"ImgBaseInfo/ImageSource");
                if (oldImageSourceNode != null) {
                    metaData.put("OldImageSource", ((Element)oldImageSourceNode).getAttribute("Value"));
                }
                if (StringUtil.isNotEmpty((String)(x1path = XmlUtil.findfirstNodeStringValue((Node)oldTileInfoElement, (String)"TileBaseInfo/Path")))) {
                    x1path = FileReadUtil.convertToAbsolutePath((String)metaFileset.getParentFile().getFullPath(), (String)x1path);
                    x1path = this.convertPath2JPG(x1path);
                }
                metaData.put("x1path", x1path);
            }
            if (StringUtil.isNotEmpty((String)(ypath = XmlUtil.findfirstNodeStringValue((Node)root, (String)"LabelInfo/Path")))) {
                ypath = FileReadUtil.convertToAbsolutePath((String)metaFileset.getParentFile().getFullPath(), (String)ypath);
                ypath = this.convertPath2JPG(ypath);
            }
            metaData.put("ypath", ypath);
            String rootPath = metaFileset.getParentFile().getParentFile().getFullPath();
            File y1File = Paths.get(rootPath, "y1", FileUtil.getFileNameWithoutExtension((String)metaFileset.getName()) + ".tif").toFile();
            if (y1File.exists()) {
                String y1path = y1File.getAbsolutePath();
                y1path = this.convertPath2JPG(y1path);
                metaData.put("y1path", y1path);
            }
            if ((y2File = Paths.get(rootPath, "y2", FileUtil.getFileNameWithoutExtension((String)metaFileset.getName()) + ".tif").toFile()).exists()) {
                String y2path = y2File.getAbsolutePath();
                y2path = this.convertPath2JPG(y2path);
                metaData.put("y2path", y2path);
            }
            metaData.put("SceneType", this.targetParams.sampleSceneType);
            metaData.put("SampleScheme", this.targetParams.sampleScheme);
            HashMap<String, Object> hashMap = metaData;
            return hashMap;
        }
        catch (Exception e) {
            throw new RuntimeException(fileData.getMainPath() + "\u5143\u6570\u636e\u6587\u4ef6\u89e3\u6790\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    @Override
    protected String getSnapshotFile(DmFileData fileData) {
        return null;
    }

    @Override
    protected void addThumb(String dataId) {
    }

    @Override
    protected Boolean processRepeatedData(Map<String, Object> metaRow) {
        return false;
    }

    @Override
    protected boolean writeMetaData(String dataId, Map<String, Object> metaRow, DmFileData fileData, RefObject<String> errorMsg) {
        this.currentDataId = dataId;
        this.currentFileData = fileData;
        boolean success = true;
        errorMsg.set((Object)"");
        try {
            IFeatureClass targetFc = (IFeatureClass)this.targetGeoDataset;
            IGeometry extentGeometry = this.currentDataGeometry;
            if (this.currentDataGeometry != null) {
                extentGeometry = this.currentDataGeometry.projectToCopy(this.srcSpatialReferenceSystem, targetFc.getSpatialReferenceSystem());
            }
            this.insertFeature(targetFc, metaRow, extentGeometry);
        }
        catch (Exception e) {
            this.log.error("\u5143\u6570\u636e\u63d2\u5165\u5931\u8d25", (Throwable)e);
            errorMsg.set((Object)e.getMessage());
            success = false;
        }
        if (success) {
            try {
                Map<String, Object> businessValues = this.getBusinessValues(metaRow);
                IGeometry businessGeometry = this.currentDataGeometry.projectToCopy(this.srcSpatialReferenceSystem, this.businessSnapshotDataset.getSpatialReferenceSystem());
                this.insertFeature(this.businessFeatureClass, businessValues, businessGeometry);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                errorMsg.set((Object)((String)errorMsg.get() + "\u5143\u6570\u636e\u5165\u5e93\u5931\u8d25\uff01" + e.getMessage()));
                this.onImportDataLog("\u5143\u6570\u636e\u5165\u5e93\u5931\u8d25\uff01" + e.getMessage());
                return false;
            }
        }
        return success;
    }

    @Override
    protected Map<String, Object> getBusinessValues(Map<String, Object> meta) {
        Map<String, Object> values = super.getBusinessValues(meta);
        for (Map.Entry<String, Object> entry : meta.entrySet()) {
            if (values.containsKey(entry.getKey())) continue;
            values.put(entry.getKey(), entry.getValue());
        }
        return values;
    }

    private String convertPath2JPG(String path) {
        File yFile = new File(path);
        if (yFile.exists()) {
            String yJPGPath = Paths.get(yFile.getParent(), FileUtil.getFileNameWithoutExtension((String)yFile.getName()) + ".jpg").toFile().getAbsolutePath();
            try {
                TranslateOptions options;
                Dataset thumbDataset;
                Dataset dataset = gdal.Open((String)path, (int)gdalconstConstants.GA_ReadOnly);
                if (dataset == null) {
                    throw new RuntimeException("\u6805\u683c\u8bfb\u53d6\u5931\u8d25\uff01");
                }
                Vector vector = gdal.ParseCommandLine((String)"-of JPEG -ot Byte -scale");
                if (dataset.GetRasterCount() >= 3) {
                    vector = gdal.ParseCommandLine((String)"-of JPEG -ot Byte -b 1 -b 2 -b 3 -scale");
                }
                if ((thumbDataset = gdal.Translate((String)yJPGPath, (Dataset)dataset, (TranslateOptions)(options = new TranslateOptions(vector)))) != null) {
                    thumbDataset.delete();
                }
                dataset.delete();
                File tempFileAux = new File(yJPGPath + ".aux.xml");
                boolean success = tempFileAux.delete();
                return yJPGPath;
            }
            catch (Exception e) {
                this.log.error("\u5355\u6ce2\u6bb5\u5f71\u50cf\u8f6cjpg\u56fe\u7247\u5931\u8d25\uff01", (Throwable)e);
            }
        }
        return path;
    }
}

