/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.meta;

import com.geoway.adf.gis.fs.IFileset;
import com.geoway.webstore.input.plugin.meta.MetaDataReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ImageMetaDataReader {
    private static Pattern pattern = Pattern.compile("[0-9]*");

    public static Map<String, String> readMeta(IFileset fileset) {
        String ext;
        switch (ext = fileset.getExt()) {
            case ".txt": 
            case ".mat": {
                return ImageMetaDataReader.readLandsatTxtMeta(fileset);
            }
            case ".xls": 
            case ".xlsx": {
                return MetaDataReader.readMeta((IFileset)fileset);
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u5143\u6570\u636e\u6587\u4ef6\u7c7b\u578b: " + ext);
    }

    private static Map<String, String> readLandsatTxtMeta(IFileset fileset) {
        String[] values = MetaDataReader.readFileLines((IFileset)fileset);
        HashMap<String, String> metaData = new HashMap<String, String>(0);
        for (String value : values) {
            String fldValue;
            String fldName;
            String[] contents = value.trim().split("[\\s=]+", 2);
            if (contents.length < 2) continue;
            if (pattern.matcher(contents[0]).matches()) {
                if ((contents = contents[1].split("[\\s=]+", 2)).length < 2) continue;
                fldName = contents[0];
                fldValue = contents[1];
            } else {
                fldName = contents[0];
                fldValue = contents[1];
            }
            if (fldName == null || fldName.length() <= 0) continue;
            if (fldValue.startsWith("\"") && fldValue.endsWith("\"")) {
                fldValue = fldValue.substring(1, fldValue.length() - 1);
            }
            metaData.put(fldName, fldValue);
        }
        return metaData;
    }
}

