/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.component;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.gis.basic.RefObject;
import com.geoway.imagedb.input.dao.ImgScheduleTaskDao;
import com.geoway.imagedb.input.entity.ImgScheduleTask;
import com.geoway.webstore.input.constant.TaskStatusEnum;
import com.geoway.webstore.input.dao.ImpTaskDao;
import com.geoway.webstore.input.dao.ImpTaskDataDao;
import com.geoway.webstore.input.dao.ImpTaskDataUnitDao;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.entity.ImpPlugin;
import com.geoway.webstore.input.entity.ImpTask;
import com.geoway.webstore.input.entity.ImpTaskData;
import com.geoway.webstore.input.entity.ImpTaskDataUnit;
import com.geoway.webstore.input.manager.ImportTaskUnitManager;
import com.geoway.webstore.input.plugin.IImportPlugin;
import com.geoway.webstore.input.plugin.PluginManager;
import com.geoway.webstore.input.plugin.data.IImportData;
import com.geoway.webstore.input.plugin.data.IImportUnit;
import com.geoway.webstore.input.plugin.model.ExecuteResult;
import com.geoway.webstore.input.service.ImpSchemeService;
import com.geoway.webstore.input.service.ImpTaskService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ImageImportScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ImageImportScheduleTask.class);
    @Resource
    private ImgScheduleTaskDao scheduleTaskDao;
    @Resource
    private ImpTaskService impTaskService;
    @Resource
    private ImpSchemeService schemeService;
    @Resource
    private ImpTaskDao taskDao;
    @Resource
    private ImpTaskDataUnitDao taskDataUnitDao;
    @Resource
    private ImpTaskDataDao taskDataDao;
    @Resource
    private ImportTaskUnitManager taskUnitManager;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);
    private final Map<String, RunningScheduler> tasks = new ConcurrentHashMap<String, RunningScheduler>();

    @PostConstruct
    public void initSchedules() {
        try {
            List<ImgScheduleTask> scheduleTasks = this.scheduleTaskDao.selectAllEnableTask();
            ArrayList<Long> status = new ArrayList<Long>();
            status.add(Long.parseLong(TaskStatusEnum.Processing.getValue() + ""));
            List impTaskList = this.taskDao.selectByStatus(status, null, null, null);
            if (impTaskList == null || impTaskList.size() == 0) {
                return;
            }
            List impTaskIdList = ListUtil.convertAll((List)impTaskList, ImpTask::getId);
            for (ImgScheduleTask task : scheduleTasks) {
                Date dateNow = new Date();
                Date startDate = task.getStartTime();
                long period = task.getInterval() * 3600L;
                Date nextDate = this.getNextDate(dateNow, startDate, period);
                if (!impTaskIdList.contains(task.getImpTaskId())) continue;
                if (task.getEndTime() != null && nextDate.after(task.getEndTime())) {
                    task.setEnable(ConstantsValue.FALSE_VALUE);
                    this.scheduleTaskDao.disableTask(task.getId());
                    this.impTaskService.stopTask(task.getImpTaskId());
                    continue;
                }
                log.info("\u81ea\u52a8\u5f52\u6863\u5165\u5e93[" + task.getName() + "]\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1");
                try {
                    this.addScheduleTask(task);
                }
                catch (Exception e) {
                    log.error("\u81ea\u52a8\u5f52\u6863\u5165\u5e93[" + task.getName() + "]\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5f52\u6863\u5165\u5e93\u5b9a\u65f6\u4efb\u52a1\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @PreDestroy
    public void stopSchedules() {
        this.shutdownScheduler();
    }

    public String createScheduleTask(ImgScheduleTask task) {
        task.setId(UUID.randomUUID().toString().replace("-", ""));
        this.scheduleTaskDao.insert(task);
        return task.getId();
    }

    public void beginScheduleTask(Long impTaskId, String userName) {
        List<ImgScheduleTask> scheduleTaskList = this.scheduleTaskDao.selectByImpTaskId(impTaskId);
        if (scheduleTaskList == null || scheduleTaskList.size() == 0) {
            return;
        }
        ImgScheduleTask scheduleTask = scheduleTaskList.get(0);
        Date dateNow = new Date();
        Date startDate = scheduleTask.getStartTime();
        long period = scheduleTask.getInterval() * 3600L;
        Date nextDate = this.getNextDate(dateNow, startDate, period);
        if (scheduleTask.getEndTime() != null && nextDate.after(scheduleTask.getEndTime())) {
            return;
        }
        scheduleTask.setUser(userName);
        this.addScheduleTask(scheduleTask);
    }

    public Boolean hasScheduleTask(Long impTaskId) {
        List<ImgScheduleTask> scheduleTaskList = this.scheduleTaskDao.selectByImpTaskId(impTaskId);
        if (scheduleTaskList == null || scheduleTaskList.size() == 0) {
            return false;
        }
        ImgScheduleTask scheduleTask = scheduleTaskList.get(0);
        return this.tasks.get(scheduleTask.getId()) != null;
    }

    public void stopScheduleTask(Long impTaskId) {
        List<ImgScheduleTask> scheduleTaskList = this.scheduleTaskDao.selectByImpTaskId(impTaskId);
        if (scheduleTaskList == null || scheduleTaskList.size() == 0) {
            return;
        }
        ImgScheduleTask scheduleTask = scheduleTaskList.get(0);
        this.cancelScheduleTask(scheduleTask.getId());
    }

    private void addScheduleTask(ImgScheduleTask task) {
        Date dateNow = new Date();
        Date startDate = task.getStartTime();
        long period = task.getInterval() * 3600L;
        Date nextDate = this.getNextDate(dateNow, startDate, period);
        long initialDelay = DateUtil.between((Date)dateNow, (Date)nextDate, (DateUnit)DateUnit.SECOND);
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> this.executeTask(task), initialDelay, period, TimeUnit.SECONDS);
        RunningScheduler runningScheduler = new RunningScheduler();
        runningScheduler.future = future;
        this.tasks.put(task.getId(), runningScheduler);
    }

    private void executeTask(ImgScheduleTask task) {
        ImpTask impTask = this.taskDao.selectByPrimaryKey(task.getImpTaskId());
        if (impTask == null) {
            this.cancelScheduleTask(task.getId());
            return;
        }
        try {
            ImpSchemaDTO impSchemaDTO = this.schemeService.getSchemaDetail(impTask.getSchemaId());
            Assert.notNull((Object)impSchemaDTO.getPlugin(), (String)"\u672a\u83b7\u53d6\u5230\u5165\u5e93\u63d2\u4ef6");
            IImportPlugin importPlugin = PluginManager.createImportPlugin((ImpPlugin)impSchemaDTO.getPlugin());
            importPlugin.initialize(impTask.getSourceParams(), impSchemaDTO.getParamValues(), impTask.getSettingParams());
            this.scanImport(impTask, impSchemaDTO, importPlugin, task.getUser());
        }
        catch (Exception e) {
            log.error("\u81ea\u52a8\u5f52\u6863\u5165\u5e93\u4efb\u52a1[" + task.getName() + "]\u521b\u5efa\u5931\u8d25\uff01");
        }
        task.setLastPerformTime(new Date());
        task.setPerformTimes(task.getPerformTimes() + 1);
        this.scheduleTaskDao.updateByPrimaryKey(task);
        Date dateNow = new Date();
        Date startDate = task.getStartTime();
        long period = task.getInterval() * 3600L;
        Date nextDate = this.getNextDate(dateNow, startDate, period);
        if (task.getEndTime() != null && nextDate.after(task.getEndTime())) {
            this.cancelScheduleTask(task.getId());
            this.scheduleTaskDao.disableTask(task.getId());
            this.finishImportTask(impTask);
        }
    }

    private void scanImport(ImpTask impTask, ImpSchemaDTO impSchemaDTO, IImportPlugin importPlugin, String userName) {
        RefObject unitCount = new RefObject((Object)0);
        RefObject dataCount = new RefObject((Object)0);
        importPlugin.addScanDataUnitListener(dataUnitArgs -> {
            IImportUnit dataUnit = dataUnitArgs.getImportUnit();
            ImpTaskDataUnit taskDataUnit = new ImpTaskDataUnit();
            taskDataUnit.setTaskId(impTask.getId());
            taskDataUnit.setUnitName(dataUnit.getName());
            taskDataUnit.setStatus(Integer.valueOf(TaskStatusEnum.Ready.getValue()));
            taskDataUnit.setProgTotal(Long.valueOf(dataUnitArgs.getImportDataList().size()));
            taskDataUnit.setProgSuccess(Long.valueOf(0L));
            taskDataUnit.setProgFail(Long.valueOf(0L));
            this.taskDataUnitDao.insert(taskDataUnit);
            dataUnit.setTaskId(impTask.getId());
            dataUnit.setId(taskDataUnit.getId());
            dataUnit.insert();
            for (IImportData data : dataUnitArgs.getImportDataList()) {
                ImpTaskData taskData = new ImpTaskData();
                taskData.setTaskId(impTask.getId());
                taskData.setTaskUnitId(taskDataUnit.getId());
                taskData.setDataName(data.getName());
                taskData.setStatus(Integer.valueOf(TaskStatusEnum.Ready.getValue()));
                taskData.setProgTotal(Long.valueOf(0L));
                taskData.setProgSuccess(Long.valueOf(0L));
                taskData.setProgFail(Long.valueOf(0L));
                this.taskDataDao.insert(taskData);
                data.setTaskId(impTask.getId());
                data.setId(taskData.getId());
                data.setUnitId(dataUnit.getId());
                data.insert();
                dataCount.set((Object)((Integer)dataCount.get() + 1));
            }
            unitCount.set((Object)((Integer)unitCount.get() + 1));
            this.impTaskService.disableCache();
            LoginUserInfo userInfo = new LoginUserInfo();
            userInfo.setUserName(userName);
            ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            importPlugin.initialize(impTask.getSourceParams(), impSchemaDTO.getParamValues(), impTask.getSettingParams());
            ExecuteResult preResult = importPlugin.prepareImport();
            if (!preResult.getSuccess().booleanValue()) {
                String errorMessage = "\u5165\u5e93\u5931\u8d25\uff1a" + preResult.getErrorMessage();
                log.error(errorMessage);
                return;
            }
            ExecuteResult result = this.taskUnitManager.excuteDataUnit(importPlugin, taskDataUnit);
        });
        importPlugin.scanData();
        if ((Integer)dataCount.get() == 0) {
            throw new RuntimeException("\u672a\u626b\u63cf\u5230\u6570\u636e");
        }
        impTask.setProgTotal(Long.valueOf(((Integer)unitCount.get()).intValue()));
    }

    private void finishImportTask(ImpTask impTask) {
        boolean success = true;
        List dataUnitList = this.taskDataUnitDao.selectByTaskId(impTask.getId(), null, null);
        for (ImpTaskDataUnit dataUnit : dataUnitList) {
            if (dataUnit.getStatus().intValue() != TaskStatusEnum.FinishedSuccessed.getValue() && dataUnit.getStatus().intValue() != TaskStatusEnum.FinishedFailed.getValue()) {
                return;
            }
            if (dataUnit.getStatus().intValue() != TaskStatusEnum.FinishedFailed.getValue()) continue;
            success = false;
        }
        impTask.setStatus(Integer.valueOf(success ? TaskStatusEnum.FinishedSuccessed.getValue() : TaskStatusEnum.FinishedFailed.getValue()));
        impTask.setFailMsg("\u5165\u5e93\u4e2d\u6b62");
        this.taskDao.updateStatus(impTask);
        this.impTaskService.disableCache();
    }

    public void cancelScheduleTask(String id) {
        RunningScheduler runningScheduler = this.tasks.get(id);
        if (runningScheduler != null) {
            runningScheduler.canceled = true;
            runningScheduler.future.cancel(false);
            this.tasks.remove(id);
        }
    }

    private Date getNextDate(Date nowDate, Date startDate, long period) {
        long interval = DateUtil.between((Date)nowDate, (Date)startDate, (DateUnit)DateUnit.SECOND);
        if (nowDate.compareTo(startDate) > 0) {
            interval = (long)((int)Math.ceil((double)interval / (double)period)) * period - interval;
        }
        if (interval == 0L) {
            interval = period;
        }
        return DateUtil.offsetSecond((Date)nowDate, (int)((int)interval));
    }

    public void shutdownScheduler() {
        this.scheduler.shutdown();
    }

    static class RunningScheduler {
        public ScheduledFuture<?> future;
        public boolean canceled = false;

        RunningScheduler() {
        }
    }
}

