/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.DateTimeUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.EnvironmentConfig;
import com.geoway.imagedb.input.dto.automatic.AutomaticTaskSimpleDTO;
import com.geoway.imagedb.input.dto.automatic.ImageProductAutomaticTaskCreateDTO;
import com.geoway.imagedb.input.dto.automatic.ThematicTaskCreateDTO;
import com.geoway.imagedb.input.plugin.VectorThematicSettingParams;
import com.geoway.imagedb.input.service.ImageAutomaticTaskService;
import com.geoway.imagedb.input.service.ImageImportTaskCreateService;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.dto.ImpTaskCreateDTO;
import com.geoway.webstore.input.dto.ImpTaskDTO;
import com.geoway.webstore.input.plugin.model.DataDuplicateStrategyEnum;
import com.geoway.webstore.input.plugin.params.ImportSourceParams;
import com.geoway.webstore.input.service.ImpSchemeService;
import com.geoway.webstore.input.service.ImpTaskService;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ImageAutomaticTaskServiceImpl
implements ImageAutomaticTaskService {
    private static final Logger log = LoggerFactory.getLogger(ImageAutomaticTaskServiceImpl.class);
    @Resource
    private ImpSchemeService schemeService;
    @Resource
    private ImpTaskService impTaskService;
    @Resource
    private ImageImportTaskCreateService imageImportTaskCreateService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;

    @Override
    public List<AutomaticTaskSimpleDTO> createImportTask(ImageProductAutomaticTaskCreateDTO taskCreateDTO) {
        log.info("\u521b\u5efa\u65e0\u4eba\u503c\u5b88\u5165\u5e93\u4efb\u52a1\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)taskCreateDTO));
        PageInfo pageInfo = this.schemeService.listSchema(0, 10000, taskCreateDTO.getImportSchemaGroupName(), null, Boolean.valueOf(false), Boolean.valueOf(false));
        List schemaList = pageInfo.getList();
        if (schemaList == null || schemaList.size() == 0) {
            log.error("\u5206\u7ec4\u4e0b[" + taskCreateDTO.getImportSchemaGroupName() + "]\u65e0\u5165\u5e93\u65b9\u6848");
            throw new RuntimeException("\u5206\u7ec4\u4e0b[" + taskCreateDTO.getImportSchemaGroupName() + "]\u65e0\u5165\u5e93\u65b9\u6848");
        }
        ArrayList<AutomaticTaskSimpleDTO> taskList = new ArrayList<AutomaticTaskSimpleDTO>();
        this.threadPoolTaskExecutorData.execute(() -> {
            String scanDataPath = taskCreateDTO.getDataPath();
            if (Boolean.TRUE.equals(taskCreateDTO.getIsMigrateData())) {
                String migrateDir = EnvironmentConfig.getProperty((String)"project.automatic-image-migrate-path", (String)"");
                if (StringUtil.isEmptyOrWhiteSpace((String)migrateDir)) {
                    log.info("automatic-image-migrate-path\u672a\u914d\u7f6e\uff0c\u4f7f\u7528./upload");
                    migrateDir = UploadPathConfig.getUploadPath().toAbsolutePath().toString();
                }
                migrateDir = Paths.get(migrateDir, taskCreateDTO.getProductTaskId()).toAbsolutePath().toString();
                FileUtil.copy((String)taskCreateDTO.getDataPath(), (String)migrateDir);
                scanDataPath = migrateDir;
            }
            for (ImpSchemaDTO schemaDTO : schemaList) {
                try {
                    ImpTaskDTO taskDTO = this.imageImportTaskCreateService.createImportTask(schemaDTO, scanDataPath, "\u65e0\u4eba\u503c\u5b88-");
                    AutomaticTaskSimpleDTO simpleDTO = new AutomaticTaskSimpleDTO();
                    simpleDTO.setImportTaskId(taskDTO.getId() + "");
                    simpleDTO.setImportTaskName(taskDTO.getName());
                    taskList.add(simpleDTO);
                }
                catch (Exception e) {
                    log.error(schemaDTO.getName() + " \u521b\u5efa\u5165\u5e93\u4efb\u52a1\u5931\u8d25", (Throwable)e);
                }
            }
        });
        return taskList;
    }

    @Override
    public List<AutomaticTaskSimpleDTO> createThematicImportTask(List<ThematicTaskCreateDTO> taskCreateDTO) {
        ArrayList<AutomaticTaskSimpleDTO> taskList = new ArrayList<AutomaticTaskSimpleDTO>();
        for (ThematicTaskCreateDTO createDTO : taskCreateDTO) {
            try {
                boolean mkdirs;
                File migrateDirFile;
                ImpSchemaDTO schemaDetail = this.schemeService.getSchemaDetailByName("\u63a5\u53e3_" + createDTO.getSceneType());
                String migrateDir = EnvironmentConfig.getProperty((String)"project.automatic-image-migrate-path", (String)"");
                if (StringUtil.isEmptyOrWhiteSpace((String)migrateDir)) {
                    log.info("automatic-image-migrate-path\u672a\u914d\u7f6e\uff0c\u4f7f\u7528./upload");
                    migrateDir = UploadPathConfig.getUploadPath().toAbsolutePath().toString();
                }
                if (!(migrateDirFile = new File(migrateDir = Paths.get(migrateDir, "\u63a5\u53e3_" + createDTO.getSceneType(), createDTO.getProductTaskId()).toAbsolutePath().toString())).exists() && !(mkdirs = migrateDirFile.mkdirs())) {
                    log.error("\u65e0\u4eba\u503c\u5b88\u4e13\u9898\u6570\u636e\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff1a{}", (Object)migrateDir);
                    continue;
                }
                File shpFile = new File(createDTO.getDataPath());
                if (!shpFile.exists()) {
                    log.error("\u65e0\u4eba\u503c\u5b88\u4e13\u9898\u6570\u636e\u4e0d\u5b58\u5728\uff1a{}", (Object)createDTO.getDataPath());
                    continue;
                }
                String shpName = FileUtil.getFileNameWithoutExtension((String)createDTO.getDataPath());
                for (File copyFile : shpFile.getParentFile().listFiles()) {
                    String copyFileName = FileUtil.getFileNameWithoutExtension((String)copyFile.getPath());
                    if (!copyFile.isFile() || !shpName.equals(copyFileName)) continue;
                    FileUtil.copy((String)copyFile.getPath(), (String)Paths.get(migrateDir, copyFile.getName()).toString());
                }
                String copyShpFilePath = Paths.get(migrateDir, shpFile.getName()).toString();
                VectorThematicSettingParams settingParams = new VectorThematicSettingParams();
                settingParams.shpPath = copyShpFilePath;
                settingParams.productTaskId = createDTO.getProductTaskId();
                settingParams.imageryModel = createDTO.getSceneType();
                ImpTaskCreateDTO impTaskCreateDTO = new ImpTaskCreateDTO();
                impTaskCreateDTO.setName(String.format("%s-%s", "\u65e0\u4eba\u503c\u5b88-\u4e13\u9898" + schemaDetail.getName(), DateTimeUtil.dateString((String)"yyyyMMddHH:mm")));
                impTaskCreateDTO.setSchemaId(schemaDetail.getId());
                impTaskCreateDTO.setCreateUser("\u751f\u4ea7\u7cfb\u7edf");
                impTaskCreateDTO.setSettingParams(JSONObject.toJSONString((Object)settingParams));
                ImportSourceParams sourceParams = new ImportSourceParams();
                sourceParams.setAutoCreateIndex(Boolean.valueOf(true));
                sourceParams.setDataDuplicateStrategy(Integer.valueOf(DataDuplicateStrategyEnum.Skip.getValue()));
                impTaskCreateDTO.setSourceParams(JSONObject.toJSONString((Object)sourceParams));
                impTaskCreateDTO.setStartTask(Boolean.valueOf(true));
                Long taskId = this.impTaskService.createTask(impTaskCreateDTO);
                AutomaticTaskSimpleDTO simpleDTO = new AutomaticTaskSimpleDTO();
                simpleDTO.setImportTaskId(taskId + "");
                simpleDTO.setImportTaskName(impTaskCreateDTO.getName());
                taskList.add(simpleDTO);
            }
            catch (Exception e) {
                log.error(createDTO.getSceneType() + "[" + createDTO.getProductTaskId() + "] \u521b\u5efa\u5165\u5e93\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
        }
        return taskList;
    }
}

