/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.imagedb.input.plugin.listener;

import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.imagedb.input.component.ImageImportScheduleTask;
import com.geoway.imagedb.input.plugin.ImageDatasetScheduleImportPlugin;
import com.geoway.webstore.input.dto.ImpSchemaDTO;
import com.geoway.webstore.input.event.ImportTaskRunningEvent;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ImportTaskRunningEventListener
implements ApplicationListener<ImportTaskRunningEvent> {
    private static final Logger log = LoggerFactory.getLogger(ImportTaskRunningEventListener.class);
    @Resource
    private ImageImportScheduleTask imageImportScheduleTask;

    public void onApplicationEvent(ImportTaskRunningEvent event) {
        ImpSchemaDTO impSchema = event.getImpSchema();
        if (impSchema != null && impSchema.getPlugin().getClassName().equals(ImageDatasetScheduleImportPlugin.class.getName())) {
            LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
            String userName = event.getImpTask().getCreateUser();
            if (userInfo != null) {
                userName = userInfo.getUserName();
            }
            this.imageImportScheduleTask.beginScheduleTask(event.getImpTask().getId(), userName);
        }
    }
}

