package com.geoway.landteam.gas.assist.notifylogout.impl;

import com.geoway.landteam.gas.assist.notifylogout.NotifyLogoutService;
import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyRequest;
import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyResponse;
import com.geoway.landteam.gas.assist.notifylogout.tools.NotifyExecutor;
import com.gw.base.data.GwValidateException;
import com.gw.base.json.GwJSON;
import com.gw.base.lang.GkTypeReference;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import java.util.List;


@Service
@Primary
public class NotifyLogoutServiceImpl implements NotifyLogoutService {


    private static GiLoger logger = GwLoger.getLoger(NotifyLogoutServiceImpl.class);

    @Value("${gac.assist.notify-logout.providers:}")
    private String[] providers;

    @Value("${gac.assist.notify-logout.provider-self:true}")
    private boolean providerSelf;

    private int index = 0;
    private String getProvider(){
        if(providers == null || providers.length == 0){
            return null;
        }
        int i = index%providers.length;
        index++;
        return providers[i];
    }

    /*
    private static int index2 = 0;

    private static int getProvider2(){


        index2 = index2%5;
        return index2++;
    }

    public static void  main(String args[]){
        System.out.println(getProvider2());
        System.out.println(getProvider2());System.out.println(getProvider2());
        System.out.println(getProvider2());System.out.println(getProvider2());
        System.out.println(getProvider2());System.out.println(getProvider2());
    }

     */




    private RestTemplate restTemplate = new RestTemplate();

    @Override
    public List<NotifyResponse> notifyLogout(List<NotifyRequest> requests) {

        if(providerSelf && requests.size() < 2){
            return NotifyExecutor.execute(requests);
        }
        String provider = getProvider();
        if(provider == null){
            if(providerSelf) {
                return NotifyExecutor.execute(requests);
            }else{
                String emsg = "没有配置gac.assist.notify-logout.providers。并且gac.assist.notify-logout.provider-self为false";
                logger.error(emsg);
                throw new GwValidateException(emsg);
            }
        }

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String bodyStr = GwJSON.toJson(requests).toJSONString();
        HttpEntity httpEntity = new HttpEntity<>(bodyStr, headers);
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(provider, HttpMethod.POST, httpEntity, String.class);
        }catch (Exception e){
            e.printStackTrace();
            logger.error("向地址:{}发送回调任务发生错误.",provider);
        }

        if(responseEntity != null && responseEntity.getStatusCodeValue() == 200) {
            String body = responseEntity.getBody();
            List<NotifyResponse> res = GwJSON.toJson(body).toBean(new GkTypeReference<List<NotifyResponse>>() {});
            return res;
        }else{//如果发送存在错误(并发器服务有问题)，自己补发一下
            return NotifyExecutor.execute(requests);
        }

    }
}