package com.geoway.landteam.gas.assist.notifylogout.tools;

import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyRequest;
import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyResponse;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import javax.net.ssl.*;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class NotifyExecutor implements Supplier<NotifyResponse> {
	private static final GiLoger log = GwLoger.getLoger(NotifyExecutor.class);


	public static String CharsetName = "UTF-8";

	private NotifyRequest notifyRequest = null;


	public NotifyExecutor(NotifyRequest request){
		this.notifyRequest = request;
	}

	public static List<NotifyResponse> execute(List<NotifyRequest> requests){

		List<NotifyResponse> responses = new ArrayList<>();
		if(requests == null || requests.size() == 0){
			return responses;
		}
		if(requests.size() == 1){
			NotifyRequest req = requests.get(0);
			NotifyResponse resp = new NotifyExecutor(req).get();
			responses.add(resp);
			return responses;
		}
		List<CompletableFuture<NotifyResponse>> futures = new ArrayList<>();
		for(NotifyRequest req : requests){
			futures.add(CompletableFuture.supplyAsync(new NotifyExecutor(req)));
		}
		CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
		try {
			combinedFuture.get();
		}catch (Exception e){
			return responses;
		}
		for(CompletableFuture<NotifyResponse> future:futures){
			try {
				NotifyResponse res = future.get();
				responses.add(res);
			}catch (Exception e){
				responses.add(new NotifyResponse().failtureResponse("请求发生错误"));
			}
		}
		return responses;
	}




	@Override
	public NotifyResponse get() {
		NotifyResponse res = new NotifyResponse();
		sendRequest(res);
		Gw.log.info("向->client:{}发送注销请求,url:{},accessToken:{},result:{}",notifyRequest.getClientId(),notifyRequest.getUri(),notifyRequest.getToken(),res);
		return res;
	}

	private void sendRequest(NotifyResponse res) {
		URL url = null;
		try{
			url = new URL(notifyRequest.getUri());
		}catch(Exception e){
			res.failtureResponse("创建URL请求地址发生错误");
			return;
		}
		Map<String,Object> param = new HashMap<>();

		param.put("access_token", notifyRequest.getToken());

		String data = null;
		try {
			data = mapToUrl(param, true);
		}catch (Exception e){
			res.failtureResponse("转码参数发生错误");
			return;
		}

		HttpURLConnection conn = null;
		try {
			conn = (HttpURLConnection) url.openConnection();
		}catch (Exception e){
			res.failtureResponse("创建HttpURLConnection对象发生错误");
			return ;
		}

		conn.setDoOutput(true);
		conn.setDoInput(true);

		try {
			conn.setRequestMethod("POST");
		}catch (Exception e){
			res.failtureResponse("HttpURLConnection设置POST发生错误");
			return ;
		}
		conn.setUseCaches(false);
		conn.setConnectTimeout(1000);
		conn.setReadTimeout(1000);
		conn.setInstanceFollowRedirects(true);
		conn.setRequestProperty("Content-Type","application/x-www-form-urlencoded");
		DataOutputStream out = null;
		try {
			out = new DataOutputStream(conn.getOutputStream());
		}catch (Exception e){
			res.failtureResponse("HttpURLConnection.getOutputStream打开远程连接发生错误");
			return ;
		}
		try {
			out.write(data.getBytes(CharsetName));
			out.flush();
		}catch (Exception e){
			res.failtureResponse("向远程发送数据发生错误");
			return ;
		}finally {
			try {
				out.close();
			}catch (Exception e){
				res.failtureResponse("断开连接发生错误");
				return ;
			}
		}
		int code = 0;
		try {
			code = conn.getResponseCode();
		}catch (Exception e){
			res.failtureResponse("获取返回状态码发生错误");
			return ;
		}

		BufferedReader br = null;
		try{
			if (code != 200) {
				br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), CharsetName));
			}else{
				br = new BufferedReader(new InputStreamReader(conn.getInputStream(), CharsetName));
			}
		}catch (Exception e){
			res.failtureResponse("获取结果输入流发生错误");
			return ;
		}

		StringBuffer sb = new StringBuffer();
		String lines = null;
		try {
			while ((lines = br.readLine()) != null) {
				sb.append(lines);
			}
		}catch (Exception e){
			res.failtureResponse("读取结果发生错误");
			return ;
		}
		try {
			br.close();
			conn.disconnect();
		}catch (Exception e){
			log.error(e);
		}
		res.successResponse(sb.toString());
	}



	static {
		NotifyExecutor.ignoreSsl();
	}

    
    public static String mapToUrl(Map<String, Object> data,boolean encodeValue) throws Exception {
        if(data.isEmpty()) {
        	return null;
        }
    	StringBuffer param = new StringBuffer();
    	Object value = null;
        for (String key : data.keySet()) {
        	value = data.get(key);
        	if(value != null) {
        		param.append(key).append("=");
            	param.append(encodeValue?URLEncoder.encode(data.get(key).toString(),CharsetName):value.toString());
            	param.append("&");
        	}
        }
        return param.substring(0, param.length() - 1);
    }




	
	static class miTM implements TrustManager, X509TrustManager {
		public X509Certificate[] getAcceptedIssuers() {
			return null;
		}
		public boolean isServerTrusted(X509Certificate[] certs) {
			return true;
		}
		public boolean isClientTrusted(X509Certificate[] certs) {
			return true;
		}
		public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
		}
		public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
		}
	}
	
	private static void trustAllHttpsCertificates(){
		TrustManager[] trustAllCerts = new TrustManager[1];
		TrustManager tm = new miTM();
		trustAllCerts[0] = tm;
		try {
			SSLContext sc = SSLContext.getInstance("SSL");
			sc.init(null, trustAllCerts, null);
			HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
		} catch (Exception e) {
			Gw.log.error(e);
		}
	}
	
	
	public static void ignoreSsl(){
		HostnameVerifier hv = new HostnameVerifier() {
			public boolean verify(String urlHostName, SSLSession session) {
				log.warn("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
				return true;
			}
		};
		trustAllHttpsCertificates();
		HttpsURLConnection.setDefaultHostnameVerifier(hv);
	}
	
	
	
}
