/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.gas.assist.notifylogout.impl;

import com.geoway.landteam.gas.assist.notifylogout.NotifyLogoutService;
import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyRequest;
import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyResponse;
import com.geoway.landteam.gas.assist.notifylogout.tools.NotifyExecutor;
import com.gw.base.data.GwValidateException;
import com.gw.base.json.GwJSON;
import com.gw.base.lang.GkTypeReference;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Primary
public class NotifyLogoutServiceImpl
implements NotifyLogoutService {
    private static GiLoger logger = GwLoger.getLoger(NotifyLogoutServiceImpl.class);
    @Value(value="${gac.assist.notify-logout.providers:}")
    private String[] providers;
    @Value(value="${gac.assist.notify-logout.provider-self:true}")
    private boolean providerSelf;
    private int index = 0;
    private RestTemplate restTemplate = new RestTemplate();

    private String getProvider() {
        if (this.providers == null || this.providers.length == 0) {
            return null;
        }
        int i = this.index % this.providers.length;
        ++this.index;
        return this.providers[i];
    }

    @Override
    public List<NotifyResponse> notifyLogout(List<NotifyRequest> requests) {
        if (this.providerSelf && requests.size() < 2) {
            return NotifyExecutor.execute(requests);
        }
        String provider = this.getProvider();
        if (provider == null) {
            if (this.providerSelf) {
                return NotifyExecutor.execute(requests);
            }
            String emsg = "\u6ca1\u6709\u914d\u7f6egac.assist.notify-logout.providers\u3002\u5e76\u4e14gac.assist.notify-logout.provider-self\u4e3afalse";
            logger.error(emsg, new Object[0]);
            throw new GwValidateException(emsg);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String bodyStr = GwJSON.toJson(requests).toJSONString();
        HttpEntity httpEntity = new HttpEntity((Object)bodyStr, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        try {
            responseEntity = this.restTemplate.exchange(provider, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5411\u5730\u5740:{}\u53d1\u9001\u56de\u8c03\u4efb\u52a1\u53d1\u751f\u9519\u8bef.", new Object[]{provider});
        }
        if (responseEntity != null && responseEntity.getStatusCodeValue() == 200) {
            String body = (String)responseEntity.getBody();
            List res = (List)GwJSON.toJson((Object)body).toBean((GkTypeReference)new GkTypeReference<List<NotifyResponse>>(){});
            return res;
        }
        return NotifyExecutor.execute(requests);
    }
}

