/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.gas.assist.notifylogout.tools;

import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyRequest;
import com.geoway.landteam.gas.assist.notifylogout.mo.NotifyResponse;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NotifyExecutor
implements Supplier<NotifyResponse> {
    private static final GiLoger log = GwLoger.getLoger(NotifyExecutor.class);
    public static String CharsetName = "UTF-8";
    private NotifyRequest notifyRequest = null;

    public NotifyExecutor(NotifyRequest request) {
        this.notifyRequest = request;
    }

    public static List<NotifyResponse> execute(List<NotifyRequest> requests) {
        ArrayList<NotifyResponse> responses = new ArrayList<NotifyResponse>();
        if (requests == null || requests.size() == 0) {
            return responses;
        }
        if (requests.size() == 1) {
            NotifyRequest req = requests.get(0);
            NotifyResponse resp = new NotifyExecutor(req).get();
            responses.add(resp);
            return responses;
        }
        ArrayList<CompletableFuture<NotifyResponse>> futures = new ArrayList<CompletableFuture<NotifyResponse>>();
        for (NotifyRequest req : requests) {
            futures.add(CompletableFuture.supplyAsync(new NotifyExecutor(req)));
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        try {
            combinedFuture.get();
        }
        catch (Exception e) {
            return responses;
        }
        for (CompletableFuture completableFuture : futures) {
            try {
                NotifyResponse res = (NotifyResponse)completableFuture.get();
                responses.add(res);
            }
            catch (Exception e) {
                responses.add(new NotifyResponse().failtureResponse("\u8bf7\u6c42\u53d1\u751f\u9519\u8bef"));
            }
        }
        return responses;
    }

    @Override
    public NotifyResponse get() {
        NotifyResponse res = new NotifyResponse();
        this.sendRequest(res);
        Gw.log.info("\u5411->client:{}\u53d1\u9001\u6ce8\u9500\u8bf7\u6c42,url:{},accessToken:{},result:{}", new Object[]{this.notifyRequest.getClientId(), this.notifyRequest.getUri(), this.notifyRequest.getToken(), res});
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(NotifyResponse res) {
        URL url = null;
        try {
            url = new URL(this.notifyRequest.getUri());
        }
        catch (Exception e) {
            res.failtureResponse("\u521b\u5efaURL\u8bf7\u6c42\u5730\u5740\u53d1\u751f\u9519\u8bef");
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("access_token", this.notifyRequest.getToken());
        String data = null;
        try {
            data = NotifyExecutor.mapToUrl(param, true);
        }
        catch (Exception e) {
            res.failtureResponse("\u8f6c\u7801\u53c2\u6570\u53d1\u751f\u9519\u8bef");
            return;
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
        }
        catch (Exception e) {
            res.failtureResponse("\u521b\u5efaHttpURLConnection\u5bf9\u8c61\u53d1\u751f\u9519\u8bef");
            return;
        }
        conn.setDoOutput(true);
        conn.setDoInput(true);
        try {
            conn.setRequestMethod("POST");
        }
        catch (Exception e) {
            res.failtureResponse("HttpURLConnection\u8bbe\u7f6ePOST\u53d1\u751f\u9519\u8bef");
            return;
        }
        conn.setUseCaches(false);
        conn.setConnectTimeout(1000);
        conn.setReadTimeout(1000);
        conn.setInstanceFollowRedirects(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(conn.getOutputStream());
        }
        catch (Exception e) {
            res.failtureResponse("HttpURLConnection.getOutputStream\u6253\u5f00\u8fdc\u7a0b\u8fde\u63a5\u53d1\u751f\u9519\u8bef");
            return;
        }
        try {
            out.write(data.getBytes(CharsetName));
            out.flush();
        }
        catch (Exception e) {
            res.failtureResponse("\u5411\u8fdc\u7a0b\u53d1\u9001\u6570\u636e\u53d1\u751f\u9519\u8bef");
            return;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception e) {
                res.failtureResponse("\u65ad\u5f00\u8fde\u63a5\u53d1\u751f\u9519\u8bef");
                return;
            }
        }
        int code = 0;
        try {
            code = conn.getResponseCode();
        }
        catch (Exception e) {
            res.failtureResponse("\u83b7\u53d6\u8fd4\u56de\u72b6\u6001\u7801\u53d1\u751f\u9519\u8bef");
            return;
        }
        BufferedReader br = null;
        try {
            br = code != 200 ? new BufferedReader(new InputStreamReader(conn.getErrorStream(), CharsetName)) : new BufferedReader(new InputStreamReader(conn.getInputStream(), CharsetName));
        }
        catch (Exception e) {
            res.failtureResponse("\u83b7\u53d6\u7ed3\u679c\u8f93\u5165\u6d41\u53d1\u751f\u9519\u8bef");
            return;
        }
        StringBuffer sb = new StringBuffer();
        String lines = null;
        try {
            while ((lines = br.readLine()) != null) {
                sb.append(lines);
            }
        }
        catch (Exception e) {
            res.failtureResponse("\u8bfb\u53d6\u7ed3\u679c\u53d1\u751f\u9519\u8bef");
            return;
        }
        try {
            br.close();
            conn.disconnect();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        res.successResponse(sb.toString());
    }

    public static String mapToUrl(Map<String, Object> data, boolean encodeValue) throws Exception {
        if (data.isEmpty()) {
            return null;
        }
        StringBuffer param = new StringBuffer();
        Object value = null;
        for (String key : data.keySet()) {
            value = data.get(key);
            if (value == null) continue;
            param.append(key).append("=");
            param.append(encodeValue ? URLEncoder.encode(data.get(key).toString(), CharsetName) : value.toString());
            param.append("&");
        }
        return param.substring(0, param.length() - 1);
    }

    private static void trustAllHttpsCertificates() {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            Gw.log.error((Throwable)e);
        }
    }

    public static void ignoreSsl() {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                log.warn("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost(), new Object[0]);
                return true;
            }
        };
        NotifyExecutor.trustAllHttpsCertificates();
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    static {
        NotifyExecutor.ignoreSsl();
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

