package com.geoway.landteam.landcloud.servface.base;


import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.dto.BasicIdInfo;

import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import org.springframework.data.domain.Page;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

/**
 * 创建人: 张俊
 * 创建时间: 2022/6/23 11:40
 * 描述:
 */

public interface AppBasicService  {


    public void add(HttpServletRequest request, Long userId, boolean addOrg) throws IOException, SQLException;


    // 上传到个人云的重构版
    public void addOfRestructure(HttpServletRequest request, Long userId, boolean addOrg) throws Exception;


    // 上传到单位云的重构版
    public List<BasicIdInfo> add2OfRestructure(HttpServletRequest request, Long userId, boolean addSelf) throws Exception;

    // 上传到单位云的重构版
    public List<com.geoway.landteam.landcloud.core.model.pub.dto.BasicIdInfo> add2OfRestructureBySc(HttpServletRequest request, Long userId, boolean addSelf, String source) throws Exception;


//    public String getXzqmcByPont(String taskId, double dLon, double dLat);


    public List<BasicIdInfo> add2(HttpServletRequest request, Long userId, boolean addSelf) throws IOException, SQLException;


    public Page<AppBasic> getPageByFilter(String filterParam, String sortParam, int start, Integer limit);

    public List getBasicListByExtent(String userid, Float xmin, Float xmax, Float ymin, Float ymax);

    public void save(AppBasic basic);

    public AppBasic findOne(String id);

    public boolean exist(String id);

    public void saveAll(List<AppBasic> basics);

    public void deleteBasics(List<AppBasic> basics);

    public AppBasic uploadMyCloudId(String id, String myCloudId, String wkt);

    public AppBasic getDetailById(String id, String userId, String filterParam, String sortParam);

    public AppBasic getDetailById(String id, String userId);

    public AppBasic getDetailById(String id) throws Exception;

    public AppMedia getFirstPhont(String id);

    public long queryOfPhotoCount(String id);

    public void doCollect(List ids, int isCollect);

    public List<AppBasic> getAppBasicByCollect(int isCollect, Long userId);

    public AppBasic deleteOne(String id);

    public int deleteByIds(String ids);

    /**
     * 同步时删除，直接删除，不放回收站
     *
     * @param ids
     */
    public void deleteByIds(List<String> ids);

    public void updateServerPath();


    // 恢复删除的随手拍
    public int recoverByIds(String ids) throws Exception;

    // 恢复所有的随手拍
    public void recoverAll(Long userId) throws Exception;

    // 彻底删除随手拍
    public int shiftDeleteByIds(String ids) throws Exception;

    // 获取单位的随手拍列表
    public Page<AppBasic> getMyOrgList(Long userId, int start, int limit, String filterParam, String sortParam, String organizationId);

    public AppBasic getDetailByIdAndOwnerId(Long userId, String id, String ownerId, String filterParam, String sortParam);

    public AppBasic getMyShareDetail(String shareId, Long userId, String filter);

    public List<AppBasic> getBasicListByIds(List tbids, long userId);


    // 构造成多业务表的字段参数模式
    public JSONObject buildJSONParam(String userId, String tbId);

    /**
     * 更新经纬度坐标
     *
     * @param id
     * @return
     */
    public boolean updateLonLatById(String id);


}
