package com.geoway.landteam.landcloud.servface.businessapps;

import com.geoway.landteam.landcloud.model.businessapps.dto.BusAppsInfoDto;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsApproveRecordPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsInfoPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsManagerPo;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.platform.businessapps.servface.bus
 * @date 2023/4/14 11:02
 */
public interface BusAppsInfoService {


    BusAppsInfoPo addBusApps(String userId, MultipartFile logfile, MultipartFile loginfile,
                             MultipartFile backgroundfile, BusAppsInfoPo busAppsInfoPo, List<String> busFunctionIds);

    BusAppsInfoPo updateBusApps(String userId, MultipartFile logfile, MultipartFile loginfile,
                                MultipartFile backgroundfile, BusAppsInfoPo busAppsInfoPo, List<String> busFunctionIds) throws Exception;

    BusAppsInfoDto findBusAppsDetailsById(String appsId);

    void delBusApps(String userId, String appsId);

   void saveBusAppsConfig(String userId, String orgId, String appsId) throws Exception;

   void addBusAppsManagers(String appsId, List<String> userIds);

   void addOrUpdateBusAppsManagers(String appsId, List<BusAppsManagerPo> busAppsManagerPos);

   void publishBusApplication(String appsId);

   void cancelBusApplication(String appsId);

    BusAppsApproveRecordPo addBusAppsApproveRecord(String userId, String orgId, BusAppsApproveRecordPo record) throws Exception;

    List<BusAppsInfoDto> loginInfo(String platformUrl);

    int getCount(String primaryField, String Fid);
}
