package com.geoway.landteam.landcloud.servface.cgjcyj;

import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorDomain;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.*;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjDlVersion;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjTask;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;

import java.util.List;
import java.util.Map;

public interface MCgjcyjTaskService {

    CgjcyjConfig getConfig();

    void UpdateClue(List<Map<String,Object>>updateDatas, JcClueSource clue, String taskId);

    public Integer getUpdateCount(String batchId);
    CgjcyjTask createCgjcyjTask(String sourceId, String batchId, String sourceName, String userId) throws Exception;

    CgjcyjTask createCgjcyjTask(String userId,String batchId);

    List<CgjcyjTask>getCreateByShard(int total, int index);

    List<CgjcyjTask>getRunningByShard(int total, int index);


    boolean startTask(CgjcyjTask task);

    boolean progressQuery(CgjcyjTask task);

    CgjcyjResutList list(CgjcyjSearch param) throws Exception;

    Boolean cancleWarn(String id,Integer warnType);

    Boolean updateDl(String id,String yjdl,String ejdl,String userId);

    List<CgjcyjDlVersion>getDlVersion(String id);

    List<CgjcyjTbidbh>getSameBhTbBySameBh(String sameBh,String batchId);

    List<CgjcyjTbidbh>getNeighbourTbByTbid(String tbid,String batchId);

    List<CgjcyjTbidbh>getMaxAreaTbByTbid(String tbid,String batchId);

    Integer getWarnCount(String batchId);

    CgjcyjBatchList getBatchList(int page, int pageSize, int state, String name);

    List<EnumeratorDomain> getYjdl();

    List<EnumeratorDomain> getEjdl();

    List<EnumeratorDomain> getJcrw();
}
