package com.geoway.landteam.landcloud.servface.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;

import java.util.Map;

/**
 * @Author: zkn
 * @Date: 2020/6/19 10:16
 * @Description:
 */
public interface MITaskAssignService {
    /**
     * 下发任务，说明：groups工作组集合和orgs 下发人员集合不能同时为空
     *
     * @param userId 用户id
     * @param taskId 任务id
     * @param tasks  图斑id集合
     * @param groups 工作组集合
     * @param orgs   下发人员集合
     */
    void assignTask(Long userId, String taskId, JSONArray tasks, JSONArray groups, JSONArray orgs);

    /**
     * 按条件进行批量下发
     * @param userId
     * @param taskId
     * @param groups
     * @param orgs  下发人员集合
     * @param taskQueryParameter  条件参数
     */
    void assignTaskByConditionFilter(Long userId, String taskId, JSONArray groups, JSONArray orgs, TaskQueryParameter
            taskQueryParameter,JSONObject params);

    /**
     * 下发
     *
     * @param parameter 下发任务参数
     */
    void doAssign(TaskDataDbParameter parameter);

    /**
     * 任务下发人员记录
     * @param taskId
     * @param dataId
     * @return
     */
    Map<String,Object> queryAssignUserRecord(String taskId, String dataId, int page, int rows);
    /**
     * 任务下发人员记录
     * @param taskId
     * @param dataId
     * @return
     */
    Map<String,Object> getAssignRecordList(String taskId, String dataId, int page, int rows);
}
