package com.geoway.landteam.landcloud.servface.customtask.task;

import com.geoway.landteam.customtask.pub.enm.ByteOperator;
import com.geoway.landteam.customtask.pub.entity.TbSyncStatus;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.function.IntBinaryOperator;

/**
 * @Author Waves
 * @Date 2023/9/14
 * @Description
 **/
public interface MTbSyncStatusService {

    Integer SYNC_TB = 0b00000001;
    Integer SYNC_CAPTURE = 0b00000010;
    Integer SYNC_TB_JA = 0b00000100;
    Integer SYNC_CAPTURE_JA = 0b00001000;
    void changeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull String tbid, @NotNull Integer status, ByteOperator mapper);

    default void changeStatus(TbSyncStatus status){
        changeStatus(status.getObjectType(),status.getObjectId(),status.getTbid(),status.getStatus(),ByteOperator.SETTER);
    }
    List<TbSyncStatus> getStatusByObjectIdAndTbids(Integer objectType, String objectId, List<String> tbids);

    public void changeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull List<String> tbids, @NotNull Integer status,@NotNull  ByteOperator operator);

    Integer getStatusByTbid(@NotNull Integer objectType, @NotNull String objectId, @NotNull String tbid);

    List<TbSyncStatus> getStatusByTaskAndMask(@NotNull Integer objectType, @NotNull String objectid, @NotNull Integer status,@NotNull ByteOperator operator);
}
