package com.geoway.landteam.landcloud.servface.datacq;


import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbBizProjectHistory;

/**
 * Created by licong on 2020/6/15.
 * 基本农田占用项目回退
 * 主要涉及BackDataService、TaskResouceService、BackDataService、ImportDataService
 * 流程简介：
 * 占用基本农田（由我方创建的项目）：
 * 外网上交操作时会把数据上传至内网，内网推送至苍穹，苍穹会做业务审批操作，他们的每个步骤都会调用我们的接口将他们最新的数据传递过来，根据报送类型bslx字段判断数据是更新或者是保存历史数据
 * 例如：首次推送时，project表中的bslx字段为空，则将project表对应数据保存至history表，并更新project表，如果推送过来的bslx和project表中的一致，则仅更新project表。
 * 当bslx改变，1，保存历史数据后，需把project表中的旧数据删除（不然一个biz会对应两个project），同时需要把数据推送至外网，外网与内网做相同操作。如果这个步骤有问题会影响到回退功能。
 *
 * 如果推送过来的是回退，1，修改内网project数据状态（标记回退），将回退意见传递至外网，2，reviewProject方法，外网复制数据，将旧有数据标记为del，3,上交数据至内网，将内网旧数据标记为del
 */
public interface BackDataService {
    /**
     * 外网回退功能，生成数据
     * @param bizId
     * @param message(旧版的返回的只是审核信息，新版的返回的是苍穹传过来的信息)
     * @param checkId
     * @throws Exception
     */
    public TskTaskBiz reviewProject(String bizId, String message, String checkId, String checkStatus) throws Exception;

    /**
     * 内网回退功能，保存历史数据，保存回退信息（用于内网展示，外网推送回内网后将标记为删除）
     * @param bizId
     * @param message
     * @throws Exception
     */
//    public void backProjectLan(String bizId, String message, String checkId) throws Exception;
    public void reviewProjectLan(String bizId, String message);

    /**
     * 内网回退至外网的数据再次提交至内网时，将旧有的数据标记为删除（改数据已在reviewProjectLan接口中保存至历史表中）
     * 回退的流程会重新生成biz表
     * @param oldBizId
     */
    public void backLan(String oldBizId, String newBizId, String newProjectId);

    public void backLanThread(String oldBizId, String newBizId, String newProjectId);

    public TbBizProjectHistory copyHistoryProject(String newProjectId, TaskBizProject oldProject);

    public TaskBizProject copyProject(TaskBizProject oldProject);

    public void copyStatistics(String oldProjectId, String newProjectId, String newTableid, String newTableName);
}
