package com.geoway.landteam.landcloud.servface.datacq;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.dto.BaseResponse;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created by Walt Chiang(JY)) on 2020/8/24.
 */
public interface TaskResouceService {

    /**
     * 对信息中心接口，接口要求：
     * 报建编号，用地范围（GeoJSON），//空间检测结果（JSON），照片压缩文件包（报建编号+时间命名）
     *
     * @param bjbh
     * @return
     */
    BaseResponse getResult(String namespace, String apiname, String bjbh);


    /**
     *苍穹保存数据接口，业务办理数据保存时调用，启用事务
     * @param obj 数据对象
     * @param  usetype 项目类型
     * @return
     */
    public void saveTransaction(JSONObject obj, String usetype) throws Exception;

    /**
     * 创建步移式选址zip，包含//空间检测结果（JSON），照片压缩文件包（报建编号+时间命名）
     *
     * @param bjbh
     * @return
     */
    String createResultDataFile(String namespace, String apiname, String bjbh) throws IOException;

    /**
     * 步移式选址数据更新接口（给信息中心）
     * @param json
     */
    public void importBysxzData(String json) throws Exception;

    /**
     * 举报信息下发图斑
     * @param json
     */
    public String importReportData(String json) throws Exception;

    /**
     * 通过ids获取相关外业核实信息
     * @param
     */
    public List <Map> selectReportByIDs(List<String> ids) throws Exception;

    /**
     * 通过id获取所有举报外业核实信息
     * @param
     */
    public Map getReportByID(String id) throws Exception;

    /**
     * 苍穹推送数据接口，推送不占用基本农田数据，保存历史数据
     * @param map
     */
    public void updateCqData(JSONObject map) throws Exception;

    /**
     * 保存数据至数据表，步移式选址、监测监管、审批备案
     * @param object 数据
     * @param applicationApi 映射配置
     * @param type 数据类型，用于处理geometry数据，1步移式选址，2审批备案，3监测监管（类型2停用，实现类重写）  4批后监管
     * @return
     */
    public String saveData(JSONObject object, TbtskApplicationApi applicationApi, Integer type) throws Exception ;

    /**
     * 占用基本农田类型，保存苍穹推送的信息
     * @param message
     * @param bizid
     */
    public void saveCheckMessage(String message, String bizid);

    /**
     * 审批备案下发
     * @param obj
     * @throws Exception
     */
    public void assign(JSONObject obj) throws Exception;

    /**
     * 我方发起的占用基本农田项目
     * @param obj
     */
    public void updateProject(JSONObject obj) throws Exception;

    /**
     * 我方发起的占用基本农田项目
     * @param obj
     */
    public void updateProject(TaskBizProject oldProject, JSONObject obj) throws Exception;

    /**
     * 审批备案是否已完成
     * @param xmbh 项目编号，之后可能会加参数ywid
     * @return
     */
    public boolean hasComplete(String xmbh);

    /**
     * 获取项目对应罪行的ywid
     * @param tableName
     * @param xmbh
     * @return
     */
    public String getLatestYwid(String tableName, String xmbh) throws Exception;

    /**
     * 用途管制处数据更新接口
     * 获取pg库中对应项目，将原有数据保存至历史表，更新数据
     * @param xmbh
     * @param xmmc
     * @param bslx
     * @param space
     */
    public void updatePrjectYtgzc(String xmbh, String xmmc, String bslx, String space) throws Exception;

    /**
     * 新增耕地接收数据推送（给信息中心）
     * @param json
     */
    public void importXzgdData(String json) throws Exception;

    /**
     * 获取配置映射字段信息
     * @param tableid
     * @return
     * @throws Exception
     */
    public Map<String, String> getFiledMap(String tableid) throws Exception;
    public Map<String, String> getFiledMap(String tableid, String tag) throws Exception;

    public TaskBizProject getProjectByXmbh(String xmbh) throws  Exception;

    /**
     * 通用接收第三方数据及文件方法
     * @param data
     * @param type
     * @param files
     */
    public void receive(String data, Integer type, MultipartFile[] files) throws Exception;
}
