package com.geoway.landteam.landcloud.servface.datatransfer;

import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;

import java.io.File;
import java.sql.SQLException;

/**
 * @Author Waves
 * @Date 2023/8/1
 * @Description 这里可以参考2.0的编译时注解 @Strategy 用包扫描的形式可以减少很多实现类
 **/
public interface DbResolver {
    String PREFIX = "dbresolver_";

    void resolve(SqlliteConnTool connTool) throws  Exception;

    default void resolve(String path) throws Exception {
        SqlliteConnTool connTool = new SqlliteConnTool(path);
        resolve(connTool);
    }

    default void resolve(File dbFile) throws Exception {
        SqlliteConnTool connTool = new SqlliteConnTool(dbFile.getAbsolutePath());
        resolve(connTool);
    }
}
