package com.geoway.landteam.landcloud.servface.datatransfer;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

/**
 * Created by licong on 2020/6/22.
 */
public interface ExportDataService {
//    /**
//     * 发送导出任务消息，导出所有数据
//     * @param taskId
//     * @param userId
//     * @param isSubmit 是否是基本农田提交
//     * @throws Exception
//     */
//    public void sendMessage(String taskId, Long userId, List<String> ids, Boolean isSubmit) throws Exception;


    /**
     * 导出数据
     * @param taskId 任务主键
     * @param ids 数据id，英文逗号分隔，如果不为空，只生成数据表和filed表（为了让接收者知道数据所属）
     * @param isAppSubmit 是否是app提交数据，如果是则只导出多媒体相关及图斑数据
     * @param isSubmit 是否是基本农田上交项目，如果是则在导入时会调用苍穹接口
     * @param userId 用户信息，用于步移式选址获取pdf文件
     * @param identity 业务系统id，用于文件传输
     * @param userIds 用户id，逗号间隔，用于下发。注：旧版使用f_sendto字段，数据表中必须包含该字段才可完成下发，新版数据表中可不包含该字段
     * @throws Exception
     */
    void export(String taskId, String ids, Boolean isAppSubmit, Boolean isSubmit, String userId, String identity, String userIds) throws Exception;

    /**
     * 仅用于任务配置和图斑信息、媒体文件的同步
     * @param taskId 任务主键
     * @param ids 数据id，英文逗号分隔
     * @param identity 业务系统id，用于文件传输
     * @throws Exception
     */
    default void export(String taskId, String ids, String identity) throws Exception{
        export(taskId,ids,false,false,null,identity,null);
    }

    void createExportData(String resultDbFileDir, TbtskObjectinfo tbtskObjectinfo,
                          TskTaskBiz tskTaskBiz, List<TbtskFields> fieldsList, String ids,
                          Boolean isAppSubmit, String userId, String userIds) throws Exception;

    /**
     * 导出图斑db
     * @param DbFileDir
     * @param taskId
     * @param ids
     * @throws Exception
     */
    void createExportData(String DbFileDir,String taskId, String ids) throws Exception;
    public void createDownloadDataAsync(String taskId, String ids, Boolean isAppSubmit, Boolean isSubmit, String userId, String identity, String userIds);

    /**
     * 创建接口数据
     * @param requestBody 接口的对应参数
     * @param url 跨网段的接口路径
     * @param type 接口的请求方式 （post 或者 get）
     * @param identity 业务系统id，用于文件传输
     * @throws Exception
     */
    void createInterfaceData(JSONObject requestBody, String url, String type, String loginUrl, String identity) throws Exception;

    /**
     * app提交，生成zip
     * @param userId 用户信息，用于步移式选址生成pdf文件
     * @throws Exception
     */
    public void appSubmit(String bizId, String tableName, MultipartFile[] files, String userId, String identity);

    /**
     * 步移式选址内网至外网
     * @param ids
     */
    public void sendBYSXZData(String taskid, String ids) throws Exception;



    /**
     * 获取app提交文件中的数据主键
     * @param tableName
     * @param files
     * @return
     */
    public String getAppSubmitIds(String tableName, MultipartFile[] files) throws SQLException, IOException;

}