package com.geoway.landteam.landcloud.servface.datatransfer;


import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.datatransfer.dto.DataOperate;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created by licong on 2021/9/17.
 */
public interface ExportJsonService {
    /**
     * 删除任务数据，生成json
     */
    public void deleteTaskData(String dataIds, String taskId) throws IOException;
    /**
     * 任务编辑功能，生成json
     * @param taskBiz
     */
    public void editTskTaskBiz(TskTaskBiz taskBiz) throws IOException;

    /**
     * 内业核查，生成json
     * @param data
     * @param bizId
     * @param dataId
     * @param type
     * @param userId
     */
    public void checkTaskData(Map<String, Object> data, String bizId, String dataId, String type,
                              Long userId, String tableName) throws IOException;

    /**
     * 通用更新数据，部分类型数据可能不支持（dategeometry）,只支持更新语句
     * @param tablename 表名
     * @param data 要修改的数据，key字段名，value要修改的值
     * @param where 查询条件，key字段名，value，只支持等于查询
     */
    public void updateTbData(String tablename, List<DataOperate> data, List<DataOperate> where) throws IOException;

    /**
     * 季度监管任务确认
     * @param ids
     * @param tableName
     */
    public void submitTask(List<String> ids, String tableName) throws IOException;
}
