package com.geoway.landteam.landcloud.servface.datatransfer;

import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * Created by licong on 2021/9/17.
 */
public interface ExportTxtService {
    /**
     * 生成txt
     * @param result
     * @param path
     * @param send
     * @return
     * @throws Exception
     */
    public boolean writeTxtData(List<String> result, String path, boolean send) throws Exception;
    public boolean writeTxtData(List<String> result, String path, boolean send, String fileName) throws Exception;

    /**
     * 内网审核，生成txt
     * @param bizId
     * @param message
     * @param checkId
     * @throws Exception
     */
    public void reviewProjectLan(String bizId, String message, String checkId, String checkStatus) throws Exception;

    /**
     * 删除任务，生成txt
     * @param taskId 未处理完
     * @param sync 是否通知苍穹同步删除
     */
    public void deleteTask(String taskId, Long userId, Boolean sync) throws Exception;

    /**
     * 任务下发，生成txt
     * @param data
     * @param isWhole
     */
    public void sendTask(JSONObject data, Boolean isWhole) throws Exception;

    /**
     * 内网发送更新占用基本农田类型数据消息
     * @param message
     * @throws Exception
     */
    public void updateJbnt(String message, String interfaceName) throws Exception;

    /**
     * 图斑回退，内网接口
     * @param bizId
     * @param tbid
     */
    public void backItem(String bizId, String tbid, String reason) throws Exception;
}
