package com.geoway.landteam.landcloud.servface.datatransfer;

import java.io.File;
import java.io.UnsupportedEncodingException;

/**
 * Created by licong on 2020/8/12.
 */
public interface FileTransferService {

    public void sendFile(File file, String identity) throws Exception;

    public void getFile();

    public void sendFile(String filePath) throws UnsupportedEncodingException;

    public void sendFile(String filePath, String identity) throws Exception;

    public void deleteFiletrans(String fileName);

    public String getSignUrl(String appkey, String secret, Long time);

    /**
     * 启动任务时移除所有正在获取的列表
     */
    public void removeProgress();

    /**
     * 文件是否正在处理
     * @param fileid
     * @return
     */
    public Boolean isInProgress(String fileid);

    /**
     * 移除正在处理的文件
     * @param fileid
     */
    public void removeProgress(String fileid);
}
