package com.geoway.landteam.landcloud.servface.oauth;

import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.oauth.OrganizationCertificateResoDto;
import com.geoway.landteam.platform.organization.res3.api.reso.*;
import com.geoway.landteam.platform.organization.res3user.api.ro.MsgRo;
import com.geoway.landteam.platform.organization.res3user.api.ro.OrganizationCertificateRo;
import com.geoway.landteam.platform.organization.res3user.api.ro.OrganizationRo;
import com.gw.base.util.GutilStr;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public interface OauthOrganizationService {
   List<OrganizationRo> getUserOrganization(String pid, Integer type, String orgRegion, String orgName, AuthUserInfo authUserInfo);
   OrganizationReso getOrganization(String id);

   String getOrgFullNameById(String id);
   List<OrganizationReso> getOrganizations(String id, Integer type, String orgRegion, String orgName);
   List<OrganizationTypeReso> getOrganizationTypeList();
   OrganizationPager OrganizationByCodeAndKeyWord(String orgType, String regionName, String sjsf, String keyWord, int page, int rows) throws Exception;

   OrganizationPager getLikelyParentOrg(String sjsf, String orgType, String keyWord, int page, int rows) throws Exception;

   OrganizationCertificateResoDto submitCertificateFile(AuthUserInfo authUserInfo,String orgId, String typeCertificate, MultipartFile file) throws Exception;

   List<OrganizationCertificateResoDto> searchCertificateList(AuthUserInfo authUserInfo,OrganizationCertificateSearchReso searchReso) throws Exception;

   String getCertificateFileAccessUrl(String fileObjectId);

   MsgRo deleteCertificate(String certificateId);

   Boolean hasCertificatePermission(AuthUserInfo authUserInfo);

   List<String> getAllChildIds(String orgId);
}
