package com.geoway.landteam.landcloud.servface.oauth;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserSimpleInfo;
import com.geoway.landteam.landcloud.core.model.user.dto.RegUserInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.model.oauth.*;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserInfoReso;
import com.geoway.landteam.platform.business.res3.api.orguser.reso.BusUserSearchReso;
import com.geoway.landteam.platform.permission.res3user.api.pmc.ro.RoleResourceDetailRo;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserReso;

import java.util.List;

public interface OauthUserService {
    Boolean sendSms(String phone);
    LandUser addUser(String usreName, String regionCode, String midUserId, String busUserId);
    List<RoleResourceDetailRo> getUserResource();

    String getRealName(String busUserId);
    BusUserInfoReso getBusUser(String busUserId);
    BusUserInfoReso getBusUserByPhone(String phoneNumber);
    EpaUserReso getMidtUserByUserName(String userName);
    EpaUserReso getMidtUser(String midUserId);

    EpaUserReso getMidtUser(Long userId);
    EpaUserReso getMidtUserByPhone(String phoneNumber);
    String getUserpasswordByMidUserId(String midUserId);

    boolean match(String userName,String password);

    String getUserRegion(Long userId) throws Exception;

    //Long addUser(AuthUserInfo userInfo);

    BusUserDetailPagerDto listOrganizationAndBusUserPage(BusUserSearchReso searchReso, Integer pageNum, Integer pageSize);


    RegUserDetialDto getRegUserDetial(String id);

    void setUserEnable(Long userId, Integer enable) throws Exception;

    void setUserEnable(String midUserId, Integer enable);

    SyncUserInfo setUserInfo(Long userId, String orgId,String regionCode,String orgRole,String cloudRoleId,String cloudArea) throws Exception;

    void setUserInfo2(Long userId,String phone,String email,String regionCode) throws Exception;
    UserSimpleInfo getUserInfo(Long ownerId, Long userId) throws Exception;

    boolean isPhoneRegistered(String phone);

    void renewPhoneNum(Long userId, String newPhoneNum, String verifyCode);

    void renewPhoneNum(String midUserId, String newPhoneNum);

    void changePasswordByUsername(String username, String password, String oldPassword, String pswtip) throws Exception;

    void changePasswordByPhone( String phone,String code, String password, String pswtip) throws Exception;

    void resetPasswordByAdmin(Long userId,String newPassword) throws Exception;

    void changePasswordByUsername(String username,String newPassword) throws Exception;
    void registerByWeb(WebRegUserInfo user) throws Exception;

    void registerByApp(RegUserInfo user) throws Exception;

    void deleteUser(Long userId,String reason,AuthUserInfo loginUser);

    void changeUserRealName(String userRName,String midUserId);

    String getRoleIdByOrgRole(String orgRole,String regionCode);

    String getOrgRoleByRoleId(String roleIds);

    int getRegionCodeLevel(String regionCode);

    SyncUserInfo addBusUser(ApproveUserInfo regUserInfo) throws Exception;

    void syncAddBusUser(SyncUserInfo syncUserInfo) throws Exception;

    void syncUpdateBusUser(SyncUserInfo syncUserInfo) throws Exception;

    JSONObject queryOfCommonRegister(AuthUserInfo userInfo, String regionCode, String namePhone, String role,String orgId, int page, int size) throws Exception;

    SyncUserInfo addUser(AddUserInfo addUserInfo) throws Exception;

    boolean canViewAppZttj(String orgId);

}
