package com.geoway.landteam.landcloud.servface.patrolclue.caselibrary;



import com.geoway.landteam.patrolclue.model.caselibrary.dto.*;
import com.geoway.landteam.patrolclue.model.caselibrary.entity.*;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author panzhiguang
 * @Package com.geoway.land.caselibrary.service
 * @date 2022/3/15 15:26
 */
public interface MCaseService {

    int deleteByPrimaryKey(String id);

    int insert(JcCaseInfo record);

    int insertSelective(JcCaseInfo record);

    JcCaseInfo selectByPrimaryKey(String fId);

    int updateByPrimaryKeySelective(JcCaseInfo record);

    int updateByPrimaryKey(JcCaseInfo record);

    Map getCaseList(Long userId, String type, String status, String xsbh, String regionCode, String wflx, String caseStage,
                    String dczt, int pageIndex, int pageSize);

    JcCaseLian lianSubmission(Long userId, Integer operate, String caseId, String lianTime, String lianjg, String
            dflrlawh, String syslawh) throws ParseException;

    void lianSubmissionNew(Long userId, JcCaseLianDto jcCaseLianDto) throws Exception;

    JcCaseLian findLianSubmissionData(Long userId, String caseId);

     JcCaseApprove caseApprove(Long userId, String caseId, Integer status, String remark, Integer caseStage, Integer reviewStage);

     List<JcCaseApprove> findCaseApproveRecords(Long userId, String caseId, Integer caseStage);

     List<JcCaseApprove> findCaseApproveLatestRecords(Long userId, String caseId, Integer caseStage);

    void investigationSubmit(Long userId, JcCaseInvestigationDto jcCaseInvestigationDto) throws Exception;

    JcCaseInvestigation getInvestigationInfo(Long userId, String caseId) throws Exception;


    void closeSubmit(Long userId, JcCaseClosedDto jcCaseClosedDto) throws Exception;

    JcCaseClosed getCloseSubmitInfo(Long userId, String caseId);


    Map<String,Object> getCaseStageCount(Long userId, String regionCode, Integer caseStage);

    void caseTrialSubmit(Long userId, JcCaseTrialDto jcCaseTrialDto) throws Exception;

    JcCaseTrial getTrialInfo(Long userId, String caseId);

    /**
     * 新增问题处置数据
     * @param userId
     * @param fid
     * @param fFcczjy
     */
   void syncCaseInfo(Long userId, String fid, String fFcczjy);

   void nonLianSubmit(Long userId, JcCaseNonlianDto jcCaseNonlianDto) throws Exception;

    JcCaseNonlian getNonLianSubmitInfo(Long userId, String caseId) throws Exception;
}
