package com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary;

import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.landcloud.model.pub.dto.ClueFieldsValueParamVo;
import com.geoway.landteam.landcloud.model.pub.dto.JcClueFilterVo;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.*;
import org.locationtech.jts.geom.Geometry;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.web.multipart.MultipartFile;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author cuiwenjing
 * @date 2021/12/5 15:18
 */
public interface MJcClueService {
    public void importData(MultipartFile multipartFile, JcClueSource jcClueSource, Long userid, String sjpc,
                           String jcClueImportRels, Boolean isChange, String jcsj) throws Exception;

    public void asynImportData1(MultipartFile multipartFile, JcClueSource jcClueSource, Long userid, String sjpc,
                                String jcClueImportRels, Boolean isChange, String jcsj) throws Exception;

    public void importClueByTaskData(Long userId, String taskId, String tbId) throws Exception;

    public void syncClueByTaskData(Long userId, String taskId, String tbId, String sourceId, String importRel) throws Exception;

    public void  deleteClueDatas(String sourceId, String recordId, String clueIds)  throws Exception ;

    public void handleImportData(TaskRecord record) throws Exception;

    public void handleCuleDataAsyncImport(TaskRecord record) throws Exception;

    public List<JcClueFields> getJcFieldsByTablename(String tablename);

    public Pair<Long, List<Map>> queryCulelist(CuleQueryParam parameter);
    public Pair<Long, List<Map>> queryCulelistNotPage(CuleQueryParam parameter);

    public void importClueToTaskByCondition(CuleQueryParam parameter);


    public void clueJudgeSubmit(Long userId, JcClueJudge jcClueJudge) throws ParseException;

    public JcClueJudge findClueJudgeInfo(Long userId, String dataId);

    String getClueNum(String xzqdm, String type);

    Map<String,Object> getXzqdmSysOut(Geometry pt, Geometry geo, int proNum) throws SQLException;

    int getColNumOut(Double xLine);


    String saveClueInfo(String sourceId, String clueInfo, MultipartFile shape, String slzb, Long userId) throws Exception;

    public void updateXsInfo(String sourceId,String xsInfo,String clueId);

    public void batchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception;

    public void addBatchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception;

    public void updateBatchUpdateXsInfoByCondition(ClueFieldsValueParamVo clueFieldsValueParamVo) throws Exception;

    public List<JcClueAssignmentPm> findBatchUpdateXsInfoByCondition(String sourceId) throws Exception;

    public JcClueAssignmentPm findBatchUpdateXsInfoByProgrammeId(String programmeId) throws Exception;

    public void delBatchUpdateXsInfoByCondition(String programmeId) throws Exception;


    JcClueFilter addClueFilter(Long userId,JcClueFilterVo jcClueFilterVo);

    JcClueFilter updateClueFilter(Long userId,JcClueFilterVo jcClueFilterVo);

    void delClueFilterById(String id);

    List<JcClueFilter> findClueFilters(String sourceId);

    public byte[] exportExcel(List<Map<String, Object>> maps, String templateFile, String type);

    List<Map<String, Object>> statisticsTbjclxfx(String sourceId,String recordId);

    List<Map<String, Object>> statisticsGdwtbdjfx(String sourceId,String recordId);

    List<Map<String, Object>> statisticsXftbmx(String sourceId,String recordId);

    void addClueSplitProgramme(JcClueSplitProgramme  jcClueSplitProgramme);

    void updateClueSplitProgramme(JcClueSplitProgramme  jcClueSplitProgramme);

    void delClueSplitProgramme(String programmeId);

    List<JcClueSplitProgramme> findClueSplitProgrammes(String sourceId,String programmeName);

    List<JcClueSplitProgramme> findClueSplitProgrammeByClueId(String sourceId,String clueId);

    List<JcClueSplitProgramme> findClueSplitProgrammeByTbId(String taskId,String tbId);

    JcClueSplitProgramme findClueSplitProgrammeDetails(String programmeId);
}
