package com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.CuleGroupDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.dto.JcClueImportTaskRelDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRel;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportTaskRelFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import java.util.List;
import java.util.Map;

/**
 * @author cuiwenjing
 * @date 2021/12/6 21:10
 */
public interface MJcClueSourceService {
    List<JcClueSource> getClueList(Integer state, String sourceName,String appsId);

    JcClueSource findOne(String id);

    JcClueSource findByName(String name);

    JcClueSource findByNameAndAppsId(String name,String appsId);

    JcClueSource findByRemark(String remark);

    List<JcClueSource> findByNameAndSourceId(String sourceId, String name);

    JcClueSource createClueSource(Long userId, String sourceName, String sourceDesc, String parentId, Integer fLevel,
                                  String isNeedTemple, String importtype, String importfiletype, String showtype,
                                  String templeId,String appsId,Integer clueClass);

    void clueSourceRecordMove(String  clueId,String  orderVal,String  orderType,String appsId);

    JcClueSource addClueResouceGroup(JcClueSource bean);

    JcClueSource updatNameById(JcClueSource bean, String templeId);

    JcClueSource clueTrees(String sourceId);

    List<JcClueSource>  getClueAllGroup(Integer state, String sourceName,String appsId);

    List<JcClueSource> getCuleBysourceids(List<String> sourceIdList);

    JcClueSource rootJcClueSource(String sourceId);

   int deleteByPrimaryKey(String id);

    JcClueSource finishCuleSource(JcClueSource jcClueSource, Long userId);


    JSONArray getClueStatistical(String appsId);

    JSONArray getClueStatisticalByDate(String appsId,String startTime,String endTime);

    JSONArray getClueStatisticalByClassAndDate(String appsId,String startTime,String endTime);

    Map<String, List<Map<String, Object>>> getClueStatisticalXzqByDate(String appsId,String startTime,String endTime);

    List<Map<String, Object>> getClueDistStatisticalByDate(String appsId,String startTime,String endTime);

    List<Map<String, Object>> getClueDistStatisticalByClassAndDate(String appsId,String startTime,String endTime);

    JSONArray getAllClueStatistical(String appsId);

    JSONObject getClueStatisticalByMonth(String appsId);

    JSONObject getClueStatisticalBySeason(String appsId);

    JSONObject getClueStatisticalByYear(String appsId);

    JSONObject getClueStatisticalByAll(String appsId);

    Map<String, Object> getClueStatisticalByXzqdm(String xzqdm,String appsId);

    void importCuleTaskData(TaskRecord bean) throws Exception;

    void syncCuleInfo(TaskRecord bean) throws Exception;

    void defaultClueGroup(String sourceId, String tableName);

    void saveFieldGroup(CuleGroupDto culeGroupDto, Long userId) throws Exception;

    void  saveClueKeyLimitData(Long userId, String sourceId, String keyLimitData, String areaRepeatMinValue, String
            areaRepeatPrecent)  throws   Exception;
    void defaultField(JcClueSource jcClueSource);


    void createClueMapperScheme(Long userId, JcClueImportTaskRelDto jcClueImportTaskRelDto) throws Exception;

    List<JcClueImportTaskRel> findClueMapperSchemes(Long userId, String sourceId, String taskId,String type);

    List<JcClueImportTaskRel> findTaskMapperSchemes(Long userId, String taskId,String type);

    List<JcClueImportTaskRelFields> findClueImportTaskRelFields(Long userId, String relId);


    List<JcClueSource> getClueList(Long userId,String appsId);

    List<JcClueSource> getClueListByTempleId(String templeId);

    void  defaultClueImportRel(String sourceId);

    String exportClueDefine(Long userId, String sourceId) throws JAXBException;

    List<TaskRecord> importClueData(HttpServletRequest request, String sourceId, Long userId, String batchId, String batchName,
                                      String batchDesc, String updateType) throws Exception;

    List<TaskRecord> importBatchClueData(HttpServletRequest request, String sourceId, Long userId, String batchId, String batchName,
                                      String batchDesc, String updateType) throws Exception;

    DataDownloadRecord downloadGeometry(String sourceId, String recordId, String tbIds, Long userId, String geoType,Boolean isBatch, DownloadTypeEnum downloadTypeEnum, Integer downloadType);

    Boolean makeViewRelClueAndTask(String sourceId,String recordId,String taskId,Long userId);
}
