package com.geoway.landteam.landcloud.servface.pub;


import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.dto.CommonNum;
import com.geoway.landteam.landcloud.model.resultshare.AppMediaCopyDto2;
import org.springframework.data.domain.Page;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface MAppMediaService {
    List<AppMedia> getMedia(String excludeFrom,String excludeGid,String wkt,String startTime,String endTime,Integer limit)  throws Exception;
    List<Map> uploadTbTxt(HttpServletRequest request, String bizId, String fieldName, String tbId);

    String delTbTxt(Long userId, String tbId, String bizId, String fileName, String fieldName);

    List<AppMedia> queryByGalleryids(List<String> galleryids);

    boolean isExist(String galleryId, String url);

    void save(List<AppMedia> appMediaList);

    int saveOne(AppMedia appMedia);

    boolean deleteRecordAndStorage(List<String> galleryIds);

    /**
     * poi服务代理
     * @param x
     * @param y
     * @param z
     * @return
     * @throws IOException
     */
    public List<AppMedia> getByXYZ(Integer x, Integer y, Integer z) throws IOException;


    /**
     *
     * @param num 格网划分
     * @return
     */
    public List<AppMedia> getMediaByBounds(String xmin, String ymin, String xmax, String ymax, Integer num);

    /**
     * 多媒体数据处理
     * @param appMedias
     * @return
     */
    public List<AppMedia> getAppMedia(List<AppMedia> appMedias);

    /**
     *
     * @param xmin
     * @param ymin
     * @param xmax
     * @param ymax
     * @param num
     * @return
     */
    public List<AppMedia> getAllByBounds(String xmin, String ymin, String xmax, String ymax, Integer num);



    /**
     * 按类型返回统计信息
     * @return
     */
    public List<CommonNum> getStatisticsByType();

    void mediaMount(String taskId, String tbId, JSONObject subMedias);

    Page<AppMedia> findMediaList(String filterParam, String sortParam, int start, int limit);

    Map<String, Object> findMediaDroneList(Integer deviceSource, Integer  type, String  startTime,int page,int rows, String endTime, String sortParam);


    Map<String, Object> getMediaGroupList(Long userId,String  taskId,String  galleryId,String  groupCode,String userName,String  startTime,String  endTime);

    List<AppMediaCopyDto2> getMediaForHebei(String excludeFrom, String excludeGid, String wkt, String startTime, String endTime, Integer limit) throws Exception;
}
