package com.geoway.landteam.landcloud.servface.pub;



import com.geoway.landteam.customtask.pub.dto.TaskNoticeNewDTO;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeNew;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeSubscribe;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;

import java.util.Date;
import java.util.List;

public interface MITaskNoticeNewService {

    /**
     * 添加订阅
     * @param userId
     * @param topic
     */
    void addSubscribe(String userId, String topic);

    /**
     * 批量添加订阅
     * @param subscribeList
     */
    void addSubscribe(List<TaskNoticeSubscribe> subscribeList);

    /**
     * 删除订阅
     * @param userid
     */
    void deleteSubscribeByUserId(String userid);

    /**
     * 删除订阅
     * @param userid
     */
    void deleteSubscribeByUserIdAndTopic(String userid, String topic);

    void deleteSubscribeByUserIdAndBizId(String userid, String bizId);

    void deleteSubscribeByUserIdsAndBizId(List<String> userids, String bizId);

    void deleteSubscribeByUserIdAndBizIdLike(String userId, String like);

    /**
     * 获取订阅信息
     * @param userId
     * @return
     */
    List<String> getTopicsByUserId(String userId);

    /**
     * 获取订阅消息
     * @param
     * @return
     */
    List<String> getTopicsByTopicLike(String userId, String bizId);

    /**
     * 获取订阅消息
     * @param userId
     * @param topic
     * @return
     */
    List<TaskNoticeSubscribe> getSubscribeByUserIdAndTopic(String userId, String topic);

    /**
     * 根据topic获取消息
     * @param topics
     * @return
     */
    List<TaskNoticeNewDTO> getTaskNoticeNewList(String userId, List<String> bizIds, List<String> topics, Date date);

    TaskNoticeNew addTaskNoticeNew(TaskNoticeNew taskNoticeNew);

    List<TaskNoticeNewDTO> getAllTaskNoticeNewByBizId(String bizId, List<String> topics, String userId, Date date);

    List<TaskNoticeNewDTO> getAllTaskNoticeNewByBizIdAndregionCode(String bizId, List<String> topics, String userId,
                                                                   String operAreas, Date date);

    void addTaskNoticeNewList(List<TaskNoticeNew> taskNoticeNewList);

    TaskNoticeUserNew addTaskNoticeUserNew(TaskNoticeUserNew taskNoticeUserNew);

    void addTaskNoticeUserNewList(List<TaskNoticeUserNew> taskNoticeUserNewList);

    TaskNoticeNewDTO findLastedTaskNotice(String userid);

    List<TaskNoticeNew> findTaskNoticeUserNewBybizIdAndTopic(String bizId, String topic);
}
