package com.geoway.landteam.landcloud.servface.suishoupai;


import java.util.List;

import org.springframework.data.domain.Page;

import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.servface.base.dto.AppBasicSimpleInfo;

public interface JctbService {


    public Page<AppBasic> getMyDeletedList(String userIds, String page, String rows, String filterParam, String sortParam);

    // 清空回收站

    public int cleanRecycleBin(String userId) throws Exception;

    public Page<AppBasic> getWorkGroupAppBasics(Long userId, String workGroupId, int start, int limit) throws Exception;


    // 删除工作组中的随手拍

    public int deleteInWorkGroup(Long userId, String workGroupId, String ids) throws Exception;

    // 恢复工作组中的随手拍

    public int recoverInWorkGroup(Long userId, String workGroupId, String ids) throws Exception;

    public int shiftDeleteInWorkGroup(Long userId, String workGroupId, String ids) throws Exception;


    @Deprecated
    public int cleanWorkGroupRecycleBin(Long userId) throws Exception;

    /**
     * 清空回收站
     *
     * @param userId
     * @return
     * @throws Exception
     */
    public int cleanWorkGroupRecycleBin(List<String> groupsList) throws Exception;

    // 获取工作组回收站的随手拍
    public Page<AppBasic> getWorkGroupDeletedList(Long userId, String page, String rows, String filterParam, String sortParam, String workGroupIds) throws Exception;

    // 删除单位随手拍
    public int deleteInOrganization(Long userId, String ids) throws Exception;

    // 获取单位回收站随手拍列表
    public Page<AppBasic> getOrgDeletedList(Long userId, int start, int limit, String filterParam, String sortParam, String organizationId);

    // 恢复单位随手拍
    public int recoverInOrg(Long userId, String ids) throws Exception;


    public int cleanOrgRecycleBin(Long userId, String organizationId) throws Exception;

    public int recoverAllInOrg(Long userId, String organizationId);

    /**
     * 通过用户id 恢复工作组中的随手拍
     *
     * @param userId
     * @return
     */
    @Deprecated
    public int recoverAllInGroup(Long userId);

    public void updateAppBasic(AppBasicSimpleInfo appBasicSimpleInfo);
}
