package com.geoway.landteam.landcloud.servface.tieta;

import com.geoway.landteam.landcloud.model.tieta.dto.*;
import com.geoway.landteam.landcloud.model.tieta.entity.TbCameraInfo;
import com.geoway.landteam.landcloud.model.tieta.paramter.CameraParamter;
import com.geoway.landteam.landcloud.model.tieta.paramter.PtzControlParamter;
import com.geoway.landteam.landcloud.model.tieta.paramter.QueryParameter;
import com.geoway.landteam.landcloud.model.tieta.paramter.TreeCodeParamter;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

/**
 * @Author: xumingjie
 * @Date: 2025/4/3 14:42
 * @Description: TODO
 */
public interface TietaService {

    /**
     *  分页获取监控点资源
     * @param cameraParamter
     * @return
     * @throws Exception
     */
    GetCamerasResponseDTO getCamerasData(CameraParamter cameraParamter) throws Exception;


    /**
     *  获取编码设备 该接口用于获取监控点预览取流URL
     * @param cameraIndexCode
     * @return
     * @throws Exception
     */
    TalkURLResponseDTO getEncodingDevices(String cameraIndexCode) throws Exception;


    /**
     *  名单库管理 人脸名单库查询v2
     * @param personLibIds
     * @return
     * @throws Exception
     */
   FaceLibResponseDTO getFaceDB(String personLibIds) throws Exception;


    /**
     *  区域信息  获取所有树编码
     * @param treeCodeParamter
     * @return
     * @throws Exception
     */
    TreeCodeResponseDTO getAllTreeCode(TreeCodeParamter treeCodeParamter) throws Exception;


    /**
     * 1.1.1.3获取根区域信息
     * @param treeCode
     * @return
     * @throws Exception
     */
    RootRegionResponseDTO getRootRegion(String treeCode) throws Exception;


    /**
     * 1.1.1.4根据区域编号获取下一级区域列表
     * @param parentIndexCode
     * @param treeCode
     * @return
     * @throws Exception
     */
    RootRegionResponseDTO getSubRegion(String parentIndexCode, String treeCode) throws Exception;

    /**
     * 1.1.1.3根据监控点编号进行云台操作
     * @param ptzControlParamter
     * @return
     * @throws Exception
     */
    PtzControlResponseDTO setPtzControl(PtzControlParamter ptzControlParamter) throws Exception;

    /**
     * 1.1.3.5获取所属行政区域
     * @param lon
     * @param lat
     * @return
     * @throws Exception
     */
    LocationResponseDTO getrRegionByLonLat(String lon,String lat )  throws Exception;

    /**
     * 调用摄像头数据并插入数据库
     */
    void startCameraImport() throws Exception;


    /**
     * 查询数据库铁塔数据列表
     * @param param
     * @return
     * @throws Exception
     */
    Pair<Long, List<TbCameraInfo>> queryTbCameraInfoForList(QueryParameter param) throws Exception;

    /**
     * 查询数据库里面铁塔数据详情
     * @param id
     * @return
     */
    TbCameraInfo queryTbCameraInfoById(String id);

    /**
     * 统计铁塔数据
     * @param xzqhCode
     * @return
     */
    Pair<List<Map<String,Object>>, List<Map<String,Object>>> statisticsTieta(String xzqhCode);

    /**
     *  获取铁塔全部数据
     * @return
     * @throws Exception
     */
    Pair<Long, List<TbCameraInfo>> queryAllList() throws Exception;


    /**
     * 周边查找铁塔数据
     * @param lon
     * @param lat
     * @param metre
     * @return
     * @throws Exception
     */
    List<TbCameraInfo> queryNearList(Double lon, Double lat, Integer metre) throws Exception;
}
