package com.geoway.landteam.landcloud.servface.uis;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.uis.dto.SyncUisNodeDTO;
import com.geoway.landteam.landcloud.model.uis.entity.SyncUisData;
//import com.geoway.land.core.syncuis.domain.SyncUisData;
//import com.geoway.land.core.syncuis.dto.SyncUisNodeDTO;

import java.util.List;
import java.util.Map;

/**
 *
 * @author zkn
 * @date 2021年07月23日
 */
public interface SyncUisService {

    /**
     * 注册uis节点
     *
     * @param nodeConfigDTO
     * @param userId
     * @return java.util.Map
     * @author zkn
     * @date 2021/7/23 18:07
     */
    Map nodeRegister(SyncUisNodeDTO nodeConfigDTO, long userId);

    /**
     * 发布同步数据的消息
     *
     * @param data
     * @author zkn
     * @date 2021/7/23 18:07
     */
    void publishSyncMsg(SyncUisData data, String regionFiler);
    /**
     * 发布同步数据的消息
     *
     * @param data
     * @author zkn
     * @date 2021/7/23 18:07
     */
    void publishSyncMsgNew(JSONObject data, String regionFiler);

    void subscribeSyncMsgNew(JSONObject data) throws Exception;

    /**
     * 订阅同步数据的消息
     *
     * @param data
     * @author zkn
     * @date 2021/7/23 18:07
     */
    void subscribeSyncMsg(Object data) throws Exception;

    /**
     * 获取同步uis用户信息的消息队列名称
     * @author zkn
     * @date 2021/7/29
     * @return java.util.List<java.lang.String>
     */
    List<String> getSyncUisQueueName();
}
